/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.util.bytebuddy;

import java.util.ArrayList;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.jar.asm.MethodVisitor;

public abstract class AbstractDelegatingAppender<T>
implements ByteCodeAppender {
    private final int propsSize;

    public AbstractDelegatingAppender(List<T> props) {
        this.propsSize = props.size();
    }

    protected abstract StackManipulation createLocalVar();

    protected abstract StackManipulation usingSwitch();

    protected abstract StackManipulation usingIf();

    protected abstract StackManipulation single();

    public ByteCodeAppender.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext, MethodDescription instrumentedMethod) {
        ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>();
        stackManipulations.add(this.createLocalVar());
        switch (this.propsSize) {
            case 1: {
                stackManipulations.add(this.single());
                break;
            }
            case 2: 
            case 3: {
                stackManipulations.add(this.usingIf());
                break;
            }
            default: {
                stackManipulations.add(this.usingSwitch());
            }
        }
        StackManipulation.Compound compound = new StackManipulation.Compound(stackManipulations);
        StackManipulation.Size operandStackSize = compound.apply(methodVisitor, implementationContext);
        return new ByteCodeAppender.Size(operandStackSize.getMaximalSize(), instrumentedMethod.getStackSize() + 1);
    }
}

