/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.ser;

import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.impl.PropertySerializerMap;
import tools.jackson.module.afterburner.ser.BeanPropertyAccessor;
import tools.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class ObjectMethodPropertyWriter
extends OptimizedBeanPropertyWriter<ObjectMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;

    public ObjectMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, ValueSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    protected ObjectMethodPropertyWriter(ObjectMethodPropertyWriter base, PropertyName name) {
        super(base, name);
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new ObjectMethodPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(ValueSerializer<Object> ser) {
        return new ObjectMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public ObjectMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new ObjectMethodPropertyWriter(this, acc, this._propertyIndex, (ValueSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value;
        if (this.broken) {
            this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.objectGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (value == null) {
            if (this._suppressableValue != null && ctxt.includeFilterSuppressNulls(this._suppressableValue)) {
                return;
            }
            if (this._nullSerializer != null) {
                g.writeName(this._fastName);
                this._nullSerializer.serialize(null, g, ctxt);
            }
            return;
        }
        ValueSerializer ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, ctxt);
        }
        if (this._suppressableValue != null && (MARKER_FOR_EMPTY == this._suppressableValue ? ser.isEmpty(ctxt, value) : this._suppressableValue.equals(value))) {
            return;
        }
        if (value == bean && this._handleSelfReference(bean, g, ctxt, ser)) {
            return;
        }
        g.writeName(this._fastName);
        if (this._typeSerializer == null) {
            ser.serialize(value, g, ctxt);
        } else {
            ser.serializeWithType(value, g, ctxt, this._typeSerializer);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.objectGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, true);
            return;
        }
        if (value == null) {
            if (this._nullSerializer != null) {
                this._nullSerializer.serialize(null, g, ctxt);
            } else if (this._suppressNulls) {
                this.serializeAsOmittedElement(bean, g, ctxt);
            } else {
                ctxt.defaultSerializeNullValue(g);
            }
            return;
        }
        ValueSerializer ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, ctxt);
        }
        if (this._suppressableValue != null) {
            if (MARKER_FOR_EMPTY == this._suppressableValue) {
                if (ser.isEmpty(ctxt, value)) {
                    this.serializeAsOmittedElement(bean, g, ctxt);
                    return;
                }
            } else if (this._suppressableValue.equals(value)) {
                this.serializeAsOmittedElement(bean, g, ctxt);
                return;
            }
        }
        if (value == bean && this._handleSelfReference(bean, g, ctxt, ser)) {
            return;
        }
        if (this._typeSerializer == null) {
            ser.serialize(value, g, ctxt);
        } else {
            ser.serializeWithType(value, g, ctxt, this._typeSerializer);
        }
    }
}

