/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.afterburner.deser.BeanPropertyMutator;
import tools.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;

public final class SettableObjectFieldProperty
extends OptimizedSettableBeanProperty<SettableObjectFieldProperty> {
    private static final long serialVersionUID = 1L;

    public SettableObjectFieldProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableObjectFieldProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableObjectFieldProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        try {
            this._propertyMutator.objectField(ctxt, bean, this._optimizedIndex, value);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, value, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return instance;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        return this.setAndReturn(ctxt, instance, value);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object v) {
        try {
            this._propertyMutator.objectField(ctxt, bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }
}

