/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.afterburner.deser.BeanPropertyMutator;
import tools.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;

public final class SettableLongFieldProperty
extends OptimizedSettableBeanProperty<SettableLongFieldProperty> {
    private static final long serialVersionUID = 1L;

    public SettableLongFieldProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableLongFieldProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableLongFieldProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        if (!p.isExpectedNumberIntToken()) {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        long v = p.getLongValue();
        try {
            this._propertyMutator.longField(ctxt, bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        if (p.isExpectedNumberIntToken()) {
            return this.setAndReturn(ctxt, instance, p.getLongValue());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object value) {
        long v = ((Number)value).longValue();
        try {
            this._propertyMutator.longField(ctxt, bean, this._optimizedIndex, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }
}

