/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.description.field.FieldDescription;
import net.bytebuddy.description.field.FieldList;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.TypeManifestation;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.TypeValidation;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import net.bytebuddy.implementation.bytecode.member.FieldAccess;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodReturn;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.module.afterburner.deser.BeanPropertyMutator;
import tools.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;
import tools.jackson.module.afterburner.deser.SettableBooleanFieldProperty;
import tools.jackson.module.afterburner.deser.SettableBooleanMethodProperty;
import tools.jackson.module.afterburner.deser.SettableIntFieldProperty;
import tools.jackson.module.afterburner.deser.SettableIntMethodProperty;
import tools.jackson.module.afterburner.deser.SettableLongFieldProperty;
import tools.jackson.module.afterburner.deser.SettableLongMethodProperty;
import tools.jackson.module.afterburner.deser.SettableObjectFieldProperty;
import tools.jackson.module.afterburner.deser.SettableObjectMethodProperty;
import tools.jackson.module.afterburner.deser.SettableStringFieldProperty;
import tools.jackson.module.afterburner.deser.SettableStringMethodProperty;
import tools.jackson.module.afterburner.util.ClassName;
import tools.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import tools.jackson.module.afterburner.util.MyClassLoader;
import tools.jackson.module.afterburner.util.bytebuddy.AbstractCreateLocalVarStackManipulation;
import tools.jackson.module.afterburner.util.bytebuddy.AbstractDelegatingAppender;
import tools.jackson.module.afterburner.util.bytebuddy.AbstractPropertyStackManipulation;
import tools.jackson.module.afterburner.util.bytebuddy.SinglePropStackManipulationSupplier;
import tools.jackson.module.afterburner.util.bytebuddy.UsingIfStackManipulation;
import tools.jackson.module.afterburner.util.bytebuddy.UsingSwitchStackManipulation;

public class PropertyMutatorCollector
extends DynamicPropertyAccessorBase {
    private final List<SettableIntMethodProperty> _intSetters = new LinkedList<SettableIntMethodProperty>();
    private final List<SettableLongMethodProperty> _longSetters = new LinkedList<SettableLongMethodProperty>();
    private final List<SettableBooleanMethodProperty> _booleanSetters = new LinkedList<SettableBooleanMethodProperty>();
    private final List<SettableStringMethodProperty> _stringSetters = new LinkedList<SettableStringMethodProperty>();
    private final List<SettableObjectMethodProperty> _objectSetters = new LinkedList<SettableObjectMethodProperty>();
    private final List<SettableIntFieldProperty> _intFields = new LinkedList<SettableIntFieldProperty>();
    private final List<SettableLongFieldProperty> _longFields = new LinkedList<SettableLongFieldProperty>();
    private final List<SettableBooleanFieldProperty> _booleanFields = new LinkedList<SettableBooleanFieldProperty>();
    private final List<SettableStringFieldProperty> _stringFields = new LinkedList<SettableStringFieldProperty>();
    private final List<SettableObjectFieldProperty> _objectFields = new LinkedList<SettableObjectFieldProperty>();
    private final Class<?> beanClass;
    private final TypeDescription beanClassDefinition;

    public PropertyMutatorCollector(Class<?> beanClass) {
        this.beanClass = beanClass;
        this.beanClassDefinition = new TypeDescription.ForLoadedType(beanClass);
    }

    public SettableIntMethodProperty addIntSetter(SettableBeanProperty prop) {
        return this._add(this._intSetters, new SettableIntMethodProperty(prop, null, this._intSetters.size()));
    }

    public SettableLongMethodProperty addLongSetter(SettableBeanProperty prop) {
        return this._add(this._longSetters, new SettableLongMethodProperty(prop, null, this._longSetters.size()));
    }

    public SettableBooleanMethodProperty addBooleanSetter(SettableBeanProperty prop) {
        return this._add(this._booleanSetters, new SettableBooleanMethodProperty(prop, null, this._booleanSetters.size()));
    }

    public SettableStringMethodProperty addStringSetter(SettableBeanProperty prop) {
        return this._add(this._stringSetters, new SettableStringMethodProperty(prop, null, this._stringSetters.size()));
    }

    public SettableObjectMethodProperty addObjectSetter(SettableBeanProperty prop) {
        return this._add(this._objectSetters, new SettableObjectMethodProperty(prop, null, this._objectSetters.size()));
    }

    public SettableIntFieldProperty addIntField(SettableBeanProperty prop) {
        return this._add(this._intFields, new SettableIntFieldProperty(prop, null, this._intFields.size()));
    }

    public SettableLongFieldProperty addLongField(SettableBeanProperty prop) {
        return this._add(this._longFields, new SettableLongFieldProperty(prop, null, this._longFields.size()));
    }

    public SettableBooleanFieldProperty addBooleanField(SettableBeanProperty prop) {
        return this._add(this._booleanFields, new SettableBooleanFieldProperty(prop, null, this._booleanFields.size()));
    }

    public SettableStringFieldProperty addStringField(SettableBeanProperty prop) {
        return this._add(this._stringFields, new SettableStringFieldProperty(prop, null, this._stringFields.size()));
    }

    public SettableObjectFieldProperty addObjectField(SettableBeanProperty prop) {
        return this._add(this._objectFields, new SettableObjectFieldProperty(prop, null, this._objectFields.size()));
    }

    public BeanPropertyMutator buildMutator(MyClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = new MyClassLoader(this.beanClass.getClassLoader(), true);
        }
        ClassName baseName = ClassName.constructFor(this.beanClass, "$Access4JacksonDeserializer");
        Class<?> accessorClass = this.generateMutatorClass(classLoader, baseName);
        try {
            return (BeanPropertyMutator)accessorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + accessorClass.getName() + "': " + e.getMessage(), e);
        }
    }

    public Class<?> generateMutatorClass(MyClassLoader classLoader, ClassName baseName) {
        DynamicType.Builder<?> builder = new ByteBuddy(ClassFileVersion.JAVA_V6).with(TypeValidation.DISABLED).subclass(BeanPropertyMutator.class, (ConstructorStrategy)ConstructorStrategy.Default.DEFAULT_CONSTRUCTOR).name(baseName.getSlashedTemplate()).modifiers(new ModifierContributor.ForType[]{Visibility.PUBLIC, TypeManifestation.FINAL});
        if (!this._intFields.isEmpty()) {
            builder = this._addFields(builder, this._intFields, "intField", MethodVariableAccess.INTEGER);
        }
        if (!this._longFields.isEmpty()) {
            builder = this._addFields(builder, this._longFields, "longField", MethodVariableAccess.LONG);
        }
        if (!this._booleanFields.isEmpty()) {
            builder = this._addFields(builder, this._booleanFields, "booleanField", MethodVariableAccess.INTEGER);
        }
        if (!this._stringFields.isEmpty()) {
            builder = this._addFields(builder, this._stringFields, "stringField", MethodVariableAccess.REFERENCE);
        }
        if (!this._objectFields.isEmpty()) {
            builder = this._addFields(builder, this._objectFields, "objectField", MethodVariableAccess.REFERENCE);
        }
        if (!this._intSetters.isEmpty()) {
            builder = this._addSetters(builder, this._intSetters, "intSetter", MethodVariableAccess.INTEGER);
        }
        if (!this._longSetters.isEmpty()) {
            builder = this._addSetters(builder, this._longSetters, "longSetter", MethodVariableAccess.LONG);
        }
        if (!this._booleanSetters.isEmpty()) {
            builder = this._addSetters(builder, this._booleanSetters, "booleanSetter", MethodVariableAccess.INTEGER);
        }
        if (!this._stringSetters.isEmpty()) {
            builder = this._addSetters(builder, this._stringSetters, "stringSetter", MethodVariableAccess.REFERENCE);
        }
        if (!this._objectSetters.isEmpty()) {
            builder = this._addSetters(builder, this._objectSetters, "objectSetter", MethodVariableAccess.REFERENCE);
        }
        byte[] bytecode = builder.make().getBytes();
        baseName.assignChecksum(bytecode);
        try {
            return classLoader.loadClass(baseName.getDottedName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return classLoader.loadAndResolve(baseName, bytecode);
        }
    }

    private <T extends OptimizedSettableBeanProperty<T>> DynamicType.Builder<?> _addFields(DynamicType.Builder<?> builder, List<T> props, String methodName, MethodVariableAccess beanValueAccess) {
        return builder.method((ElementMatcher)ElementMatchers.named((String)methodName)).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new FieldAppender<T>(this.beanClassDefinition, props, beanValueAccess)}));
    }

    private <T extends OptimizedSettableBeanProperty<T>> DynamicType.Builder<?> _addSetters(DynamicType.Builder<?> builder, List<T> props, String methodName, MethodVariableAccess beanValueAccess) {
        return builder.method((ElementMatcher)ElementMatchers.named((String)methodName)).intercept((Implementation)new Implementation.Simple(new ByteCodeAppender[]{new MethodAppender<T>(this.beanClassDefinition, props, beanValueAccess)}));
    }

    private static class FieldAppender<T extends OptimizedSettableBeanProperty<T>>
    extends AbstractDelegatingAppender<T> {
        private final TypeDescription beanClassDescription;
        private final List<T> props;
        private final MethodVariableAccess beanValueAccess;

        FieldAppender(TypeDescription beanClassDescription, List<T> props, MethodVariableAccess beanValueAccess) {
            super(props);
            this.beanClassDescription = beanClassDescription;
            this.props = props;
            this.beanValueAccess = beanValueAccess;
        }

        @Override
        protected StackManipulation usingSwitch() {
            return new UsingSwitchStackManipulation<T>(LocalVarIndexCalculator.of(this.beanValueAccess), this.props, SingleFieldStackManipulationSupplier.of(this.beanClassDescription, this.beanValueAccess), true);
        }

        @Override
        protected StackManipulation createLocalVar() {
            return CreateLocalVarStackManipulation.of(this.beanClassDescription, this.beanValueAccess);
        }

        @Override
        protected StackManipulation usingIf() {
            return new UsingIfStackManipulation<T>(LocalVarIndexCalculator.of(this.beanValueAccess), this.props, SingleFieldStackManipulationSupplier.of(this.beanClassDescription, this.beanValueAccess), true);
        }

        @Override
        protected StackManipulation single() {
            return new SingleFieldStackManipulation<OptimizedSettableBeanProperty>(this.beanClassDescription, (OptimizedSettableBeanProperty)((Object)this.props.get(0)), this.beanValueAccess);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FieldAppender that = (FieldAppender)o;
            if (!this.beanClassDescription.equals(that.beanClassDescription)) {
                return false;
            }
            if (!this.props.equals(that.props)) {
                return false;
            }
            return this.beanValueAccess == that.beanValueAccess;
        }

        public int hashCode() {
            int result = this.beanClassDescription.hashCode();
            result = 31 * result + this.props.hashCode();
            result = 31 * result + this.beanValueAccess.hashCode();
            return result;
        }
    }

    private static class MethodAppender<T extends OptimizedSettableBeanProperty<T>>
    extends AbstractDelegatingAppender<T> {
        private final TypeDescription beanClassDescription;
        private final List<T> props;
        private final MethodVariableAccess beanValueAccess;

        MethodAppender(TypeDescription beanClassDescription, List<T> props, MethodVariableAccess beanValueAccess) {
            super(props);
            this.beanClassDescription = beanClassDescription;
            this.props = props;
            this.beanValueAccess = beanValueAccess;
        }

        @Override
        protected StackManipulation createLocalVar() {
            return CreateLocalVarStackManipulation.of(this.beanClassDescription, this.beanValueAccess);
        }

        @Override
        protected StackManipulation usingSwitch() {
            return new UsingSwitchStackManipulation<T>(LocalVarIndexCalculator.of(this.beanValueAccess), this.props, SingleMethodStackManipulationSupplier.of(this.beanClassDescription, this.beanValueAccess), true);
        }

        @Override
        protected StackManipulation usingIf() {
            return new UsingIfStackManipulation<T>(LocalVarIndexCalculator.of(this.beanValueAccess), this.props, SingleMethodStackManipulationSupplier.of(this.beanClassDescription, this.beanValueAccess), true);
        }

        @Override
        protected StackManipulation single() {
            return new SingleMethodStackManipulation<OptimizedSettableBeanProperty>(this.beanClassDescription, (OptimizedSettableBeanProperty)((Object)this.props.get(0)), this.beanValueAccess);
        }
    }

    private static class SingleMethodStackManipulation<T extends OptimizedSettableBeanProperty<T>>
    extends AbstractSinglePropStackManipulation<T> {
        private static final TypeDescription OBJECT_TYPE_DESCRIPTION = TypeDescription.ForLoadedType.of(Object.class);

        SingleMethodStackManipulation(TypeDescription beanClassDescription, T prop, MethodVariableAccess beanValueAccess) {
            super(beanClassDescription, prop, beanValueAccess);
        }

        @Override
        protected Class<?> getClassToCastBeanValueTo(AnnotatedMember annotatedMember) {
            Method method = (Method)annotatedMember.getMember();
            return method.getParameterTypes()[0];
        }

        @Override
        protected StackManipulation invocationOperation(AnnotatedMember annotatedMember, TypeDefinition beanClassDescription) {
            String methodName = annotatedMember.getName();
            MethodList matchingMethods = (MethodList)beanClassDescription.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)methodName));
            if (matchingMethods.size() == 1) {
                return MethodInvocation.invoke((MethodDescription)((MethodDescription)matchingMethods.getOnly()));
            }
            if (matchingMethods.isEmpty()) {
                Object klass = beanClassDescription;
                LinkedList<TypeDefinition> toProcess = new LinkedList<TypeDefinition>();
                do {
                    toProcess.addAll((Collection<TypeDefinition>)klass.getInterfaces());
                    if (OBJECT_TYPE_DESCRIPTION.equals(klass) || klass.getSuperClass() == null) {
                        HashSet<TypeDefinition> seen = new HashSet<TypeDefinition>(toProcess);
                        while (!toProcess.isEmpty()) {
                            TypeDefinition iface = (TypeDefinition)toProcess.poll();
                            MethodList<MethodDescription> matches = this.getMatchingMethods(iface, methodName);
                            if (matches.size() == 1) {
                                return MethodInvocation.invoke((MethodDescription)((MethodDescription)matches.getOnly()));
                            }
                            if (matches.size() > 1) {
                                throw new IllegalStateException("Multiple definitions of method " + methodName + " found");
                            }
                            for (TypeDefinition i : iface.getInterfaces()) {
                                if (seen.contains(i)) continue;
                                seen.add(i);
                                toProcess.add(i);
                            }
                        }
                        throw new IllegalStateException("Could not find definition of method: " + methodName);
                    }
                    MethodList<MethodDescription> matches = this.getMatchingMethods((TypeDefinition)klass, methodName);
                    if (matches.size() == 1) {
                        return MethodInvocation.invoke((MethodDescription)((MethodDescription)matches.getOnly()));
                    }
                    if (matches.size() <= 1) continue;
                    throw new IllegalStateException("Multiple definitions of method " + methodName + " found");
                } while ((klass = klass.isInterface() ? OBJECT_TYPE_DESCRIPTION : klass.getSuperClass()) != null);
                throw new IllegalStateException("Could not find definition of method: " + methodName);
            }
            throw new IllegalStateException("Multiple definitions of method " + methodName + " found");
        }

        private MethodList<MethodDescription> getMatchingMethods(TypeDefinition beanClassDescription, String methodName) {
            return (MethodList)beanClassDescription.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)methodName));
        }
    }

    private static class SingleMethodStackManipulationSupplier<T extends OptimizedSettableBeanProperty<T>>
    implements SinglePropStackManipulationSupplier<T> {
        private final TypeDescription beanClassDescription;
        private final MethodVariableAccess beanValueAccess;
        private static Map<Integer, SingleMethodStackManipulationSupplier<?>> cache = new HashMap();

        SingleMethodStackManipulationSupplier(TypeDescription beanClassDescription, MethodVariableAccess beanValueAccess) {
            this.beanClassDescription = beanClassDescription;
            this.beanValueAccess = beanValueAccess;
        }

        static <G extends OptimizedSettableBeanProperty<G>> SingleMethodStackManipulationSupplier<G> of(TypeDescription beanClassDescription, MethodVariableAccess beanValueAccess) {
            int key = beanClassDescription.hashCode() + beanValueAccess.hashCode();
            SingleMethodStackManipulationSupplier<Object> result = cache.get(key);
            if (result == null) {
                result = new SingleMethodStackManipulationSupplier(beanClassDescription, beanValueAccess);
                cache.put(key, result);
            }
            return result;
        }

        @Override
        public StackManipulation supply(T prop) {
            return new SingleMethodStackManipulation<T>(this.beanClassDescription, prop, this.beanValueAccess);
        }
    }

    private static class SingleFieldStackManipulationSupplier<T extends OptimizedSettableBeanProperty<T>>
    implements SinglePropStackManipulationSupplier<T> {
        private final TypeDescription beanClassDescription;
        private final MethodVariableAccess beanValueAccess;
        private static Map<Integer, SingleFieldStackManipulationSupplier<?>> cache = new HashMap();

        SingleFieldStackManipulationSupplier(TypeDescription beanClassDescription, MethodVariableAccess beanValueAccess) {
            this.beanClassDescription = beanClassDescription;
            this.beanValueAccess = beanValueAccess;
        }

        static <G extends OptimizedSettableBeanProperty<G>> SingleFieldStackManipulationSupplier<G> of(TypeDescription beanClassDescription, MethodVariableAccess beanValueAccess) {
            int key = beanClassDescription.hashCode() + beanValueAccess.hashCode();
            SingleFieldStackManipulationSupplier<Object> result = cache.get(key);
            if (result == null) {
                result = new SingleFieldStackManipulationSupplier(beanClassDescription, beanValueAccess);
                cache.put(key, result);
            }
            return result;
        }

        @Override
        public StackManipulation supply(T prop) {
            return new SingleFieldStackManipulation<T>(this.beanClassDescription, prop, this.beanValueAccess);
        }
    }

    private static class SingleFieldStackManipulation<T extends OptimizedSettableBeanProperty<T>>
    extends AbstractSinglePropStackManipulation<T> {
        SingleFieldStackManipulation(TypeDescription beanClassDescription, T prop, MethodVariableAccess beanValueAccess) {
            super(beanClassDescription, prop, beanValueAccess);
        }

        @Override
        protected Class<?> getClassToCastBeanValueTo(AnnotatedMember annotatedMember) {
            return annotatedMember.getRawType();
        }

        @Override
        protected StackManipulation invocationOperation(AnnotatedMember annotatedMember, TypeDefinition beanClassDescription) {
            String fieldName = annotatedMember.getName();
            FieldList matchingFields = (FieldList)beanClassDescription.getDeclaredFields().filter((ElementMatcher)ElementMatchers.named((String)fieldName));
            if (matchingFields.size() == 1) {
                return FieldAccess.forField((FieldDescription)((FieldDescription)matchingFields.getOnly())).write();
            }
            if (matchingFields.isEmpty()) {
                return this.invocationOperation(annotatedMember, (TypeDefinition)beanClassDescription.getSuperClass());
            }
            throw new IllegalStateException("Could not find definition of field: " + fieldName);
        }
    }

    private static abstract class AbstractSinglePropStackManipulation<T extends OptimizedSettableBeanProperty<T>>
    extends AbstractPropertyStackManipulation {
        private final TypeDescription beanClassDescription;
        private final T prop;
        private final MethodVariableAccess beanValueAccess;

        AbstractSinglePropStackManipulation(TypeDescription beanClassDescription, T prop, MethodVariableAccess beanValueAccess) {
            super(LocalVarIndexCalculator.of(beanValueAccess), true);
            this.beanValueAccess = beanValueAccess;
            this.beanClassDescription = beanClassDescription;
            this.prop = prop;
        }

        protected abstract Class<?> getClassToCastBeanValueTo(AnnotatedMember var1);

        protected abstract StackManipulation invocationOperation(AnnotatedMember var1, TypeDefinition var2);

        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
            boolean mustCast = this.beanValueAccess == MethodVariableAccess.REFERENCE;
            ArrayList<Object> operations = new ArrayList<Object>();
            operations.add(this.loadLocalVar());
            operations.add(this.loadBeanValueArg());
            AnnotatedMember member = this.prop.getMember();
            if (mustCast) {
                operations.add(TypeCasting.to((TypeDefinition)new TypeDescription.ForLoadedType(this.getClassToCastBeanValueTo(member))));
            }
            operations.add(this.invocationOperation(member, (TypeDefinition)this.beanClassDescription));
            operations.add(MethodReturn.VOID);
            StackManipulation.Compound compound = new StackManipulation.Compound(operations);
            return compound.apply(methodVisitor, implementationContext);
        }

        private StackManipulation loadLocalVar() {
            return MethodVariableAccess.REFERENCE.loadFrom(this.localVarIndex());
        }

        private StackManipulation loadBeanValueArg() {
            return this.beanValueAccess.loadFrom(this.beanValueArgIndex());
        }

        private int beanValueArgIndex() {
            return 4;
        }
    }

    private static class CreateLocalVarStackManipulation
    extends AbstractCreateLocalVarStackManipulation {
        private static Map<Integer, CreateLocalVarStackManipulation> cache = new HashMap<Integer, CreateLocalVarStackManipulation>();

        CreateLocalVarStackManipulation(TypeDescription beanClassDescription, MethodVariableAccess beanValueAccess) {
            super(beanClassDescription, LocalVarIndexCalculator.of(beanValueAccess), true);
        }

        static CreateLocalVarStackManipulation of(TypeDescription beanClassDescription, MethodVariableAccess beanValueAccess) {
            int key = beanClassDescription.hashCode() + beanValueAccess.hashCode();
            CreateLocalVarStackManipulation result = cache.get(key);
            if (result == null) {
                result = new CreateLocalVarStackManipulation(beanClassDescription, beanValueAccess);
                cache.put(key, result);
            }
            return result;
        }
    }

    private static class LocalVarIndexCalculator
    implements AbstractPropertyStackManipulation.LocalVarIndexCalculator {
        private final MethodVariableAccess beanValueAccess;
        private static Map<MethodVariableAccess, LocalVarIndexCalculator> cache = new HashMap<MethodVariableAccess, LocalVarIndexCalculator>();

        LocalVarIndexCalculator(MethodVariableAccess beanValueAccess) {
            this.beanValueAccess = beanValueAccess;
        }

        public static LocalVarIndexCalculator of(MethodVariableAccess beanValueAccess) {
            LocalVarIndexCalculator result = cache.get(beanValueAccess);
            if (result == null) {
                result = new LocalVarIndexCalculator(beanValueAccess);
                cache.put(beanValueAccess, result);
            }
            return result;
        }

        @Override
        public int calculate() {
            return 4 + (this.beanValueAccess == MethodVariableAccess.LONG ? 2 : 1);
        }
    }
}

