/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.ser;

import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.afterburner.ser.BeanPropertyAccessor;
import tools.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class LongMethodPropertyWriter
extends OptimizedBeanPropertyWriter<LongMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final long _suppressableLong;
    private final boolean _suppressableSet;

    public LongMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, ValueSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableSet = false;
        }
    }

    protected LongMethodPropertyWriter(LongMethodPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableSet = base._suppressableSet;
        this._suppressableLong = base._suppressableLong;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new LongMethodPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(ValueSerializer<Object> ser) {
        return new LongMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public LongMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new LongMethodPropertyWriter(this, acc, this._propertyIndex, (ValueSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.longGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableLong != value) {
            g.writeName(this._fastName);
            g.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.longGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, true);
            return;
        }
        if (!this._suppressableSet || this._suppressableLong != value) {
            g.writeNumber(value);
        } else {
            this.serializeAsOmittedElement(bean, g, ctxt);
        }
    }
}

