/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.util.bytebuddy;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.bytecode.Duplication;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.TypeCreation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.jar.asm.MethodVisitor;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class ConstructorCallStackManipulation
implements StackManipulation {
    private final List<StackManipulation> constructorArgumentLoadingOperations;

    public ConstructorCallStackManipulation() {
        this(new ArrayList<StackManipulation>());
    }

    public ConstructorCallStackManipulation(StackManipulation ... constructorArgumentLoadingOperations) {
        this(Arrays.asList(constructorArgumentLoadingOperations));
    }

    public ConstructorCallStackManipulation(List<StackManipulation> constructorArgumentLoadingOperations) {
        this.constructorArgumentLoadingOperations = null == constructorArgumentLoadingOperations ? new ArrayList() : constructorArgumentLoadingOperations;
    }

    public abstract TypeDescription determineTypeDescription(Implementation.Context var1);

    public abstract MethodDescription.InDefinedShape determineConstructor(TypeDescription var1);

    public boolean isValid() {
        return true;
    }

    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        TypeDescription typeDescription = this.determineTypeDescription(implementationContext);
        ArrayList<Object> stackManipulations = new ArrayList<Object>();
        stackManipulations.add(TypeCreation.of((TypeDescription)typeDescription));
        stackManipulations.add(Duplication.of((TypeDefinition)typeDescription));
        stackManipulations.addAll(this.constructorArgumentLoadingOperations);
        stackManipulations.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)this.determineConstructor(typeDescription)));
        StackManipulation.Compound delegate = new StackManipulation.Compound(stackManipulations);
        return delegate.apply(methodVisitor, implementationContext);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConstructorCallStackManipulation that = (ConstructorCallStackManipulation)o;
        return this.constructorArgumentLoadingOperations != null ? this.constructorArgumentLoadingOperations.equals(that.constructorArgumentLoadingOperations) : that.constructorArgumentLoadingOperations == null;
    }

    public int hashCode() {
        return this.constructorArgumentLoadingOperations != null ? this.constructorArgumentLoadingOperations.hashCode() : 0;
    }

    public static abstract class OfInstrumentedType
    extends ConstructorCallStackManipulation {
        public OfInstrumentedType() {
        }

        public OfInstrumentedType(StackManipulation ... constructorArgumentLoadingOperations) {
            super(constructorArgumentLoadingOperations);
        }

        public OfInstrumentedType(List<StackManipulation> constructorArgumentLoadingOperations) {
            super(constructorArgumentLoadingOperations);
        }

        abstract MethodDescription.InDefinedShape pickConstructor(MethodList<MethodDescription.InDefinedShape> var1);

        @Override
        public TypeDescription determineTypeDescription(Implementation.Context implementationContext) {
            return implementationContext.getInstrumentedType();
        }

        @Override
        public MethodDescription.InDefinedShape determineConstructor(TypeDescription typeDescription) {
            return this.pickConstructor((MethodList<MethodDescription.InDefinedShape>)((MethodList)typeDescription.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor())));
        }

        public static class OneArg
        extends OfInstrumentedType {
            public OneArg() {
            }

            public OneArg(StackManipulation ... constructorArgumentLoadingOperations) {
                super(constructorArgumentLoadingOperations);
            }

            public OneArg(List<StackManipulation> constructorArgumentLoadingOperations) {
                super(constructorArgumentLoadingOperations);
            }

            @Override
            MethodDescription.InDefinedShape pickConstructor(MethodList<MethodDescription.InDefinedShape> candidates) {
                return (MethodDescription.InDefinedShape)((MethodList)candidates.filter((ElementMatcher)ElementMatchers.takesArguments((int)1))).getOnly();
            }
        }
    }

    public static class KnownInDefinedShapeOfExistingType
    extends ConstructorCallStackManipulation {
        private final MethodDescription.InDefinedShape ctor;
        private final TypeDescription typeDescription;

        public KnownInDefinedShapeOfExistingType(MethodDescription.InDefinedShape ctor) {
            this(ctor, new ArrayList<StackManipulation>());
        }

        public KnownInDefinedShapeOfExistingType(MethodDescription.InDefinedShape ctor, StackManipulation ... constructorArgumentLoadingOperations) {
            this(ctor, Arrays.asList(constructorArgumentLoadingOperations));
        }

        public KnownInDefinedShapeOfExistingType(MethodDescription.InDefinedShape ctor, List<StackManipulation> constructorArgumentLoadingOperations) {
            super(constructorArgumentLoadingOperations);
            this.ctor = ctor;
            this.typeDescription = ctor.getDeclaringType();
        }

        @Override
        public TypeDescription determineTypeDescription(Implementation.Context implementationContext) {
            return this.typeDescription;
        }

        @Override
        public MethodDescription.InDefinedShape determineConstructor(TypeDescription td) {
            return this.ctor;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            KnownInDefinedShapeOfExistingType that = (KnownInDefinedShapeOfExistingType)o;
            return this.ctor.equals(that.ctor);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.ctor.hashCode();
            return result;
        }
    }

    public static class KnownConstructorOfExistingType
    extends ConstructorCallStackManipulation {
        private final Constructor<?> ctor;
        private final TypeDescription typeDescription;

        public KnownConstructorOfExistingType(Constructor<?> ctor) {
            this(ctor, new ArrayList<StackManipulation>());
        }

        public KnownConstructorOfExistingType(Constructor<?> ctor, StackManipulation ... constructorArgumentLoadingOperations) {
            this(ctor, Arrays.asList(constructorArgumentLoadingOperations));
        }

        public KnownConstructorOfExistingType(Constructor<?> ctor, List<StackManipulation> constructorArgumentLoadingOperations) {
            super(constructorArgumentLoadingOperations);
            this.ctor = ctor;
            this.typeDescription = new TypeDescription.ForLoadedType(ctor.getDeclaringClass());
        }

        @Override
        public TypeDescription determineTypeDescription(Implementation.Context implementationContext) {
            return this.typeDescription;
        }

        @Override
        public MethodDescription.InDefinedShape determineConstructor(TypeDescription td) {
            return new MethodDescription.ForLoadedConstructor(this.ctor);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            KnownConstructorOfExistingType that = (KnownConstructorOfExistingType)o;
            return this.ctor.equals(that.ctor);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.ctor.hashCode();
            return result;
        }
    }
}

