/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.deser;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.afterburner.deser.BeanPropertyMutator;
import tools.jackson.module.afterburner.deser.OptimizedSettableBeanProperty;

public final class SettableStringMethodProperty
extends OptimizedSettableBeanProperty<SettableStringMethodProperty> {
    private static final long serialVersionUID = 1L;

    public SettableStringMethodProperty(SettableBeanProperty src, BeanPropertyMutator mutator, int index) {
        super(src, mutator, index);
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableStringMethodProperty(del, this._propertyMutator, this._optimizedIndex);
    }

    @Override
    public SettableBeanProperty withMutator(BeanPropertyMutator mut) {
        return new SettableStringMethodProperty(this.delegate, mut, this._optimizedIndex);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        if (!p.hasToken(JsonToken.VALUE_STRING)) {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        String text = p.getString();
        try {
            this._propertyMutator.stringSetter(ctxt, bean, this._optimizedIndex, text);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, text, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this.setAndReturn(ctxt, instance, p.getString());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object value) {
        String text = (String)value;
        try {
            this._propertyMutator.stringSetter(ctxt, bean, this._optimizedIndex, text);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, text, e);
        }
    }
}

