/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.afterburner.ser;

import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.afterburner.ser.BeanPropertyAccessor;
import tools.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public final class IntMethodPropertyWriter
extends OptimizedBeanPropertyWriter<IntMethodPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;

    public IntMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, ValueSerializer<Object> ser) {
        super(src, acc, index, ser);
        if (this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    protected IntMethodPropertyWriter(IntMethodPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableInt = base._suppressableInt;
        this._suppressableIntSet = base._suppressableIntSet;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new IntMethodPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(ValueSerializer<Object> ser) {
        return new IntMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public IntMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new IntMethodPropertyWriter(this, acc, this._propertyIndex, (ValueSerializer<Object>)this._serializer);
    }

    @Override
    public final void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.intGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            g.writeName(this._fastName);
            g.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            return;
        }
        try {
            value = this._propertyAccessor.intGetter(bean, this._propertyIndex);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, true);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            g.writeNumber(value);
        } else {
            this.serializeAsOmittedElement(bean, g, ctxt);
        }
    }
}

