/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import tools.jackson.core.JacksonException;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.ValueReader;

public final class BeanPropertyReader {
    private final String _name;
    private final ValueReader _valueReader;
    private final Method _setter;
    private final Field _field;
    private final int _index;

    public BeanPropertyReader(String string, Field field, Method method, int n) {
        if (field == null && method == null) {
            throw new IllegalArgumentException("Both `field` and `setter` can not be null");
        }
        this._name = string;
        this._field = field;
        this._setter = method;
        this._valueReader = null;
        this._index = n;
    }

    @Deprecated
    public BeanPropertyReader(String string, Field field, Method method) {
        this(string, field, method, -1);
    }

    protected BeanPropertyReader(BeanPropertyReader beanPropertyReader, ValueReader valueReader) {
        this._name = beanPropertyReader._name;
        this._field = beanPropertyReader._field;
        this._setter = beanPropertyReader._setter;
        this._index = beanPropertyReader._index;
        this._valueReader = valueReader;
    }

    public BeanPropertyReader withReader(ValueReader valueReader) {
        return new BeanPropertyReader(this, valueReader);
    }

    public Type genericSetterType() {
        if (this._setter != null) {
            return this._setter.getGenericParameterTypes()[0];
        }
        return this._field.getGenericType();
    }

    public Class<?> rawSetterType() {
        if (this._setter != null) {
            return this._setter.getParameterTypes()[0];
        }
        return this._field.getType();
    }

    public ValueReader getReader() {
        return this._valueReader;
    }

    public String getName() {
        return this._name;
    }

    public int getIndex() {
        return this._index;
    }

    public void setValueFor(Object object, Object[] objectArray) throws JacksonException {
        if (this._setter == null) {
            try {
                this._field.set(object, objectArray[0]);
            }
            catch (Exception exception) {
                this._reportProblem(exception);
            }
            return;
        }
        try {
            this._setter.invoke(object, objectArray);
        }
        catch (Exception exception) {
            this._reportProblem(exception);
        }
    }

    protected String _bean() {
        if (this._setter != null) {
            return this._setter.getDeclaringClass().getName();
        }
        return this._field.getDeclaringClass().getName();
    }

    protected Class<?> _rawType() {
        if (this._setter != null) {
            return this._setter.getParameterTypes()[0];
        }
        return this._field.getType();
    }

    public String toString() {
        return this._name;
    }

    private void _reportProblem(Exception exception) throws JacksonException {
        Throwable throwable = exception;
        if (throwable instanceof InvocationTargetException) {
            throwable = throwable.getCause();
        }
        throw new JSONObjectException("Failed to set property '" + this._name + "'; exception " + exception.getClass().getName() + "): " + throwable.getMessage(), throwable);
    }
}

