/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.ValueReader;
import tools.jackson.jr.ob.impl.JSONReader;

public class SimpleValueReader
extends ValueReader {
    private static final int[] NO_INTS = new int[0];
    private static final long[] NO_LONGS = new long[0];
    protected final int _typeId;

    public SimpleValueReader(Class<?> clazz, int n) {
        super(clazz);
        this._typeId = n;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        switch (this._typeId) {
            case 13: 
            case 14: {
                String string = jsonParser.nextStringValue();
                if (string != null) {
                    return string;
                }
                return this.read(jSONReader, jsonParser);
            }
            case 15: {
                String string = jsonParser.nextStringValue();
                if (string != null) {
                    return string.toCharArray();
                }
                return this.read(jSONReader, jsonParser);
            }
            case 19: 
            case 20: {
                int n = jsonParser.nextIntValue(-2);
                if (n != -2) {
                    return n;
                }
                return this.read(jSONReader, jsonParser);
            }
            case 21: 
            case 22: {
                long l = jsonParser.nextLongValue(-2L);
                if (l != -2L) {
                    return l;
                }
                return this.read(jSONReader, jsonParser);
            }
            case 29: 
            case 30: {
                Boolean bl = jsonParser.nextBooleanValue();
                if (bl != null) {
                    return bl;
                }
                return this.read(jSONReader, jsonParser);
            }
        }
        jsonParser.nextToken();
        return this.read(jSONReader, jsonParser);
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        switch (this._typeId) {
            case 7: {
                return this._readIntArray(jsonParser);
            }
            case 8: {
                return this._readLongArray(jsonParser);
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: {
                throw JSONObjectException.from(jsonParser, "Deserialization of `" + this._valueTypeDesc() + "` not yet supported");
            }
            case 12: {
                return jSONReader.readTree();
            }
            case 13: 
            case 14: {
                return jsonParser.getValueAsString();
            }
            case 15: {
                return jsonParser.getValueAsString().toCharArray();
            }
            case 16: {
                return this._readBinary(jsonParser);
            }
            case 24: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
            }
            case 23: {
                return Float.valueOf((float)jsonParser.getValueAsDouble());
            }
            case 26: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
            }
            case 25: {
                return jsonParser.getValueAsDouble();
            }
            case 17: {
                return (byte)jsonParser.getValueAsInt();
            }
            case 18: {
                return (short)jsonParser.getValueAsInt();
            }
            case 20: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
            }
            case 19: {
                return jsonParser.getValueAsInt();
            }
            case 22: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
            }
            case 21: {
                return jsonParser.getValueAsLong();
            }
            case 28: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return jsonParser.getDecimalValue();
            }
            case 27: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return jsonParser.getBigIntegerValue();
            }
            case 29: 
            case 30: {
                switch (jsonParser.currentTokenId()) {
                    case 9: {
                        return Boolean.TRUE;
                    }
                    case 10: {
                        return Boolean.FALSE;
                    }
                    case 11: {
                        if (this._typeId == 30) {
                            return null;
                        }
                        return Boolean.FALSE;
                    }
                    case 6: {
                        return jsonParser.getValueAsBoolean();
                    }
                }
                break;
            }
            case 31: {
                String string = jsonParser.getValueAsString();
                return Character.valueOf(string == null || string.isEmpty() ? (char)' ' : string.charAt(0));
            }
            case 34: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                long l = this._fetchLong(jsonParser);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                return calendar;
            }
            case 33: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return new Date(this._fetchLong(jsonParser));
            }
            case 35: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                String string = jsonParser.getValueAsString();
                try {
                    return Class.forName(string);
                }
                catch (Exception exception) {
                    throw new JSONObjectException("Failed to bind `java.lang.Class` from value '" + string + "'");
                }
            }
            case 36: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return new File(jsonParser.getValueAsString());
            }
            case 37: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return UUID.fromString(jsonParser.getValueAsString());
            }
            case 38: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                String string = jsonParser.getValueAsString();
                try {
                    return new URL(string);
                }
                catch (IOException iOException) {
                    throw new JSONObjectException("Failed to bind `java.net.URL` from value '" + string + "'");
                }
            }
            case 39: {
                if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                    return null;
                }
                return URI.create(jsonParser.getValueAsString());
            }
            case 40: {
                return this._readPath(jsonParser);
            }
        }
        throw JSONObjectException.from(jsonParser, "Can not create a `" + this._valueTypeDesc() + "` instance out of " + SimpleValueReader._tokenDesc(jsonParser));
    }

    protected byte[] _readBinary(JsonParser jsonParser) throws JacksonException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        if (jsonParser.hasToken(JsonToken.VALUE_STRING) || jsonParser.hasToken(JsonToken.VALUE_STRING)) {
            return jsonParser.getBinaryValue();
        }
        throw new JSONObjectException("Can only bind `byte[]` from Binary value (base64-encoded String or native Binary); not from " + SimpleValueReader._tokenDesc(jsonParser));
    }

    protected Path _readPath(JsonParser jsonParser) throws JacksonException {
        if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        String string = jsonParser.getValueAsString();
        try {
            return Paths.get(string, new String[0]);
        }
        catch (Exception exception) {
            throw new JSONObjectException("Failed to bind `java.nio.file.Path` from value '" + string + "'");
        }
    }

    protected int[] _readIntArray(JsonParser jsonParser) throws JacksonException {
        if (JsonToken.START_ARRAY.equals((Object)jsonParser.currentToken())) {
            jsonParser.nextToken();
        }
        IntStream.Builder builder = IntStream.builder();
        int n = jsonParser.currentTokenId();
        if (n == 4) {
            return NO_INTS;
        }
        block4: while (true) {
            switch (n) {
                case 7: 
                case 8: 
                case 11: {
                    builder.add(jsonParser.getValueAsInt());
                    break;
                }
                case 4: {
                    break block4;
                }
                default: {
                    throw new JSONObjectException("Failed to bind `int` element of `int[]` from value: " + SimpleValueReader._tokenDesc(jsonParser));
                }
            }
            jsonParser.nextToken();
            n = jsonParser.currentTokenId();
        }
        return builder.build().toArray();
    }

    protected long[] _readLongArray(JsonParser jsonParser) throws JacksonException {
        if (JsonToken.START_ARRAY.equals((Object)jsonParser.currentToken())) {
            jsonParser.nextToken();
        }
        LongStream.Builder builder = LongStream.builder();
        int n = jsonParser.currentTokenId();
        if (n == 4) {
            return NO_LONGS;
        }
        block4: while (true) {
            switch (n) {
                case 7: 
                case 8: 
                case 11: {
                    builder.add(jsonParser.getValueAsLong());
                    break;
                }
                case 4: {
                    break block4;
                }
                default: {
                    throw new JSONObjectException("Failed to bind `long` element of `long[]` from value: " + SimpleValueReader._tokenDesc(jsonParser));
                }
            }
            jsonParser.nextToken();
            n = jsonParser.currentTokenId();
        }
        return builder.build().toArray();
    }

    protected long _fetchLong(JsonParser jsonParser) throws JacksonException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return jsonParser.getLongValue();
        }
        throw JSONObjectException.from(jsonParser, "Can not get long numeric value from JSON (to construct " + this._valueTypeDesc() + ") from " + SimpleValueReader._tokenDesc(jsonParser, jsonToken));
    }
}

