/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.comp;

import tools.jackson.core.JsonGenerator;
import tools.jackson.jr.ob.comp.ArrayComposer;
import tools.jackson.jr.ob.comp.ComposerBase;
import tools.jackson.jr.ob.comp.ObjectComposer;

public abstract class SequenceComposer<THIS extends SequenceComposer<THIS>>
extends ComposerBase {
    protected final JsonGenerator _generator;

    public SequenceComposer(JsonGenerator jsonGenerator) {
        this._generator = jsonGenerator;
    }

    @Override
    public void flush() {
        if (this._generator != null) {
            this._generator.close();
        }
    }

    public ArrayComposer<THIS> startArray() {
        this._closeChild();
        return this._startArray(this._this(), this._generator);
    }

    public ObjectComposer<THIS> startObject() {
        this._closeChild();
        return this._startObject(this._this(), this._generator);
    }

    public THIS add(int n) {
        this._generator.writeNumber(n);
        return this._this();
    }

    public THIS add(long l) {
        this._generator.writeNumber(l);
        return this._this();
    }

    public THIS add(double d) {
        this._generator.writeNumber(d);
        return this._this();
    }

    public THIS add(String string) {
        this._generator.writeString(string);
        return this._this();
    }

    public THIS add(CharSequence charSequence) {
        String string = charSequence == null ? null : charSequence.toString();
        this._generator.writeString(string);
        return this._this();
    }

    public THIS addNull() {
        this._generator.writeNull();
        return this._this();
    }

    public THIS add(boolean bl) {
        this._generator.writeBoolean(bl);
        return this._this();
    }

    public THIS addPOJO(Object object) {
        this._generator.writePOJO(object);
        return this._this();
    }

    protected void _closeChild() {
        if (this._child != null) {
            this._child._finish();
            this._child = null;
        }
    }

    protected THIS _this() {
        return (THIS)this;
    }
}

