/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob;

import java.io.CharArrayReader;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.TreeCodec;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.core.Versioned;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.SegmentedStringWriter;
import tools.jackson.core.json.JsonFactory;
import tools.jackson.core.tree.ArrayTreeNode;
import tools.jackson.core.tree.ObjectTreeNode;
import tools.jackson.core.type.ResolvedType;
import tools.jackson.core.type.TypeReference;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.DefaultPrettyPrinter;
import tools.jackson.core.util.Instantiatable;
import tools.jackson.jr.ob.JSONComposer;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.JacksonJrExtension;
import tools.jackson.jr.ob.PackageVersion;
import tools.jackson.jr.ob.ValueIterator;
import tools.jackson.jr.ob.api.CollectionBuilder;
import tools.jackson.jr.ob.api.ExtensionContext;
import tools.jackson.jr.ob.api.MapBuilder;
import tools.jackson.jr.ob.api.ReaderWriterModifier;
import tools.jackson.jr.ob.api.ReaderWriterProvider;
import tools.jackson.jr.ob.comp.CollectionComposer;
import tools.jackson.jr.ob.comp.MapComposer;
import tools.jackson.jr.ob.impl.JSONReader;
import tools.jackson.jr.ob.impl.JSONWriter;
import tools.jackson.jr.ob.impl.ValueReaderLocator;
import tools.jackson.jr.ob.impl.ValueWriterLocator;

public class JSON
implements ObjectReadContext,
ObjectWriteContext,
Versioned {
    static final int DEFAULT_FEATURES = Feature.defaults();
    public static final int CACHE_FLAGS = Feature.cacheBreakers();
    public static final JSON std = new JSON();
    protected final TokenStreamFactory _streamFactory;
    protected final TreeCodec _treeCodec;
    protected final ValueReaderLocator _valueReaderLocator;
    protected final ValueWriterLocator _valueWriterLocator;
    protected final JSONReader _reader;
    protected final JSONWriter _writer;
    protected final int _features;
    protected final PrettyPrinter _prettyPrinter;

    public JSON() {
        this((TokenStreamFactory)new JsonFactory());
    }

    public JSON(TokenStreamFactory tokenStreamFactory) {
        this._features = DEFAULT_FEATURES;
        this._streamFactory = tokenStreamFactory;
        this._treeCodec = null;
        this._valueReaderLocator = ValueReaderLocator.blueprint(tokenStreamFactory, null, null);
        this._valueWriterLocator = ValueWriterLocator.blueprint(null, null);
        this._reader = this._defaultReader();
        this._writer = this._defaultWriter();
        this._prettyPrinter = null;
    }

    public JSON(Builder builder) {
        this._features = builder.featureMask();
        this._streamFactory = builder.streamFactory();
        this._treeCodec = builder.treeCodec();
        ReaderWriterProvider readerWriterProvider = builder.readerWriterProvider();
        ReaderWriterModifier readerWriterModifier = builder.readerWriterModifier();
        ValueReaderLocator valueReaderLocator = ValueReaderLocator.blueprint(this._streamFactory, null, null);
        ValueWriterLocator valueWriterLocator = ValueWriterLocator.blueprint(null, null);
        if (readerWriterProvider != null) {
            valueReaderLocator = valueReaderLocator.with(readerWriterProvider);
            valueWriterLocator = valueWriterLocator.with(readerWriterProvider);
        }
        if (readerWriterModifier != null) {
            valueReaderLocator = valueReaderLocator.with(readerWriterModifier);
            valueWriterLocator = valueWriterLocator.with(readerWriterModifier);
        }
        this._valueReaderLocator = valueReaderLocator;
        this._valueWriterLocator = valueWriterLocator;
        this._reader = builder.jsonReader();
        this._writer = builder.jsonWriter();
        this._prettyPrinter = builder.prettyPrinter();
    }

    public static Builder builder() {
        return JSON.builder(new JsonFactory());
    }

    public static Builder builder(JsonFactory jsonFactory) {
        return new Builder(jsonFactory);
    }

    protected JSON(JSON jSON, int n, TokenStreamFactory tokenStreamFactory, TreeCodec treeCodec, JSONReader jSONReader, JSONWriter jSONWriter, PrettyPrinter prettyPrinter) {
        this._features = n;
        this._streamFactory = tokenStreamFactory;
        this._treeCodec = treeCodec;
        this._valueReaderLocator = jSON._valueReaderLocator;
        this._valueWriterLocator = jSON._valueWriterLocator;
        this._reader = jSONReader;
        this._writer = jSONWriter;
        this._prettyPrinter = prettyPrinter;
    }

    protected JSON(JSON jSON, ValueReaderLocator valueReaderLocator, ValueWriterLocator valueWriterLocator) {
        this._features = jSON._features;
        this._streamFactory = jSON._streamFactory;
        this._treeCodec = jSON._treeCodec;
        this._valueReaderLocator = valueReaderLocator;
        this._valueWriterLocator = valueWriterLocator;
        this._reader = jSON._reader;
        this._writer = jSON._writer;
        this._prettyPrinter = jSON._prettyPrinter;
    }

    protected JSONReader _defaultReader() {
        return new JSONReader(CollectionBuilder.defaultImpl(), MapBuilder.defaultImpl());
    }

    protected JSONWriter _defaultWriter() {
        return new JSONWriter();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public JSON with(PrettyPrinter prettyPrinter) {
        if (this._prettyPrinter == prettyPrinter) {
            return this;
        }
        return this._with(this._features, this._streamFactory, this._treeCodec, this._reader, this._writer, prettyPrinter);
    }

    public JSON with(Feature feature, boolean bl) {
        int n = this._features;
        n = bl ? (n |= feature.mask()) : (n &= ~feature.mask());
        return this._with(n);
    }

    public JSON with(Feature ... featureArray) {
        int n = this._features;
        for (Feature feature : featureArray) {
            n |= feature.mask();
        }
        return this._with(n);
    }

    public JSON without(Feature ... featureArray) {
        int n = this._features;
        for (Feature feature : featureArray) {
            n &= ~feature.mask();
        }
        return this._with(n);
    }

    protected final JSON _with(int n) {
        if (this._features == n) {
            return this;
        }
        JSONReader jSONReader = this._reader.withCacheCheck(n);
        JSONWriter jSONWriter = this._writer.withCacheCheck(n);
        return this._with(n, this._streamFactory, this._treeCodec, jSONReader, jSONWriter, this._prettyPrinter);
    }

    public JSON with(MapBuilder mapBuilder) {
        JSONReader jSONReader = this._reader.with(mapBuilder);
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._streamFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    public JSON with(CollectionBuilder collectionBuilder) {
        JSONReader jSONReader = this._reader.with(collectionBuilder);
        if (jSONReader == this._reader) {
            return this;
        }
        return this._with(this._features, this._streamFactory, this._treeCodec, jSONReader, this._writer, this._prettyPrinter);
    }

    protected JSON _with(int n, TokenStreamFactory tokenStreamFactory, TreeCodec treeCodec, JSONReader jSONReader, JSONWriter jSONWriter, PrettyPrinter prettyPrinter) {
        return new JSON(this, n, tokenStreamFactory, treeCodec, jSONReader, jSONWriter, prettyPrinter);
    }

    public TreeCodec treeCodec() {
        return this._treeCodec;
    }

    public final boolean isEnabled(Feature feature) {
        return (feature.mask() & this._features) != 0;
    }

    public JsonParser createParser(Object object) {
        return this._parser(object);
    }

    public String asString(Object object) throws JacksonException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._streamFactory._getBufferRecycler());
        this._writeAndClose(object, this._streamFactory.createGenerator((ObjectWriteContext)this, (Writer)segmentedStringWriter));
        return segmentedStringWriter.getAndClear();
    }

    public byte[] asBytes(Object object) throws JacksonException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._streamFactory._getBufferRecycler());
        this._writeAndClose(object, this._streamFactory.createGenerator((ObjectWriteContext)this, (OutputStream)byteArrayBuilder, JsonEncoding.UTF8));
        byte[] byArray = byteArrayBuilder.toByteArray();
        byteArrayBuilder.release();
        return byArray;
    }

    public void write(Object object, JsonGenerator jsonGenerator) throws JacksonException {
        this._writerForOperation(jsonGenerator).writeValue(object);
        if (Feature.FLUSH_AFTER_WRITE_VALUE.isEnabled(this._features)) {
            jsonGenerator.flush();
        }
    }

    public void write(Object object, OutputStream outputStream) throws JacksonException {
        this._writeAndClose(object, this._streamFactory.createGenerator((ObjectWriteContext)this, outputStream));
    }

    public void write(Object object, Writer writer) throws JacksonException {
        this._writeAndClose(object, this._streamFactory.createGenerator((ObjectWriteContext)this, writer));
    }

    public void write(Object object, File file) throws JacksonException {
        this._writeAndClose(object, this._streamFactory.createGenerator((ObjectWriteContext)this, file, JsonEncoding.UTF8));
    }

    public JSONComposer<OutputStream> composeUsing(JsonGenerator jsonGenerator) throws JacksonException {
        return JSONComposer.streamComposer(this._features, jsonGenerator, false);
    }

    public JSONComposer<OutputStream> composeTo(OutputStream outputStream) throws JacksonException {
        return JSONComposer.streamComposer(this._features, this._config(this._streamFactory.createGenerator((ObjectWriteContext)this, outputStream)), true);
    }

    public JSONComposer<OutputStream> composeTo(Writer writer) throws JacksonException {
        return JSONComposer.streamComposer(this._features, this._config(this._streamFactory.createGenerator((ObjectWriteContext)this, writer)), true);
    }

    public JSONComposer<OutputStream> composeTo(File file) throws JacksonException {
        return JSONComposer.streamComposer(this._features, this._config(this._streamFactory.createGenerator((ObjectWriteContext)this, file, JsonEncoding.UTF8)), true);
    }

    public JSONComposer<String> composeString() throws JacksonException {
        SegmentedStringWriter segmentedStringWriter = new SegmentedStringWriter(this._streamFactory._getBufferRecycler());
        JsonGenerator jsonGenerator = this._config(this._streamFactory.createGenerator((ObjectWriteContext)this, (Writer)segmentedStringWriter));
        return JSONComposer.stringComposer(this._features, jsonGenerator, segmentedStringWriter);
    }

    public JSONComposer<byte[]> composeBytes() throws JacksonException {
        ByteArrayBuilder byteArrayBuilder = new ByteArrayBuilder(this._streamFactory._getBufferRecycler());
        JsonGenerator jsonGenerator = this._config(this._streamFactory.createGenerator((ObjectWriteContext)this, (OutputStream)byteArrayBuilder));
        return JSONComposer.bytesComposer(this._features, jsonGenerator, byteArrayBuilder);
    }

    public CollectionComposer<?, List<Object>> composeList() {
        ArrayList arrayList = new ArrayList();
        return this.composeCollection(arrayList);
    }

    public <C extends Collection<Object>> CollectionComposer<?, C> composeCollection(C c) {
        return new CollectionComposer(c);
    }

    public MapComposer<?> composeMap() {
        return this.composeMap(new LinkedHashMap<String, Object>());
    }

    public MapComposer<?> composeMap(Map<String, Object> map) {
        return new MapComposer(map);
    }

    public List<Object> listFrom(Object object) throws JacksonException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            List<Object> list = this._readerForOperation(jsonParser).readList();
            jsonParser.clearCurrentToken();
            return list;
        }
        try (JsonParser jsonParser = this._parser(object);){
            List<Object> list;
            this._initForReading(this._config(jsonParser));
            List<Object> list2 = list = this._readerForOperation(jsonParser).readList();
            return list2;
        }
    }

    public <T> List<T> listOfFrom(Class<T> clazz, Object object) throws JacksonException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            List<T> list = this._readerForOperation(jsonParser).readListOf(clazz);
            jsonParser.clearCurrentToken();
            return list;
        }
        try (JsonParser jsonParser = this._parser(object);){
            List<T> list;
            this._initForReading(this._config(jsonParser));
            List<T> list2 = list = this._readerForOperation(jsonParser).readListOf(clazz);
            return list2;
        }
    }

    public Object[] arrayFrom(Object object) throws JacksonException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Object[] objectArray = this._readerForOperation(jsonParser).readArray();
            jsonParser.clearCurrentToken();
            return objectArray;
        }
        try (JsonParser jsonParser = this._parser(object);){
            Object[] objectArray;
            this._initForReading(this._config(jsonParser));
            Object[] objectArray2 = objectArray = this._readerForOperation(jsonParser).readArray();
            return objectArray2;
        }
    }

    public <T> T[] arrayOfFrom(Class<T> clazz, Object object) throws JacksonException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            T[] TArray = this._readerForOperation(jsonParser).readArrayOf(clazz);
            jsonParser.clearCurrentToken();
            return TArray;
        }
        try (JsonParser jsonParser = this._parser(object);){
            T[] TArray;
            this._initForReading(this._config(jsonParser));
            T[] TArray2 = TArray = this._readerForOperation(jsonParser).readArrayOf(clazz);
            return TArray2;
        }
    }

    public Map<String, Object> mapFrom(Object object) throws JacksonException {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Map<String, Object> map = this._readerForOperation(jsonParser).readMap();
            jsonParser.clearCurrentToken();
            return map;
        }
        try (JsonParser jsonParser = this._parser(object);){
            Map<String, Object> map;
            this._initForReading(this._config(jsonParser));
            Map<String, Object> map2 = map = this._readerForOperation(jsonParser).readMap();
            return map2;
        }
    }

    public <T> Map<String, T> mapOfFrom(Class<T> clazz, Object object) {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Map<String, T> map = this._readerForOperation(jsonParser).readMapOf(clazz);
            jsonParser.clearCurrentToken();
            return map;
        }
        try (JsonParser jsonParser = this._parser(object);){
            Map<String, T> map;
            this._initForReading(this._config(jsonParser));
            Map<String, T> map2 = map = this._readerForOperation(jsonParser).readMapOf(clazz);
            return map2;
        }
    }

    public <T> T beanFrom(Class<T> clazz, Object object) {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            T t = this._readerForOperation(jsonParser).readBean(clazz);
            jsonParser.clearCurrentToken();
            return t;
        }
        try (JsonParser jsonParser = this._parser(object);){
            T t;
            this._initForReading(this._config(jsonParser));
            T t2 = t = this._readerForOperation(jsonParser).readBean(clazz);
            return t2;
        }
    }

    public Object anyFrom(Object object) {
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            Object object2 = this._readerForOperation(jsonParser).readValue();
            jsonParser.clearCurrentToken();
            return object2;
        }
        try (JsonParser jsonParser = this._parser(object);){
            this._initForReading(this._config(jsonParser));
            Object object3 = this._readerForOperation(jsonParser).readValue();
            return object3;
        }
    }

    public <T extends TreeNode> T treeFrom(Object object) {
        if (this._treeCodec == null) {
            this._noTreeCodec("read `TreeNode`");
        }
        if (object instanceof JsonParser) {
            JsonParser jsonParser = this._initForReading((JsonParser)object);
            TreeNode treeNode = this._treeCodec.readTree(jsonParser);
            jsonParser.clearCurrentToken();
            return (T)treeNode;
        }
        try (JsonParser jsonParser = this._parser(object);){
            TreeNode treeNode;
            this._initForReading(this._config(jsonParser));
            TreeNode treeNode2 = treeNode = this._treeCodec.readTree(jsonParser);
            return (T)treeNode2;
        }
    }

    public <T> ValueIterator<T> beanSequenceFrom(Class<T> clazz, Object object) {
        boolean bl = !(object instanceof JsonParser);
        JsonParser jsonParser = bl ? this._parser(object) : (JsonParser)object;
        jsonParser = this._initForReading(this._config(jsonParser));
        JSONReader jSONReader = this._readerForOperation(jsonParser);
        return new ValueIterator(1, clazz, jsonParser, jSONReader, this._treeCodec, bl);
    }

    public ValueIterator<Object> anySequenceFrom(Object object) {
        boolean bl = !(object instanceof JsonParser);
        JsonParser jsonParser = bl ? this._parser(object) : (JsonParser)object;
        jsonParser = this._initForReading(this._config(jsonParser));
        JSONReader jSONReader = this._readerForOperation(jsonParser);
        return new ValueIterator<Object>(2, Object.class, jsonParser, jSONReader, this._treeCodec, bl);
    }

    public <T extends TreeNode> ValueIterator<T> treeSequenceFrom(Object object) {
        if (this._treeCodec == null) {
            this._noTreeCodec("read `TreeNode` sequence");
        }
        boolean bl = !(object instanceof JsonParser);
        JsonParser jsonParser = bl ? this._parser(object) : (JsonParser)object;
        jsonParser = this._initForReading(this._config(jsonParser));
        JSONReader jSONReader = this._readerForOperation(jsonParser);
        return new ValueIterator(3, TreeNode.class, jsonParser, jSONReader, this._treeCodec, bl);
    }

    public int getFormatReadFeatures(int n) {
        return n;
    }

    public TokenStreamFactory tokenStreamFactory() {
        return this._streamFactory;
    }

    public StreamReadConstraints streamReadConstraints() {
        return this._streamFactory.streamReadConstraints();
    }

    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws JacksonException {
        if (this._treeCodec == null) {
            this._noTreeCodec("write TreeNode");
        }
        return (T)this._treeCodec.readTree(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws JacksonException {
        T t = this._readerForOperation(jsonParser).readBean(clazz);
        jsonParser.clearCurrentToken();
        return t;
    }

    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) throws JacksonException {
        throw new UnsupportedOperationException("`TypeReference<T>` not support by jackson-jr");
    }

    public <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws JacksonException {
        return this.readValue(jsonParser, resolvedType.getRawClass());
    }

    public FormatSchema getSchema() {
        return null;
    }

    public CharacterEscapes getCharacterEscapes() {
        return null;
    }

    public PrettyPrinter getPrettyPrinter() {
        PrettyPrinter prettyPrinter = this._prettyPrinter;
        if (prettyPrinter != null) {
            if (prettyPrinter instanceof Instantiatable) {
                prettyPrinter = (PrettyPrinter)((Instantiatable)prettyPrinter).createInstance();
            }
            return prettyPrinter;
        }
        if (this.isEnabled(Feature.PRETTY_PRINT_OUTPUT)) {
            return new DefaultPrettyPrinter();
        }
        return null;
    }

    public boolean hasPrettyPrinter() {
        return this._prettyPrinter != null || this.isEnabled(Feature.PRETTY_PRINT_OUTPUT);
    }

    public SerializableString getRootValueSeparator(SerializableString serializableString) {
        return serializableString;
    }

    public int getStreamWriteFeatures(int n) {
        return n;
    }

    public int getFormatWriteFeatures(int n) {
        return n;
    }

    public void writeValue(JsonGenerator jsonGenerator, Object object) throws JacksonException {
        this.write(object, jsonGenerator);
    }

    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) throws JacksonException {
        if (this._treeCodec == null) {
            this._noTreeCodec("write TreeNode");
        }
        this._treeCodec.writeTree(jsonGenerator, treeNode);
    }

    public ArrayTreeNode createArrayNode() {
        if (this._treeCodec == null) {
            this._noTreeCodec("create Array node");
        }
        return this._treeCodec.createArrayNode();
    }

    public ObjectTreeNode createObjectNode() {
        if (this._treeCodec == null) {
            this._noTreeCodec("create Object node");
        }
        return this._treeCodec.createObjectNode();
    }

    public int getStreamReadFeatures(int n) {
        return n;
    }

    protected final void _writeAndClose(Object object, JsonGenerator jsonGenerator) throws JacksonException {
        try (JsonGenerator jsonGenerator2 = jsonGenerator;){
            this._config(jsonGenerator2);
            this._writerForOperation(jsonGenerator2).writeValue(object);
        }
    }

    protected JSONWriter _writerForOperation(JsonGenerator jsonGenerator) {
        return this._writer.perOperationInstance(this._features, this._valueWriterLocator, this._treeCodec, jsonGenerator);
    }

    protected JSONReader _readerForOperation(JsonParser jsonParser) {
        return this._reader.perOperationInstance(this._features, this._valueReaderLocator, this._treeCodec, jsonParser);
    }

    protected JsonParser _parser(Object object) throws JacksonException {
        TokenStreamFactory tokenStreamFactory = this._streamFactory;
        Class<?> clazz = object.getClass();
        if (clazz == String.class) {
            return tokenStreamFactory.createParser((ObjectReadContext)this, (String)object);
        }
        if (clazz == byte[].class) {
            return tokenStreamFactory.createParser((ObjectReadContext)this, (byte[])object);
        }
        if (object instanceof InputStream) {
            return tokenStreamFactory.createParser((ObjectReadContext)this, (InputStream)object);
        }
        if (object instanceof Reader) {
            return tokenStreamFactory.createParser((ObjectReadContext)this, (Reader)object);
        }
        if (clazz == char[].class) {
            return tokenStreamFactory.createParser((ObjectReadContext)this, (Reader)new CharArrayReader((char[])object));
        }
        if (object instanceof File) {
            return tokenStreamFactory.createParser((ObjectReadContext)this, (File)object);
        }
        if (object instanceof CharSequence) {
            return tokenStreamFactory.createParser((ObjectReadContext)this, ((CharSequence)object).toString());
        }
        if (object instanceof URL) {
            throw new JSONObjectException("Can not use Source of type `" + object.getClass().getName() + "` as input -- suppor drop in Jackson 3.0 (use an `InputStream`, `Reader`, `String`/`CharSequence`, `byte[]`, `char[]` or `File`");
        }
        throw new JSONObjectException("Can not use Source of type `" + object.getClass().getName() + "` as input (use an `InputStream`, `Reader`, `String`/`CharSequence`, `byte[]`, `char[]` or `File`");
    }

    protected JsonParser _initForReading(JsonParser jsonParser) throws JacksonException {
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            throw JSONObjectException.from(jsonParser, "No content to map due to end-of-input");
        }
        return jsonParser;
    }

    protected final JsonGenerator _config(JsonGenerator jsonGenerator) {
        return jsonGenerator;
    }

    protected final JsonParser _config(JsonParser jsonParser) {
        return jsonParser;
    }

    protected void _noTreeCodec(String string) {
        throw new IllegalStateException("JSON instance does not have configured `TreeCodec` to " + string);
    }

    public static class Builder {
        protected int _features = DEFAULT_FEATURES;
        protected PrettyPrinter _prettyPrinter;
        protected final TokenStreamFactory _streamFactory;
        protected TreeCodec _treeCodec;
        protected JSONReader _reader;
        protected JSONWriter _writer;
        protected MapBuilder _mapBuilder;
        protected CollectionBuilder _collectionBuilder;
        protected ExtContextImpl _extContext;

        public Builder(JsonFactory jsonFactory) {
            this._streamFactory = jsonFactory;
        }

        public JSON build() {
            return new JSON(this);
        }

        public Builder register(JacksonJrExtension jacksonJrExtension) {
            if (this._extContext == null) {
                this._extContext = new ExtContextImpl(this);
            }
            jacksonJrExtension.register(this._extContext);
            return this;
        }

        public Builder set(Feature feature, boolean bl) {
            this._features = bl ? (this._features |= feature.mask()) : (this._features &= ~feature.mask());
            return this;
        }

        public Builder enable(Feature ... featureArray) {
            for (Feature feature : featureArray) {
                this._features |= feature.mask();
            }
            return this;
        }

        public Builder disable(Feature ... featureArray) {
            for (Feature feature : featureArray) {
                this._features &= ~feature.mask();
            }
            return this;
        }

        public Builder prettyPrinter(PrettyPrinter prettyPrinter) {
            this._prettyPrinter = prettyPrinter;
            return this;
        }

        public Builder jsonReader(JSONReader jSONReader) {
            if (this._collectionBuilder != null) {
                jSONReader = jSONReader.with(this._collectionBuilder);
            }
            if (this._mapBuilder != null) {
                jSONReader = jSONReader.with(this._mapBuilder);
            }
            this._reader = jSONReader;
            return this;
        }

        public Builder jsonWriter(JSONWriter jSONWriter) {
            this._writer = jSONWriter;
            return this;
        }

        public Builder collectionBuilder(CollectionBuilder collectionBuilder) {
            this._collectionBuilder = collectionBuilder;
            if (this._reader != null) {
                this._reader = this._reader.with(collectionBuilder);
            }
            return this;
        }

        public Builder mapBuilder(MapBuilder mapBuilder) {
            this._mapBuilder = mapBuilder;
            if (this._reader != null) {
                this._reader = this._reader.with(mapBuilder);
            }
            return this;
        }

        public boolean isEnabled(Feature feature) {
            return feature.isEnabled(this._features);
        }

        public int featureMask() {
            return this._features;
        }

        public PrettyPrinter prettyPrinter() {
            return this._prettyPrinter;
        }

        public TokenStreamFactory streamFactory() {
            return this._streamFactory;
        }

        public TreeCodec treeCodec() {
            return this._treeCodec;
        }

        public ReaderWriterModifier readerWriterModifier() {
            return this._extContext == null ? null : this._extContext._rwModifier;
        }

        public ReaderWriterProvider readerWriterProvider() {
            return this._extContext == null ? null : this._extContext._rwProvider;
        }

        public JSONReader jsonReader() {
            if (this._reader == null) {
                this._reader = new JSONReader(this.collectionBuilder(), this.mapBuilder());
            }
            return this._reader;
        }

        public JSONWriter jsonWriter() {
            if (this._writer == null) {
                this._writer = new JSONWriter();
            }
            return this._writer;
        }

        public MapBuilder mapBuilder() {
            if (this._mapBuilder == null) {
                this._mapBuilder = MapBuilder.defaultImpl();
            }
            return this._mapBuilder;
        }

        public CollectionBuilder collectionBuilder() {
            if (this._collectionBuilder == null) {
                this._collectionBuilder = CollectionBuilder.defaultImpl();
            }
            return this._collectionBuilder;
        }

        protected Builder treeCodec(TreeCodec treeCodec) {
            this._treeCodec = treeCodec;
            return this;
        }
    }

    public static enum Feature {
        USE_BIG_DECIMAL_FOR_FLOATS(false),
        READ_JSON_ARRAYS_AS_JAVA_ARRAYS(false),
        READ_ONLY(false),
        PRESERVE_FIELD_ORDERING(true),
        USE_DEFERRED_MAPS(true),
        FAIL_ON_DUPLICATE_MAP_KEYS(true),
        FAIL_ON_UNKNOWN_BEAN_PROPERTY(false),
        WRITE_NULL_PROPERTIES(false),
        WRITE_ENUMS_USING_INDEX(false),
        WRITE_DATES_AS_TIMESTAMP(false),
        PRETTY_PRINT_OUTPUT(false),
        FLUSH_AFTER_WRITE_VALUE(true),
        FAIL_ON_UNKNOWN_TYPE_WRITE(false),
        HANDLE_JAVA_BEANS(true, true),
        WRITE_READONLY_BEAN_PROPERTIES(true, true),
        WRITE_RECORD_FIELDS_IN_DECLARATION_ORDER(false, true),
        FORCE_REFLECTION_ACCESS(true, true),
        USE_IS_GETTERS(true, true),
        USE_FIELD_MATCHING_GETTERS(false, true),
        USE_FIELDS(true, true),
        INCLUDE_STATIC_FIELDS(false, true),
        ACCEPT_CASE_INSENSITIVE_PROPERTIES(false, true),
        ACCEPT_CASE_INSENSITIVE_ENUMS(false, true);

        private final boolean _defaultState;
        private final boolean _affectsCaching;
        private final int _mask;

        private Feature(boolean bl) {
            this(bl, false);
        }

        private Feature(boolean bl, boolean bl2) {
            this._defaultState = bl;
            this._affectsCaching = bl2;
            this._mask = 1 << this.ordinal();
        }

        public static int defaults() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.enabledByDefault()) continue;
                n |= feature.mask();
            }
            return n;
        }

        public static int cacheBreakers() {
            int n = 0;
            for (Feature feature : Feature.values()) {
                if (!feature.affectsCaching()) continue;
                n |= feature.mask();
            }
            return n;
        }

        public final boolean enabledByDefault() {
            return this._defaultState;
        }

        public final boolean affectsCaching() {
            return this._affectsCaching;
        }

        public final int mask() {
            return this._mask;
        }

        public final boolean isDisabled(int n) {
            return (n & this._mask) == 0;
        }

        public final boolean isEnabled(int n) {
            return (n & this._mask) != 0;
        }
    }

    private static class ExtContextImpl
    extends ExtensionContext {
        final Builder _builder;
        ReaderWriterProvider _rwProvider;
        ReaderWriterModifier _rwModifier;

        ExtContextImpl(Builder builder) {
            this._builder = builder;
        }

        @Override
        public boolean isEnabled(Feature feature) {
            return this._builder.isEnabled(feature);
        }

        @Override
        public ExtensionContext setTreeCodec(TreeCodec treeCodec) {
            this._builder.treeCodec(treeCodec);
            return this;
        }

        @Override
        public TreeCodec treeCodec() {
            return this._builder.treeCodec();
        }

        @Override
        public ExtensionContext insertProvider(ReaderWriterProvider readerWriterProvider) {
            this._rwProvider = ReaderWriterProvider.Pair.of(readerWriterProvider, this._rwProvider);
            return this;
        }

        @Override
        public ExtensionContext appendProvider(ReaderWriterProvider readerWriterProvider) {
            this._rwProvider = ReaderWriterProvider.Pair.of(this._rwProvider, readerWriterProvider);
            return this;
        }

        @Override
        public ExtensionContext insertModifier(ReaderWriterModifier readerWriterModifier) {
            this._rwModifier = ReaderWriterModifier.Pair.of(readerWriterModifier, this._rwModifier);
            return this;
        }

        @Override
        public ExtensionContext appendModifier(ReaderWriterModifier readerWriterModifier) {
            this._rwModifier = ReaderWriterModifier.Pair.of(this._rwModifier, readerWriterModifier);
            return this;
        }
    }
}

