/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.util.List;
import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TreeCodec;
import tools.jackson.core.TreeNode;
import tools.jackson.jr.ob.JSON;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.CollectionBuilder;
import tools.jackson.jr.ob.api.MapBuilder;
import tools.jackson.jr.ob.api.ValueReader;
import tools.jackson.jr.ob.impl.AnyReader;
import tools.jackson.jr.ob.impl.ArrayReader;
import tools.jackson.jr.ob.impl.CollectionReader;
import tools.jackson.jr.ob.impl.MapReader;
import tools.jackson.jr.ob.impl.ValueReaderLocator;

public class JSONReader {
    protected final MapBuilder _mapBuilder;
    protected final CollectionBuilder _collectionBuilder;
    protected final int _features;
    protected final TreeCodec _treeCodec;
    protected final ValueReaderLocator _readerLocator;
    protected final JsonParser _parser;
    protected final Object[] _setterBuffer;

    public JSONReader(CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        this._features = 0;
        this._readerLocator = null;
        this._treeCodec = null;
        this._collectionBuilder = collectionBuilder;
        this._mapBuilder = mapBuilder;
        this._parser = null;
        this._setterBuffer = null;
    }

    protected JSONReader(JSONReader jSONReader, int n, ValueReaderLocator valueReaderLocator, TreeCodec treeCodec, JsonParser jsonParser) {
        this._features = n;
        this._readerLocator = valueReaderLocator.perOperationInstance(this, n);
        this._treeCodec = treeCodec;
        this._collectionBuilder = jSONReader._collectionBuilder.newBuilder(n);
        this._mapBuilder = jSONReader._mapBuilder.newBuilder(n);
        this._parser = jsonParser;
        this._setterBuffer = new Object[1];
    }

    public JSONReader withCacheCheck(int n) {
        return this;
    }

    public JSONReader with(MapBuilder mapBuilder) {
        if (this._mapBuilder == mapBuilder) {
            return this;
        }
        return this._with(this._collectionBuilder, mapBuilder);
    }

    public JSONReader with(CollectionBuilder collectionBuilder) {
        if (this._collectionBuilder == collectionBuilder) {
            return this;
        }
        return this._with(collectionBuilder, this._mapBuilder);
    }

    protected JSONReader _with(CollectionBuilder collectionBuilder, MapBuilder mapBuilder) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override _with(...)");
        }
        return new JSONReader(collectionBuilder, mapBuilder);
    }

    public JSONReader perOperationInstance(int n, ValueReaderLocator valueReaderLocator, TreeCodec treeCodec, JsonParser jsonParser) {
        if (this.getClass() != JSONReader.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONReader(this, n, valueReaderLocator, treeCodec, jsonParser);
    }

    public boolean arraysAsLists() {
        return JSON.Feature.READ_JSON_ARRAYS_AS_JAVA_ARRAYS.isDisabled(this._features);
    }

    public boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public int features() {
        return this._features;
    }

    public Object readValue() throws JacksonException {
        return AnyReader.std.read(this, this._parser);
    }

    public Map<String, Object> readMap() throws JacksonException {
        if (this._parser.isExpectedStartObjectToken()) {
            return AnyReader.std.readFromObject(this, this._parser, this._mapBuilder);
        }
        if (this._parser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        throw JSONObjectException.from(this._parser, "Can not read a Map: expect to see START_OBJECT ('{'), instead got: " + ValueReader._tokenDesc(this._parser));
    }

    public List<Object> readList() throws JacksonException {
        if (this._parser.isExpectedStartArrayToken()) {
            return (List)AnyReader.std.readCollectionFromArray(this, this._parser, this._collectionBuilder);
        }
        if (this._parser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
    }

    public Object[] readArray() throws JacksonException {
        if (this._parser.isExpectedStartArrayToken()) {
            return AnyReader.std.readArrayFromArray(this, this._parser, this._collectionBuilder);
        }
        if (this._parser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
    }

    public <T> T readBean(Class<T> clazz) throws JacksonException {
        return (T)this._readerLocator.findReader(clazz).read(this, this._parser);
    }

    public <T> T[] readArrayOf(Class<T> clazz) throws JacksonException {
        if (this._parser.isExpectedStartArrayToken()) {
            return (Object[])new ArrayReader(clazz, clazz, this._readerLocator.findReader(clazz)).read(this, this._parser);
        }
        if (this._parser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        throw JSONObjectException.from(this._parser, "Can not read an array: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
    }

    public <T> List<T> readListOf(Class<T> clazz) throws JacksonException {
        if (this._parser.isExpectedStartArrayToken()) {
            return (List)new CollectionReader(List.class, this._readerLocator.findReader(clazz)).read(this, this._parser);
        }
        if (this._parser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        throw JSONObjectException.from(this._parser, "Can not read a List: expect to see START_ARRAY ('['), instead got: " + ValueReader._tokenDesc(this._parser));
    }

    public <T> Map<String, T> readMapOf(Class<T> clazz) throws JacksonException {
        if (this._parser.isExpectedStartObjectToken()) {
            return (Map)new MapReader(Map.class, this._readerLocator.findReader(clazz)).read(this, this._parser);
        }
        if (this._parser.hasToken(JsonToken.VALUE_NULL)) {
            return null;
        }
        throw JSONObjectException.from(this._parser, "Can not read a Map: expect to see START_OBJECT ('{'), instead got: " + ValueReader._tokenDesc(this._parser));
    }

    public TreeNode readTree() throws JacksonException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No `TreeCodec` specified: can not bind JSON into `TreeNode` types");
        }
        return this._treeCodec.readTree(this._parser);
    }

    protected MapBuilder _mapBuilder(Class<?> clazz) {
        return clazz == null ? this._mapBuilder : this._mapBuilder.newBuilder(clazz);
    }

    protected CollectionBuilder _collectionBuilder(Class<?> clazz) {
        return clazz == null ? this._collectionBuilder : this._collectionBuilder.newBuilder(clazz);
    }
}

