/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.CollectionBuilder;
import tools.jackson.jr.ob.api.ValueReader;
import tools.jackson.jr.ob.impl.JSONReader;

public class CollectionReader
extends ValueReader {
    protected final Class<?> _collectionType;
    protected final ValueReader _valueReader;

    public CollectionReader(Class<?> clazz, ValueReader valueReader) {
        super(clazz);
        this._collectionType = clazz == Collection.class || clazz == List.class ? null : (clazz == Set.class ? HashSet.class : (clazz == SortedSet.class ? TreeSet.class : clazz));
        this._valueReader = valueReader;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        if (jsonParser.nextToken() != JsonToken.START_ARRAY) {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                return null;
            }
            throw JSONObjectException.from(jsonParser, "Unexpected token %s; should get START_ARRAY", jsonParser.currentToken());
        }
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(this._collectionType);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildCollection();
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        CollectionBuilder collectionBuilder = jSONReader._collectionBuilder(this._collectionType);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.emptyCollection();
        }
        Object object = this._valueReader.read(jSONReader, jsonParser);
        if (jsonParser.nextToken() == JsonToken.END_ARRAY) {
            return collectionBuilder.singletonCollection(object);
        }
        collectionBuilder = collectionBuilder.start().add(object);
        do {
            collectionBuilder = collectionBuilder.add(this._valueReader.read(jSONReader, jsonParser));
        } while (jsonParser.nextToken() != JsonToken.END_ARRAY);
        return collectionBuilder.buildCollection();
    }
}

