/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.api;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.jr.ob.impl.JSONReader;

public abstract class ValueReader {
    protected final Class<?> _valueType;

    protected ValueReader(Class<?> clazz) {
        this._valueType = clazz;
    }

    public abstract Object read(JSONReader var1, JsonParser var2) throws JacksonException;

    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        jsonParser.nextToken();
        return this.read(jSONReader, jsonParser);
    }

    public Class<?> valueType() {
        return this._valueType;
    }

    protected String _valueTypeDesc() {
        return this._valueType.getCanonicalName();
    }

    public static String _tokenDesc(JsonParser jsonParser) {
        return ValueReader._tokenDesc(jsonParser, jsonParser.currentToken());
    }

    protected static String _tokenDesc(JsonParser jsonParser, JsonToken jsonToken) {
        if (jsonToken == null) {
            return "NULL";
        }
        switch (jsonToken) {
            case PROPERTY_NAME: {
                return "JSON Object property name '" + jsonParser.currentName() + "'";
            }
            case START_ARRAY: {
                return "JSON Array";
            }
            case START_OBJECT: {
                return "JSON Object";
            }
            case VALUE_FALSE: {
                return "'false'";
            }
            case VALUE_NULL: {
                return "'null'";
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                return "JSON Number";
            }
            case VALUE_STRING: {
                return "JSON String";
            }
            case VALUE_TRUE: {
                return "'true'";
            }
        }
        return jsonToken.toString();
    }
}

