/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.UUID;
import tools.jackson.core.TreeNode;
import tools.jackson.jr.ob.JSON;
import tools.jackson.jr.ob.impl.Types;

public abstract class ValueLocatorBase {
    public static final int SER_UNKNOWN = 0;
    public static final int SER_NULL = 1;
    public static final int SER_MAP = 2;
    public static final int SER_LIST = 3;
    public static final int SER_COLLECTION = 4;
    public static final int SER_OBJECT_ARRAY = 5;
    public static final int SER_INT_ARRAY = 6;
    public static final int SER_LONG_ARRAY = 7;
    public static final int SER_BOOLEAN_ARRAY = 8;
    public static final int SER_TREE_NODE = 9;
    public static final int SER_STRING = 10;
    public static final int SER_CHARACTER_SEQUENCE = 11;
    public static final int SER_CHAR_ARRAY = 12;
    public static final int SER_BYTE_ARRAY = 13;
    public static final int SER_NUMBER_BYTE = 14;
    public static final int SER_NUMBER_SHORT = 15;
    public static final int SER_NUMBER_INTEGER = 16;
    public static final int SER_NUMBER_INTEGER_WRAPPER = 17;
    public static final int SER_NUMBER_LONG = 18;
    public static final int SER_NUMBER_LONG_WRAPPER = 19;
    public static final int SER_NUMBER_FLOAT = 20;
    public static final int SER_NUMBER_FLOAT_WRAPPER = 21;
    public static final int SER_NUMBER_DOUBLE = 22;
    public static final int SER_NUMBER_DOUBLE_WRAPPER = 23;
    public static final int SER_NUMBER_BIG_INTEGER = 24;
    public static final int SER_NUMBER_BIG_DECIMAL = 25;
    public static final int SER_BOOLEAN = 26;
    public static final int SER_BOOLEAN_WRAPPER = 27;
    public static final int SER_CHAR = 28;
    public static final int SER_ENUM = 29;
    public static final int SER_DATE = 30;
    public static final int SER_CALENDAR = 31;
    public static final int SER_CLASS = 32;
    public static final int SER_FILE = 33;
    public static final int SER_UUID = 34;
    public static final int SER_URL = 35;
    public static final int SER_URI = 36;
    public static final int SER_PATH = 37;
    public static final int SER_ITERABLE = 38;
    protected static final int CACHE_FLAGS = JSON.CACHE_FLAGS;

    protected int _findSimpleType(Class<?> clazz, boolean bl) {
        if (clazz == String.class) {
            return 10;
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            if (clazz2.isPrimitive()) {
                if (clazz == byte[].class) {
                    return 13;
                }
                if (clazz == char[].class) {
                    return 12;
                }
                if (clazz == int[].class) {
                    return 6;
                }
                if (clazz == long[].class) {
                    return 7;
                }
                if (clazz == boolean[].class) {
                    return 8;
                }
                return 0;
            }
            return 5;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return 26;
            }
            if (clazz == Integer.TYPE) {
                return 16;
            }
            if (clazz == Long.TYPE) {
                return 18;
            }
            if (clazz == Byte.TYPE) {
                return 14;
            }
            if (clazz == Short.TYPE) {
                return 15;
            }
            if (clazz == Double.TYPE) {
                return 22;
            }
            if (clazz == Float.TYPE) {
                return 20;
            }
            if (clazz == Character.TYPE) {
                return 28;
            }
            throw new IllegalArgumentException("Unrecognized primitive type: " + clazz.getName());
        }
        if (clazz == Boolean.class) {
            return 27;
        }
        if (Number.class.isAssignableFrom(clazz)) {
            if (clazz == Integer.class) {
                return 17;
            }
            if (clazz == Long.class) {
                return 19;
            }
            if (clazz == Double.class) {
                return 23;
            }
            if (clazz == Float.class) {
                return 21;
            }
            if (clazz == BigDecimal.class) {
                return 25;
            }
            if (clazz == BigInteger.class) {
                return 24;
            }
            if (clazz == Byte.class) {
                return 14;
            }
            if (clazz == Short.class) {
                return 15;
            }
            return 0;
        }
        if (clazz == Character.class) {
            return 28;
        }
        if (Types.isEnum(clazz)) {
            return 29;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return 2;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            if (List.class.isAssignableFrom(clazz) && RandomAccess.class.isAssignableFrom(clazz)) {
                return 3;
            }
            return 4;
        }
        if (TreeNode.class.isAssignableFrom(clazz)) {
            return 9;
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return 31;
        }
        if (clazz == Class.class) {
            return 32;
        }
        if (Date.class.isAssignableFrom(clazz)) {
            return 30;
        }
        if (File.class.isAssignableFrom(clazz)) {
            return 33;
        }
        if (URL.class.isAssignableFrom(clazz)) {
            return 35;
        }
        if (URI.class.isAssignableFrom(clazz)) {
            return 36;
        }
        if (UUID.class.isAssignableFrom(clazz)) {
            return 34;
        }
        if (Path.class.isAssignableFrom(clazz)) {
            return 37;
        }
        if (CharSequence.class.isAssignableFrom(clazz)) {
            return 11;
        }
        if (bl && Iterable.class.isAssignableFrom(clazz)) {
            if (!Path.class.isAssignableFrom(clazz)) {
                return 38;
            }
            System.err.println("Iterable? " + clazz.getName() + " -> NO");
        }
        return 0;
    }
}

