/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.util.Map;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.MapBuilder;
import tools.jackson.jr.ob.api.ValueReader;
import tools.jackson.jr.ob.impl.JSONReader;

public class MapReader
extends ValueReader {
    protected final Class<?> _mapType;
    protected final ValueReader _valueReader;

    public MapReader(Class<?> clazz, ValueReader valueReader) {
        super(clazz);
        this._mapType = clazz == Map.class ? null : clazz;
        this._valueReader = valueReader;
    }

    @Override
    public Object readNext(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        if (jsonParser.nextToken() != JsonToken.START_OBJECT) {
            if (jsonParser.hasToken(JsonToken.VALUE_NULL)) {
                return null;
            }
            throw JSONObjectException.from(jsonParser, "Unexpected token %s; should get START_OBJECT", jsonParser.currentToken());
        }
        MapBuilder mapBuilder = jSONReader._mapBuilder(this._mapType);
        String string = jsonParser.nextName();
        if (string == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.emptyMap();
            }
            throw this._reportWrongToken(jsonParser);
        }
        Object object = this._valueReader.readNext(jSONReader, jsonParser);
        String string2 = jsonParser.nextName();
        if (string2 == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.singletonMap(string, object);
            }
            throw this._reportWrongToken(jsonParser);
        }
        try {
            mapBuilder = mapBuilder.start().put(string, object);
            do {
                mapBuilder = mapBuilder.put(string2, this._valueReader.readNext(jSONReader, jsonParser));
            } while ((string2 = jsonParser.nextName()) != null);
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.build();
            }
            throw this._reportWrongToken(jsonParser);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws JacksonException {
        MapBuilder mapBuilder = jSONReader._mapBuilder(this._mapType);
        String string = jsonParser.nextName();
        if (string == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.emptyMap();
            }
            throw this._reportWrongToken(jsonParser);
        }
        Object object = this._valueReader.readNext(jSONReader, jsonParser);
        String string2 = jsonParser.nextName();
        if (string2 == null) {
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.singletonMap(string, object);
            }
            throw this._reportWrongToken(jsonParser);
        }
        try {
            mapBuilder = mapBuilder.start().put(string, object);
            do {
                mapBuilder = mapBuilder.put(string2, this._valueReader.readNext(jSONReader, jsonParser));
            } while ((string2 = jsonParser.nextName()) != null);
            if (jsonParser.hasToken(JsonToken.END_OBJECT)) {
                return mapBuilder.build();
            }
            throw this._reportWrongToken(jsonParser);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JSONObjectException.from(jsonParser, illegalArgumentException.getMessage());
        }
    }

    protected JSONObjectException _reportWrongToken(JsonParser jsonParser) {
        return JSONObjectException.from(jsonParser, "Unexpected token %s; should get PROPERTY_NAME or END_OBJECT", jsonParser.currentToken());
    }
}

