/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jr.ob.impl;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.SerializableString;
import tools.jackson.core.TreeCodec;
import tools.jackson.core.TreeNode;
import tools.jackson.core.io.SerializedString;
import tools.jackson.jr.ob.JSON;
import tools.jackson.jr.ob.JSONObjectException;
import tools.jackson.jr.ob.api.ValueWriter;
import tools.jackson.jr.ob.impl.BeanPropertyWriter;
import tools.jackson.jr.ob.impl.ValueWriterLocator;

public class JSONWriter {
    private static final TimeZone DEFAULT_TIMEZONE = TimeZone.getTimeZone("UTC");
    protected final TreeCodec _treeCodec;
    protected final ValueWriterLocator _writerLocator;
    protected final JsonGenerator _generator;
    protected final TimeZone _timezone;
    protected final int _features;
    protected final boolean _writeNullValues;

    public JSONWriter() {
        this._features = 0;
        this._writeNullValues = false;
        this._writerLocator = null;
        this._treeCodec = null;
        this._generator = null;
        this._timezone = DEFAULT_TIMEZONE;
    }

    protected JSONWriter(JSONWriter jSONWriter, int n, ValueWriterLocator valueWriterLocator, TreeCodec treeCodec, JsonGenerator jsonGenerator) {
        this._features = n;
        this._writeNullValues = JSON.Feature.WRITE_NULL_PROPERTIES.isEnabled(n);
        this._treeCodec = treeCodec;
        this._writerLocator = valueWriterLocator.perOperationInstance(this, n);
        this._generator = jsonGenerator;
        this._timezone = DEFAULT_TIMEZONE;
    }

    public JSONWriter withCacheCheck(int n) {
        return this;
    }

    public JSONWriter perOperationInstance(int n, ValueWriterLocator valueWriterLocator, TreeCodec treeCodec, JsonGenerator jsonGenerator) {
        if (this.getClass() != JSONWriter.class) {
            throw new IllegalStateException("Sub-classes MUST override perOperationInstance(...)");
        }
        return new JSONWriter(this, n, valueWriterLocator, treeCodec, jsonGenerator);
    }

    public boolean isEnabled(JSON.Feature feature) {
        return feature.isEnabled(this._features);
    }

    public int features() {
        return this._features;
    }

    public void writeValue(Object object) throws JacksonException {
        if (object == null) {
            this.writeNullValue();
            return;
        }
        this._writeValue(object, this._writerLocator.findSerializationType(object.getClass()));
    }

    public void writeProperty(String string, Object object, int n) throws JacksonException {
        ValueWriter valueWriter;
        switch (n) {
            case 1: {
                if (this._writeNullValues) {
                    this.writeNullProperty(string);
                }
                return;
            }
            case 2: {
                this.writeMapProperty(string, (Map)object);
                return;
            }
            case 3: {
                this.writeListProperty(string, (List)object);
                return;
            }
            case 4: {
                this.writeCollectionProperty(string, (Collection)object);
                return;
            }
            case 5: {
                this.writeObjectArrayProperty(string, (Object[])object);
                return;
            }
            case 6: {
                this.writeIntArrayProperty(string, (int[])object);
                return;
            }
            case 7: {
                this.writeLongArrayProperty(string, (long[])object);
                return;
            }
            case 8: {
                this.writeBooleanArrayProperty(string, (boolean[])object);
                return;
            }
            case 9: {
                this.writeTreeNodeProperty(string, (TreeNode)object);
                return;
            }
            case 10: {
                this.writeStringProperty(string, (String)object);
                return;
            }
            case 12: {
                this.writeStringProperty(string, new String((char[])object));
                return;
            }
            case 11: {
                this.writeStringProperty(string, ((CharSequence)object).toString());
                return;
            }
            case 13: {
                this.writeBinaryProperty(string, (byte[])object);
                return;
            }
            case 25: {
                this.writeBigDecimalProperty(string, (BigDecimal)object);
                return;
            }
            case 24: {
                this.writeBigIntegerProperty(string, (BigInteger)object);
                return;
            }
            case 20: 
            case 21: {
                this.writeFloatProperty(string, ((Float)object).floatValue());
                return;
            }
            case 22: 
            case 23: {
                this.writeDoubleProperty(string, (Double)object);
                return;
            }
            case 14: 
            case 15: {
                this.writeIntProperty(string, ((Number)object).intValue());
                return;
            }
            case 16: 
            case 17: {
                this.writeIntProperty(string, (Integer)object);
                return;
            }
            case 18: 
            case 19: {
                this.writeLongProperty(string, (Long)object);
                return;
            }
            case 26: 
            case 27: {
                this.writeBooleanProperty(string, (Boolean)object);
                return;
            }
            case 28: {
                this.writeStringProperty(string, String.valueOf(object));
                return;
            }
            case 31: {
                this.writeDateProperty(string, ((Calendar)object).getTime());
                return;
            }
            case 30: {
                this.writeDateProperty(string, (Date)object);
                return;
            }
            case 29: {
                this.writeEnumProperty(string, (Enum)object);
                return;
            }
            case 32: {
                this.writeStringLikeProperty(string, ((Class)object).getName(), n);
                return;
            }
            case 33: {
                this.writeStringLikeProperty(string, ((File)object).getAbsolutePath(), n);
                return;
            }
            case 34: 
            case 35: 
            case 36: {
                this.writeStringLikeProperty(string, object.toString(), n);
                return;
            }
            case 37: {
                this.writeStringLikeProperty(string, this.pathToString((Path)object), n);
                return;
            }
            case 38: {
                this.writeIterableProperty(string, (Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownProperty(string, object);
                return;
            }
        }
        if (n < 0 && (valueWriter = this._writerLocator.getValueWriter(n)) != null) {
            this._generator.writeName(string);
            valueWriter.writeValue(this, this._generator, object);
            return;
        }
        this._badType(n, object);
    }

    protected void _writeValue(Object object, int n) throws JacksonException {
        ValueWriter valueWriter;
        switch (n) {
            case 1: {
                this.writeNullValue();
                return;
            }
            case 2: {
                this.writeMapValue((Map)object);
                return;
            }
            case 3: {
                this.writeListValue((List)object);
                return;
            }
            case 4: {
                this.writeCollectionValue((Collection)object);
                return;
            }
            case 5: {
                this.writeObjectArrayValue((Object[])object);
                return;
            }
            case 6: {
                this.writeIntArrayValue((int[])object);
                return;
            }
            case 7: {
                this.writeLongArrayValue((long[])object);
                return;
            }
            case 8: {
                this.writeBooleanArrayValue((boolean[])object);
                return;
            }
            case 9: {
                this.writeTreeNodeValue((TreeNode)object);
                return;
            }
            case 10: {
                this.writeStringValue((String)object);
                return;
            }
            case 12: {
                this.writeStringValue(new String((char[])object));
                return;
            }
            case 11: {
                this.writeStringValue(((CharSequence)object).toString());
                return;
            }
            case 13: {
                this.writeBinaryValue((byte[])object);
                return;
            }
            case 20: 
            case 21: {
                this.writeFloatValue(((Float)object).floatValue());
                return;
            }
            case 22: 
            case 23: {
                this.writeDoubleValue((Double)object);
                return;
            }
            case 14: 
            case 15: {
                this.writeIntValue(((Number)object).intValue());
                return;
            }
            case 16: 
            case 17: {
                this.writeIntValue((Integer)object);
                return;
            }
            case 18: 
            case 19: {
                this.writeLongValue((Long)object);
                return;
            }
            case 25: {
                this.writeBigDecimalValue((BigDecimal)object);
                return;
            }
            case 24: {
                this.writeBigIntegerValue((BigInteger)object);
                return;
            }
            case 26: 
            case 27: {
                this.writeBooleanValue((Boolean)object);
                return;
            }
            case 28: {
                this.writeStringValue(String.valueOf(object));
                return;
            }
            case 31: {
                this.writeDateValue(((Calendar)object).getTime());
                return;
            }
            case 30: {
                this.writeDateValue((Date)object);
                return;
            }
            case 29: {
                this.writeEnumValue((Enum)object);
                return;
            }
            case 32: {
                this.writeStringLikeValue(((Class)object).getName(), n);
                return;
            }
            case 33: {
                this.writeStringLikeValue(((File)object).getAbsolutePath(), n);
                return;
            }
            case 34: 
            case 35: 
            case 36: {
                this.writeStringLikeValue(object.toString(), n);
                return;
            }
            case 37: {
                this.writeStringLikeValue(this.pathToString((Path)object), n);
                return;
            }
            case 38: {
                this.writeIterableValue((Iterable)object);
                return;
            }
            case 0: {
                this.writeUnknownValue(object);
                return;
            }
        }
        if (n < 0 && (valueWriter = this._writerLocator.getValueWriter(n)) != null) {
            valueWriter.writeValue(this, this._generator, object);
            return;
        }
        this._badType(n, object);
    }

    protected void writeCollectionValue(Collection<?> collection) throws JacksonException {
        this._generator.writeStartArray();
        for (Object obj : collection) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeCollectionProperty(String string, Collection<?> collection) throws JacksonException {
        this._generator.writeName(string);
        this.writeCollectionValue(collection);
    }

    protected void writeIterableValue(Iterable<?> iterable) throws JacksonException {
        this._generator.writeStartArray();
        for (Object obj : iterable) {
            this.writeValue(obj);
        }
        this._generator.writeEndArray();
    }

    protected void writeIterableProperty(String string, Iterable<?> iterable) throws JacksonException {
        this._generator.writeName(string);
        this.writeIterableValue(iterable);
    }

    protected void writeListValue(List<?> list) throws JacksonException {
        int n = list.size();
        this._generator.writeStartArray(list, n);
        for (int i = 0; i < n; ++i) {
            Object obj = list.get(i);
            if (obj == null) {
                this._generator.writeNull();
                continue;
            }
            this._writeValue(obj, this._writerLocator.findSerializationType(obj.getClass()));
        }
        this._generator.writeEndArray();
    }

    protected void writeListProperty(String string, List<?> list) throws JacksonException {
        this._generator.writeName(string);
        this.writeListValue(list);
    }

    protected void writeMapValue(Map<?, ?> map) throws JacksonException {
        this._generator.writeStartObject(map);
        if (!map.isEmpty()) {
            for (Map.Entry<?, ?> entry : map.entrySet()) {
                int n;
                String string = this.keyToString(entry.getKey());
                Object obj = entry.getValue();
                if (obj == null) {
                    n = 1;
                } else {
                    Class<?> clazz = obj.getClass();
                    n = this._writerLocator.findSerializationType(clazz);
                }
                this.writeProperty(string, obj, n);
            }
        }
        this._generator.writeEndObject();
    }

    protected void writeMapProperty(String string, Map<?, ?> map) throws JacksonException {
        this._generator.writeName(string);
        this.writeMapValue(map);
    }

    protected void writeObjectArrayValue(Object[] objectArray) throws JacksonException {
        int n = objectArray.length;
        this._generator.writeStartArray((Object)objectArray, n);
        int n2 = 0;
        int n3 = objectArray.length;
        if (n3 > 3) {
            do {
                this.writeValue(objectArray[n2]);
                this.writeValue(objectArray[n2 + 1]);
                this.writeValue(objectArray[n2 + 2]);
                this.writeValue(objectArray[n2 + 3]);
                n2 += 4;
            } while ((n3 -= 4) > 3);
        }
        switch (n3) {
            case 3: {
                this.writeValue(objectArray[n2++]);
            }
            case 2: {
                this.writeValue(objectArray[n2++]);
            }
            case 1: {
                this.writeValue(objectArray[n2++]);
            }
        }
        this._generator.writeEndArray();
    }

    protected void writeObjectArrayProperty(String string, Object[] objectArray) throws JacksonException {
        this._generator.writeName(string);
        this.writeObjectArrayValue(objectArray);
    }

    protected void writeIntArrayValue(int[] nArray) throws JacksonException {
        int n = nArray.length;
        this._generator.writeStartArray((Object)nArray, n);
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(nArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeIntArrayProperty(String string, int[] nArray) throws JacksonException {
        this._generator.writeName(string);
        this.writeIntArrayValue(nArray);
    }

    protected void writeLongArrayValue(long[] lArray) throws JacksonException {
        int n = lArray.length;
        this._generator.writeStartArray((Object)lArray, n);
        for (int i = 0; i < n; ++i) {
            this._generator.writeNumber(lArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeLongArrayProperty(String string, long[] lArray) throws JacksonException {
        this._generator.writeName(string);
        this.writeLongArrayValue(lArray);
    }

    protected void writeBooleanArrayValue(boolean[] blArray) throws JacksonException {
        int n = blArray.length;
        this._generator.writeStartArray((Object)blArray, n);
        for (int i = 0; i < n; ++i) {
            this._generator.writeBoolean(blArray[i]);
        }
        this._generator.writeEndArray();
    }

    protected void writeBooleanArrayProperty(String string, boolean[] blArray) throws JacksonException {
        this._generator.writeName(string);
        this.writeBooleanArrayValue(blArray);
    }

    protected void writeTreeNodeValue(TreeNode treeNode) throws JacksonException {
        if (this._treeCodec == null) {
            throw new JSONObjectException("No `TreeCodec` configured: can not serialize `TreeNode` values");
        }
        this._treeCodec.writeTree(this._generator, treeNode);
    }

    protected void writeTreeNodeProperty(String string, TreeNode treeNode) throws JacksonException {
        this._generator.writeName(string);
        this.writeTreeNodeValue(treeNode);
    }

    protected void writeBooleanValue(boolean bl) throws JacksonException {
        this._generator.writeBoolean(bl);
    }

    protected void writeBooleanProperty(String string, boolean bl) throws JacksonException {
        this._generator.writeBooleanProperty(string, bl);
    }

    protected void writeIntValue(int n) throws JacksonException {
        this._generator.writeNumber(n);
    }

    protected void writeIntProperty(String string, int n) throws JacksonException {
        this._generator.writeNumberProperty(string, n);
    }

    protected void writeLongValue(long l) throws JacksonException {
        this._generator.writeNumber(l);
    }

    protected void writeBigIntegerValue(BigInteger bigInteger) throws JacksonException {
        this._generator.writeNumber(bigInteger);
    }

    protected void writeBigIntegerProperty(String string, BigInteger bigInteger) throws JacksonException {
        this._generator.writeName(string);
        this.writeBigIntegerValue(bigInteger);
    }

    protected void writeLongProperty(String string, long l) throws JacksonException {
        this._generator.writeNumberProperty(string, l);
    }

    protected void writeFloatValue(float f) throws JacksonException {
        this._generator.writeNumber(f);
    }

    protected void writeFloatProperty(String string, float f) throws JacksonException {
        this._generator.writeNumberProperty(string, f);
    }

    protected void writeDoubleValue(double d) throws JacksonException {
        this._generator.writeNumber(d);
    }

    protected void writeDoubleProperty(String string, double d) throws JacksonException {
        this._generator.writeNumberProperty(string, d);
    }

    protected void writeBigDecimalValue(BigDecimal bigDecimal) throws JacksonException {
        this._generator.writeNumber(bigDecimal);
    }

    protected void writeBigDecimalProperty(String string, BigDecimal bigDecimal) throws JacksonException {
        this._generator.writeNumberProperty(string, bigDecimal);
    }

    protected void writeStringValue(String string) throws JacksonException {
        this._generator.writeString(string);
    }

    protected void writeStringProperty(String string, String string2) throws JacksonException {
        this._generator.writeStringProperty(string, string2);
    }

    protected void writeStringLikeValue(String string, int n) throws JacksonException {
        this._generator.writeString(string);
    }

    protected void writeStringLikeProperty(String string, String string2, int n) throws JacksonException {
        this._generator.writeStringProperty(string, string2);
    }

    protected void writeBinaryValue(byte[] byArray) throws JacksonException {
        this._generator.writeBinary(byArray);
    }

    protected void writeBinaryProperty(String string, byte[] byArray) throws JacksonException {
        this._generator.writeBinaryProperty(string, byArray);
    }

    protected void writeNullValue() throws JacksonException {
        this._generator.writeNull();
    }

    protected void writeNullProperty(String string) throws JacksonException {
        if (this._writeNullValues) {
            this._generator.writeNullProperty(string);
        }
    }

    protected void writeNullProperty(SerializedString serializedString) throws JacksonException {
        if (this._writeNullValues) {
            this._generator.writeName((SerializableString)serializedString);
            this._generator.writeNull();
        }
    }

    protected void writeDateValue(Date date) throws JacksonException {
        if (JSON.Feature.WRITE_DATES_AS_TIMESTAMP.isEnabled(this._features)) {
            this.writeLongValue(date.getTime());
        } else {
            this.writeStringValue(this.dateToString(date));
        }
    }

    protected void writeDateProperty(String string, Date date) throws JacksonException {
        if (JSON.Feature.WRITE_DATES_AS_TIMESTAMP.isEnabled(this._features)) {
            this.writeLongProperty(string, date.getTime());
        } else {
            this.writeStringProperty(string, this.dateToString(date));
        }
    }

    protected void writeEnumValue(Enum<?> enum_) throws JacksonException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntValue(enum_.ordinal());
        } else {
            this.writeStringValue(enum_.toString());
        }
    }

    protected void writeEnumProperty(String string, Enum<?> enum_) throws JacksonException {
        if (JSON.Feature.WRITE_ENUMS_USING_INDEX.isEnabled(this._features)) {
            this.writeIntProperty(string, enum_.ordinal());
        } else {
            this.writeStringProperty(string, enum_.toString());
        }
    }

    public void writeBeanValue(BeanPropertyWriter[] beanPropertyWriterArray, Object object) throws JacksonException {
        Object object2;
        this._generator.writeStartObject(object);
        int n = 0;
        int n2 = beanPropertyWriterArray.length;
        if (n2 > 3) {
            do {
                int n3;
                Object object3;
                if ((object3 = ((BeanPropertyWriter)(object2 = beanPropertyWriterArray[n])).getValueFor(object)) == null) {
                    if (this._writeNullValues) {
                        this.writeNullProperty(((BeanPropertyWriter)object2).name);
                    }
                } else {
                    n3 = ((BeanPropertyWriter)object2).typeId;
                    if (n3 == 0) {
                        n3 = this._writerLocator.findSerializationType(object3.getClass());
                    }
                    this._generator.writeName((SerializableString)((BeanPropertyWriter)object2).name);
                    this._writeValue(object3, n3);
                }
                if ((object3 = ((BeanPropertyWriter)(object2 = beanPropertyWriterArray[n + 1])).getValueFor(object)) == null) {
                    if (this._writeNullValues) {
                        this.writeNullProperty(((BeanPropertyWriter)object2).name);
                    }
                } else {
                    n3 = ((BeanPropertyWriter)object2).typeId;
                    if (n3 == 0) {
                        n3 = this._writerLocator.findSerializationType(object3.getClass());
                    }
                    this._generator.writeName((SerializableString)((BeanPropertyWriter)object2).name);
                    this._writeValue(object3, n3);
                }
                if ((object3 = ((BeanPropertyWriter)(object2 = beanPropertyWriterArray[n + 2])).getValueFor(object)) == null) {
                    if (this._writeNullValues) {
                        this.writeNullProperty(((BeanPropertyWriter)object2).name);
                    }
                } else {
                    n3 = ((BeanPropertyWriter)object2).typeId;
                    if (n3 == 0) {
                        n3 = this._writerLocator.findSerializationType(object3.getClass());
                    }
                    this._generator.writeName((SerializableString)((BeanPropertyWriter)object2).name);
                    this._writeValue(object3, n3);
                }
                if ((object3 = ((BeanPropertyWriter)(object2 = beanPropertyWriterArray[n + 3])).getValueFor(object)) == null) {
                    if (this._writeNullValues) {
                        this.writeNullProperty(((BeanPropertyWriter)object2).name);
                    }
                } else {
                    n3 = ((BeanPropertyWriter)object2).typeId;
                    if (n3 == 0) {
                        n3 = this._writerLocator.findSerializationType(object3.getClass());
                    }
                    this._generator.writeName((SerializableString)((BeanPropertyWriter)object2).name);
                    this._writeValue(object3, n3);
                }
                n += 4;
            } while ((n2 -= 4) > 3);
        }
        switch (n2) {
            case 3: {
                BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[n++];
                object2 = beanPropertyWriter.getValueFor(object);
                if (object2 == null) {
                    if (this._writeNullValues) {
                        this.writeNullProperty(beanPropertyWriter.name);
                    }
                } else {
                    int n4 = beanPropertyWriter.typeId;
                    if (n4 == 0) {
                        n4 = this._writerLocator.findSerializationType(object2.getClass());
                    }
                    this._generator.writeName((SerializableString)beanPropertyWriter.name);
                    this._writeValue(object2, n4);
                }
            }
            case 2: {
                BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[n++];
                object2 = beanPropertyWriter.getValueFor(object);
                if (object2 == null) {
                    if (this._writeNullValues) {
                        this.writeNullProperty(beanPropertyWriter.name);
                    }
                } else {
                    int n5 = beanPropertyWriter.typeId;
                    if (n5 == 0) {
                        n5 = this._writerLocator.findSerializationType(object2.getClass());
                    }
                    this._generator.writeName((SerializableString)beanPropertyWriter.name);
                    this._writeValue(object2, n5);
                }
            }
            case 1: {
                BeanPropertyWriter beanPropertyWriter = beanPropertyWriterArray[n++];
                object2 = beanPropertyWriter.getValueFor(object);
                if (object2 == null) {
                    if (!this._writeNullValues) break;
                    this.writeNullProperty(beanPropertyWriter.name);
                    break;
                }
                int n6 = beanPropertyWriter.typeId;
                if (n6 == 0) {
                    n6 = this._writerLocator.findSerializationType(object2.getClass());
                }
                this._generator.writeName((SerializableString)beanPropertyWriter.name);
                this._writeValue(object2, n6);
            }
        }
        this._generator.writeEndObject();
    }

    protected void writeUnknownValue(Object object) throws JacksonException {
        this._checkUnknown(object);
        this.writeStringValue(object.toString());
    }

    protected void writeUnknownProperty(String string, Object object) throws JacksonException {
        this._checkUnknown(object);
        this.writeStringProperty(string, object.toString());
    }

    protected void _checkUnknown(Object object) throws JacksonException {
        if (JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE.isEnabled(this._features)) {
            throw new JSONObjectException("Unrecognized type (" + object.getClass().getName() + "), don't know how to write (disable " + String.valueOf((Object)JSON.Feature.FAIL_ON_UNKNOWN_TYPE_WRITE) + " to avoid exception)");
        }
    }

    protected String keyToString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        return String.valueOf(object);
    }

    protected String dateToString(Date date) {
        if (date == null) {
            return "";
        }
        return date.toString();
    }

    protected String pathToString(Path path) {
        return path.toString();
    }

    private void _badType(int n, Object object) {
        if (n < 0) {
            throw new IllegalStateException(String.format("Internal error: missing BeanDefinition for id %d (class %s)", n, object.getClass().getName()));
        }
        String string = object == null ? "NULL" : object.getClass().getName();
        throw new IllegalStateException(String.format("Unsupported type: %s (%s)", n, string));
    }
}

