/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jaxrs.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import tools.jackson.core.JsonParser;
import tools.jackson.core.Version;
import tools.jackson.core.exc.JacksonIOException;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import tools.jackson.dataformat.xml.XmlMapper;
import tools.jackson.jaxrs.base.ProviderBase;
import tools.jackson.jaxrs.cfg.MapperConfiguratorBase;
import tools.jackson.jaxrs.xml.PackageVersion;
import tools.jackson.jaxrs.xml.XMLEndpointConfig;
import tools.jackson.jaxrs.xml.XMLMapperConfigurator;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"application/xml", "text/xml", "*/*"})
public class JacksonXMLProvider
extends ProviderBase<JacksonXMLProvider, XmlMapper, XMLEndpointConfig, XMLMapperConfigurator> {
    @Context
    protected Providers _providers;

    public JacksonXMLProvider() {
        this(null, (AnnotationIntrospector)new JacksonXmlAnnotationIntrospector());
    }

    public JacksonXMLProvider(XmlMapper mapper, AnnotationIntrospector aiOverride) {
        super((MapperConfiguratorBase)new XMLMapperConfigurator(mapper, aiOverride));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected XMLEndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return XMLEndpointConfig.forReading(reader, annotations);
    }

    protected XMLEndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return XMLEndpointConfig.forWriting(writer, annotations);
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return "xml".equalsIgnoreCase(subtype) || subtype.endsWith("+xml");
        }
        return true;
    }

    public XmlMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        XmlMapper m = (XmlMapper)((XMLMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        if (m == null) {
            if (this._providers != null) {
                ContextResolver resolver = this._providers.getContextResolver(XmlMapper.class, mediaType);
                if (resolver == null) {
                    resolver = this._providers.getContextResolver(XmlMapper.class, null);
                }
                if (resolver != null) {
                    m = (XmlMapper)resolver.getContext(type);
                }
            }
            if (m == null) {
                m = (XmlMapper)((XMLMapperConfigurator)this._mapperConfig).getDefaultMapper();
            }
        }
        return m;
    }

    protected JsonParser _createParser(ObjectReader reader, InputStream rawStream) {
        try {
            PushbackInputStream wrappedStream = new PushbackInputStream(rawStream);
            int firstByte = wrappedStream.read();
            if (firstByte == -1) {
                return null;
            }
            wrappedStream.unread(firstByte);
            return reader.createParser((InputStream)wrappedStream);
        }
        catch (IOException e) {
            throw JacksonIOException.construct((IOException)e);
        }
    }
}

