/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.jaxrs.cbor;

import java.lang.annotation.Annotation;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.ObjectReader;
import tools.jackson.databind.ObjectWriter;
import tools.jackson.dataformat.cbor.CBORMapper;
import tools.jackson.jaxrs.base.ProviderBase;
import tools.jackson.jaxrs.cbor.CBOREndpointConfig;
import tools.jackson.jaxrs.cbor.CBORMapperConfigurator;
import tools.jackson.jaxrs.cbor.CBORMediaTypes;
import tools.jackson.jaxrs.cbor.PackageVersion;
import tools.jackson.jaxrs.cfg.MapperConfiguratorBase;

@Provider
@Consumes(value={"*/*"})
@Produces(value={"application/cbor", "*/*"})
public class JacksonCBORProvider
extends ProviderBase<JacksonCBORProvider, CBORMapper, CBOREndpointConfig, CBORMapperConfigurator> {
    @Context
    protected Providers _providers;

    public JacksonCBORProvider() {
        this(null, null);
    }

    public JacksonCBORProvider(CBORMapper mapper) {
        this(mapper, null);
    }

    public JacksonCBORProvider(CBORMapper mapper, AnnotationIntrospector aiOverride) {
        super((MapperConfiguratorBase)new CBORMapperConfigurator(mapper, aiOverride));
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    protected boolean hasMatchingMediaType(MediaType mediaType) {
        if (mediaType != null) {
            String subtype = mediaType.getSubtype();
            return CBORMediaTypes.APPLICATION_JACKSON_CBOR_TYPE.getSubtype().equalsIgnoreCase(subtype) || "cbor".equalsIgnoreCase(subtype) || subtype.endsWith("+cbor");
        }
        return true;
    }

    protected CBORMapper _locateMapperViaProvider(Class<?> type, MediaType mediaType) {
        CBORMapper m = (CBORMapper)((CBORMapperConfigurator)this._mapperConfig).getConfiguredMapper();
        if (m == null) {
            if (this._providers != null) {
                ContextResolver resolver = this._providers.getContextResolver(CBORMapper.class, mediaType);
                if (resolver == null) {
                    resolver = this._providers.getContextResolver(CBORMapper.class, null);
                }
                if (resolver != null) {
                    m = (CBORMapper)resolver.getContext(type);
                }
            }
            if (m == null) {
                m = (CBORMapper)((CBORMapperConfigurator)this._mapperConfig).getDefaultMapper();
            }
        }
        return m;
    }

    protected CBOREndpointConfig _configForReading(ObjectReader reader, Annotation[] annotations) {
        return CBOREndpointConfig.forReading(reader, annotations);
    }

    protected CBOREndpointConfig _configForWriting(ObjectWriter writer, Annotation[] annotations) {
        return CBOREndpointConfig.forWriting(writer, annotations);
    }
}

