/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Closeable;
import java.io.IOException;
import java.io.Serializable;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import tools.jackson.core.Base64Variants;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.type.TypeReference;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.cfg.DeserializationContexts;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.databind.cfg.SerializationContexts;
import tools.jackson.databind.deser.DeserializationContextExt;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeResolverBuilder;
import tools.jackson.databind.ser.SerializationContextExt;
import tools.jackson.databind.type.LogicalType;
import tools.jackson.dataformat.xml.DefaultingXmlTypeResolverBuilder;
import tools.jackson.dataformat.xml.JacksonXmlAnnotationIntrospector;
import tools.jackson.dataformat.xml.PackageVersion;
import tools.jackson.dataformat.xml.XmlFactory;
import tools.jackson.dataformat.xml.XmlModule;
import tools.jackson.dataformat.xml.XmlReadFeature;
import tools.jackson.dataformat.xml.XmlTypeResolverProvider;
import tools.jackson.dataformat.xml.XmlWriteFeature;
import tools.jackson.dataformat.xml.deser.FromXmlParser;
import tools.jackson.dataformat.xml.deser.XmlDeserializationContexts;
import tools.jackson.dataformat.xml.ser.ToXmlGenerator;
import tools.jackson.dataformat.xml.ser.XmlSerializationContexts;
import tools.jackson.dataformat.xml.util.DefaultXmlPrettyPrinter;

public class XmlMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected static final DefaultXmlPrettyPrinter DEFAULT_XML_PRETTY_PRINTER = new DefaultXmlPrettyPrinter();

    public XmlMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder xmlBuilder() {
        return new Builder(new XmlFactory());
    }

    public static Builder builder() {
        return new Builder(new XmlFactory());
    }

    public static Builder builder(XmlFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public static Builder builderWithJackson2Defaults() {
        return XmlMapper.builder(XmlFactory.builderWithJackson2Defaults().build()).configureForJackson2();
    }

    public Builder rebuild() {
        return new Builder((XmlBuilderState)this._savedBuilderState);
    }

    protected Object writeReplace() {
        return this._savedBuilderState;
    }

    protected Object readResolve() {
        throw new IllegalStateException("Should never deserialize `" + ((Object)((Object)this)).getClass().getName() + "` directly");
    }

    public XmlMapper() {
        this(new XmlFactory());
    }

    public XmlMapper(XmlFactory xmlFactory) {
        this(new Builder(xmlFactory));
    }

    public static XmlMapper shared() {
        return SharedWrapper.wrapped();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public XmlFactory tokenStreamFactory() {
        return (XmlFactory)this._streamFactory;
    }

    public FromXmlParser createParser(XMLStreamReader r) throws IOException {
        DeserializationContextExt ctxt = this._deserializationContext();
        return this.tokenStreamFactory().createParser((ObjectReadContext)ctxt, r);
    }

    public ToXmlGenerator createGenerator(XMLStreamWriter w) throws IOException {
        SerializationContextExt prov = this._serializationContext(this.serializationConfig());
        return this.tokenStreamFactory().createGenerator((ObjectWriteContext)prov, w);
    }

    public <T> T readValue(XMLStreamReader r, Class<T> valueType) throws IOException {
        return this.readValue(r, this._typeFactory.constructType(valueType));
    }

    public <T> T readValue(XMLStreamReader r, TypeReference<T> valueTypeRef) throws IOException {
        return this.readValue(r, this._typeFactory.constructType(valueTypeRef));
    }

    public <T> T readValue(XMLStreamReader r, JavaType valueType) throws IOException {
        return (T)super.readValue((JsonParser)this.createParser(r), valueType);
    }

    public void writeValue(XMLStreamWriter w, Object value) throws IOException {
        ToXmlGenerator g = this.createGenerator(w);
        SerializationConfig config = this.serializationConfig();
        if (config.isEnabled(SerializationFeature.CLOSE_CLOSEABLE) && value instanceof Closeable) {
            this._writeCloseableValue((JsonGenerator)g, value, config);
        } else {
            this._serializationContext(config).serializeValue((JsonGenerator)g, value);
            if (config.isEnabled(SerializationFeature.FLUSH_AFTER_WRITE_VALUE)) {
                g.flush();
            }
        }
    }

    public static class Builder
    extends MapperBuilder<XmlMapper, Builder> {
        protected boolean _defaultUseWrapper;
        protected String _nameForTextElement;

        public Builder(XmlFactory f) {
            super((TokenStreamFactory)f);
            this.enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT});
            this._defaultUseWrapper = true;
            this._nameForTextElement = "";
            this.annotationIntrospector((AnnotationIntrospector)new JacksonXmlAnnotationIntrospector(this._defaultUseWrapper));
            this.typeResolverProvider(new XmlTypeResolverProvider());
            this.addModule(new XmlModule());
            this.defaultBase64Variant(Base64Variants.MIME);
            this._coercionConfigs.defaultCoercions().setAcceptBlankAsEmpty(Boolean.TRUE).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsEmpty);
            this._coercionConfigs.findOrCreateCoercion(LogicalType.Integer).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
            this._coercionConfigs.findOrCreateCoercion(LogicalType.Float).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
            this._coercionConfigs.findOrCreateCoercion(LogicalType.Boolean).setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
        }

        public XmlMapper build() {
            return new XmlMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new XmlBuilderState(this);
        }

        public Builder(XmlBuilderState state) {
            super((MapperBuilderState)state);
            this._defaultUseWrapper = state._defaultUseWrapper;
            this._nameForTextElement = state._nameForTextElement;
        }

        protected SerializationContexts _defaultSerializationContexts() {
            return new XmlSerializationContexts();
        }

        protected DeserializationContexts _defaultDeserializationContexts() {
            return new XmlDeserializationContexts();
        }

        protected PrettyPrinter _defaultPrettyPrinter() {
            return DEFAULT_XML_PRETTY_PRINTER;
        }

        protected TypeResolverBuilder<?> _defaultDefaultTypingResolver(PolymorphicTypeValidator ptv, DefaultTyping applicability, JsonTypeInfo.As includeAs) {
            return new DefaultingXmlTypeResolverBuilder(ptv, applicability, includeAs);
        }

        protected TypeResolverBuilder<?> _defaultDefaultTypingResolver(PolymorphicTypeValidator ptv, DefaultTyping applicability, String propertyName) {
            return new DefaultingXmlTypeResolverBuilder(ptv, applicability, propertyName);
        }

        public Builder activateDefaultTyping(PolymorphicTypeValidator ptv, DefaultTyping dti) {
            return (Builder)this.activateDefaultTyping(ptv, dti, JsonTypeInfo.As.WRAPPER_OBJECT);
        }

        public Builder enable(XmlReadFeature ... features) {
            for (XmlReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(XmlReadFeature ... features) {
            for (XmlReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(XmlReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(XmlWriteFeature ... features) {
            for (XmlWriteFeature f : features) {
                this._formatWriteFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(XmlWriteFeature ... features) {
            for (XmlWriteFeature f : features) {
                this._formatWriteFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(XmlWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        public Builder configureForJackson2() {
            return ((Builder)super.configureForJackson2()).disable(XmlWriteFeature.WRITE_NULLS_AS_XSI_NIL).disable(XmlWriteFeature.UNWRAP_ROOT_OBJECT_NODE).disable(XmlWriteFeature.AUTO_DETECT_XSI_TYPE).disable(XmlWriteFeature.WRITE_XML_SCHEMA_CONFORMING_FLOATS).disable(XmlReadFeature.AUTO_DETECT_XSI_TYPE);
        }

        public boolean defaultUseWrapper() {
            return this._defaultUseWrapper;
        }

        public Builder defaultUseWrapper(boolean b) {
            if (this._defaultUseWrapper != b) {
                this._defaultUseWrapper = b;
                AnnotationIntrospector ai0 = this.annotationIntrospector();
                for (AnnotationIntrospector ai : ai0.allIntrospectors()) {
                    if (!(ai instanceof JacksonXmlAnnotationIntrospector)) continue;
                    ((JacksonXmlAnnotationIntrospector)ai).setDefaultUseWrapper(b);
                }
            }
            return this;
        }

        public String nameForTextElement() {
            return this._nameForTextElement;
        }

        public Builder nameForTextElement(String elem) {
            if (elem == null) {
                elem = "";
            }
            this._nameForTextElement = elem;
            this._streamFactory = ((XmlFactory)this._streamFactory).withNameForTextElement(elem);
            return this;
        }
    }

    protected static class XmlBuilderState
    extends MapperBuilderState
    implements Serializable {
        private static final long serialVersionUID = 3L;
        protected final boolean _defaultUseWrapper;
        protected final String _nameForTextElement;

        public XmlBuilderState(Builder src) {
            super((MapperBuilder)src);
            this._defaultUseWrapper = src._defaultUseWrapper;
            this._nameForTextElement = src._nameForTextElement;
        }

        protected Object readResolve() {
            return new Builder(this).build();
        }
    }

    private static final class SharedWrapper {
        private static final XmlMapper MAPPER = XmlMapper.builder().build();

        private SharedWrapper() {
        }

        public static XmlMapper wrapped() {
            return MAPPER;
        }
    }
}

