/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.ser;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.BitSet;
import java.util.Set;
import javax.xml.namespace.QName;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.PropertyFilter;
import tools.jackson.databind.ser.PropertyWriter;
import tools.jackson.databind.ser.WritableObjectId;
import tools.jackson.databind.ser.bean.BeanSerializerBase;
import tools.jackson.databind.ser.impl.ObjectIdWriter;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.dataformat.xml.ser.ToXmlGenerator;
import tools.jackson.dataformat.xml.util.XmlInfo;

public abstract class XmlBeanSerializerBase
extends BeanSerializerBase {
    public static final String KEY_XML_INFO = new String("xmlInfo");
    protected final int _attributeCount;
    protected final int _textPropertyIndex;
    protected final QName[] _xmlNames;
    protected final BitSet _cdata;

    public XmlBeanSerializerBase(BeanSerializerBase src) {
        super(src);
        int attrCount = 0;
        for (BeanPropertyWriter bpw : this._props) {
            if (!XmlBeanSerializerBase._isAttribute(bpw)) continue;
            attrCount = XmlBeanSerializerBase._orderAttributesFirst(this._props, this._filteredProps);
            break;
        }
        this._attributeCount = attrCount;
        BitSet cdata = null;
        int len = this._props.length;
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw;
            bpw = this._props[i];
            if (!XmlBeanSerializerBase._isCData(bpw)) continue;
            if (cdata == null) {
                cdata = new BitSet(len);
            }
            cdata.set(i);
        }
        this._cdata = cdata;
        this._xmlNames = new QName[this._props.length];
        int textIndex = -1;
        int len2 = this._props.length;
        for (int i = 0; i < len2; ++i) {
            BeanPropertyWriter bpw = this._props[i];
            XmlInfo info = (XmlInfo)bpw.getInternalSetting((Object)KEY_XML_INFO);
            String ns = null;
            if (info != null) {
                ns = info.getNamespace();
                if (textIndex < 0 && info.isText()) {
                    textIndex = i;
                }
            }
            this._xmlNames[i] = new QName(ns == null ? "" : ns, bpw.getName());
        }
        this._textPropertyIndex = textIndex;
    }

    protected XmlBeanSerializerBase(XmlBeanSerializerBase src, ObjectIdWriter objectIdWriter) {
        super((BeanSerializerBase)src, objectIdWriter);
        this._attributeCount = src._attributeCount;
        this._textPropertyIndex = src._textPropertyIndex;
        this._xmlNames = src._xmlNames;
        this._cdata = src._cdata;
    }

    protected XmlBeanSerializerBase(XmlBeanSerializerBase src, ObjectIdWriter objectIdWriter, Object filterId) {
        super((BeanSerializerBase)src, objectIdWriter, filterId);
        this._attributeCount = src._attributeCount;
        this._textPropertyIndex = src._textPropertyIndex;
        this._xmlNames = src._xmlNames;
        this._cdata = src._cdata;
    }

    protected XmlBeanSerializerBase(XmlBeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude) {
        super((BeanSerializerBase)src, toIgnore, toInclude);
        this._attributeCount = src._attributeCount;
        this._textPropertyIndex = src._textPropertyIndex;
        this._xmlNames = src._xmlNames;
        this._cdata = src._cdata;
    }

    public XmlBeanSerializerBase(XmlBeanSerializerBase src, NameTransformer transformer) {
        super((BeanSerializerBase)src, transformer);
        this._attributeCount = src._attributeCount;
        this._textPropertyIndex = src._textPropertyIndex;
        this._xmlNames = src._xmlNames;
        this._cdata = src._cdata;
    }

    protected XmlBeanSerializerBase(XmlBeanSerializerBase src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super((BeanSerializerBase)src, properties, filteredProperties);
        this._attributeCount = src._attributeCount;
        this._textPropertyIndex = src._textPropertyIndex;
        this._xmlNames = src._xmlNames;
        this._cdata = src._cdata;
    }

    protected void _serializeProperties(Object bean, JsonGenerator gen0, SerializationContext ctxt) throws JacksonException {
        int i;
        if (!(gen0 instanceof ToXmlGenerator)) {
            super._serializeProperties(bean, gen0, ctxt);
            return;
        }
        ToXmlGenerator xgen = (ToXmlGenerator)gen0;
        BeanPropertyWriter[] props = this._filteredProps != null && ctxt.getActiveView() != null ? this._filteredProps : this._props;
        int attrCount = this._attributeCount;
        boolean isAttribute = xgen._nextIsAttribute;
        if (attrCount > 0) {
            xgen.setNextIsAttribute(true);
        }
        int textIndex = this._textPropertyIndex;
        QName[] xmlNames = this._xmlNames;
        BitSet cdata = this._cdata;
        try {
            int len = props.length;
            for (i = 0; i < len; ++i) {
                if (!(i != attrCount || isAttribute && this.isUnwrappingSerializer())) {
                    xgen.setNextIsAttribute(false);
                }
                if (i == textIndex) {
                    xgen.setNextIsUnwrapped(true);
                }
                xgen.setNextName(xmlNames[i]);
                BeanPropertyWriter prop = props[i];
                if (prop != null) {
                    if (cdata != null && cdata.get(i)) {
                        xgen.setNextIsCData(true);
                        prop.serializeAsProperty(bean, (JsonGenerator)xgen, ctxt);
                        xgen.setNextIsCData(false);
                    } else {
                        prop.serializeAsProperty(bean, (JsonGenerator)xgen, ctxt);
                    }
                }
                if (i != textIndex) continue;
                xgen.setNextIsUnwrapped(false);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(ctxt, e, bean, name);
        }
        catch (StackOverflowError e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            throw DatabindException.from((JsonGenerator)gen0, (String)"Infinite recursion (StackOverflowError)").prependPath(bean, name);
        }
    }

    protected void _serializePropertiesFiltered(Object bean, JsonGenerator gen0, SerializationContext ctxt, Object filterId) throws JacksonException {
        int i;
        if (!(gen0 instanceof ToXmlGenerator)) {
            super._serializePropertiesFiltered(bean, gen0, ctxt, filterId);
            return;
        }
        ToXmlGenerator xgen = (ToXmlGenerator)gen0;
        BeanPropertyWriter[] props = this._filteredProps != null && ctxt.getActiveView() != null ? this._filteredProps : this._props;
        PropertyFilter filter = this.findPropertyFilter(ctxt, this._propertyFilterId, bean);
        if (filter == null) {
            this._serializeProperties(bean, gen0, ctxt);
            return;
        }
        boolean isAttribute = xgen._nextIsAttribute;
        int attrCount = this._attributeCount;
        if (attrCount > 0) {
            xgen.setNextIsAttribute(true);
        }
        int textIndex = this._textPropertyIndex;
        QName[] xmlNames = this._xmlNames;
        BitSet cdata = this._cdata;
        try {
            int len = props.length;
            for (i = 0; i < len; ++i) {
                if (!(i != attrCount || isAttribute && this.isUnwrappingSerializer())) {
                    xgen.setNextIsAttribute(false);
                }
                if (i == textIndex) {
                    xgen.setNextIsUnwrapped(true);
                }
                xgen.setNextName(xmlNames[i]);
                BeanPropertyWriter prop = props[i];
                if (prop != null) {
                    if (cdata != null && cdata.get(i)) {
                        xgen.setNextIsCData(true);
                        filter.serializeAsProperty(bean, (JsonGenerator)xgen, ctxt, (PropertyWriter)prop);
                        xgen.setNextIsCData(false);
                    } else {
                        filter.serializeAsProperty(bean, (JsonGenerator)xgen, ctxt, (PropertyWriter)prop);
                    }
                }
                if (i != textIndex) continue;
                xgen.setNextIsUnwrapped(false);
            }
        }
        catch (Exception e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            this.wrapAndThrow(ctxt, e, bean, name);
        }
        catch (StackOverflowError e) {
            String name = i == props.length ? "[anySetter]" : props[i].getName();
            throw DatabindException.from((JsonGenerator)gen0, (String)"Infinite recursion (StackOverflowError)", (Throwable)e).prependPath(bean, name);
        }
    }

    public void serializeWithType(Object bean, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, gen, ctxt, typeSer);
            return;
        }
        if (typeSer.getTypeInclusion() == JsonTypeInfo.As.PROPERTY) {
            ToXmlGenerator xgen = (ToXmlGenerator)gen;
            xgen.setNextIsAttribute(true);
            super.serializeWithType(bean, gen, ctxt, typeSer);
            if (this._attributeCount == 0) {
                xgen.setNextIsAttribute(false);
            }
        } else {
            super.serializeWithType(bean, gen, ctxt, typeSer);
        }
    }

    protected void _serializeObjectId(Object bean, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer, WritableObjectId objectId) throws JacksonException {
        if (typeSer.getTypeInclusion() == JsonTypeInfo.As.PROPERTY) {
            ToXmlGenerator xgen = (ToXmlGenerator)gen;
            xgen.setNextIsAttribute(true);
            super._serializeObjectId(bean, gen, ctxt, typeSer, objectId);
            if (this._attributeCount == 0) {
                xgen.setNextIsAttribute(false);
            }
        } else {
            super._serializeObjectId(bean, gen, ctxt, typeSer, objectId);
        }
    }

    protected static boolean _isAttribute(BeanPropertyWriter bpw) {
        XmlInfo info = (XmlInfo)bpw.getInternalSetting((Object)KEY_XML_INFO);
        return info != null && info.isAttribute();
    }

    protected static boolean _isCData(BeanPropertyWriter bpw) {
        XmlInfo info = (XmlInfo)bpw.getInternalSetting((Object)KEY_XML_INFO);
        return info != null && info.isCData();
    }

    protected static int _orderAttributesFirst(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        int attrCount = 0;
        int len = properties.length;
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = properties[i];
            if (!XmlBeanSerializerBase._isAttribute(bpw)) continue;
            int moveBy = i - attrCount;
            if (moveBy > 0) {
                System.arraycopy(properties, attrCount, properties, attrCount + 1, moveBy);
                properties[attrCount] = bpw;
                if (filteredProperties != null) {
                    BeanPropertyWriter fbpw = filteredProperties[i];
                    System.arraycopy(filteredProperties, attrCount, filteredProperties, attrCount + 1, moveBy);
                    filteredProperties[attrCount] = fbpw;
                }
            }
            ++attrCount;
        }
        return attrCount;
    }
}

