/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.ser;

import java.util.Set;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.databind.ser.bean.BeanAsArraySerializer;
import tools.jackson.databind.ser.bean.BeanSerializerBase;
import tools.jackson.databind.ser.impl.ObjectIdWriter;
import tools.jackson.databind.util.NameTransformer;
import tools.jackson.dataformat.xml.ser.UnwrappingXmlBeanSerializer;
import tools.jackson.dataformat.xml.ser.XmlBeanSerializerBase;

public class XmlBeanSerializer
extends XmlBeanSerializerBase {
    public XmlBeanSerializer(BeanSerializerBase src) {
        super(src);
    }

    public XmlBeanSerializer(XmlBeanSerializerBase src, ObjectIdWriter objectIdWriter, Object filterId) {
        super(src, objectIdWriter, filterId);
    }

    public XmlBeanSerializer(XmlBeanSerializerBase src, ObjectIdWriter objectIdWriter) {
        super(src, objectIdWriter);
    }

    public XmlBeanSerializer(XmlBeanSerializerBase src, Set<String> toIgnore, Set<String> toInclude) {
        super(src, toIgnore, toInclude);
    }

    protected XmlBeanSerializer(XmlBeanSerializerBase src, BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        super(src, properties, filteredProperties);
    }

    public ValueSerializer<Object> unwrappingSerializer(NameTransformer unwrapper) {
        return new UnwrappingXmlBeanSerializer((XmlBeanSerializerBase)this, unwrapper);
    }

    public BeanSerializerBase withObjectIdWriter(ObjectIdWriter objectIdWriter) {
        return new XmlBeanSerializer((XmlBeanSerializerBase)this, objectIdWriter, this._propertyFilterId);
    }

    public BeanSerializerBase withFilterId(Object filterId) {
        return new XmlBeanSerializer((XmlBeanSerializerBase)this, this._objectIdWriter, filterId);
    }

    protected BeanSerializerBase withByNameInclusion(Set<String> toIgnore, Set<String> toInclude) {
        return new XmlBeanSerializer((XmlBeanSerializerBase)this, toIgnore, toInclude);
    }

    protected BeanSerializerBase withProperties(BeanPropertyWriter[] properties, BeanPropertyWriter[] filteredProperties) {
        return new XmlBeanSerializer((XmlBeanSerializerBase)this, properties, filteredProperties);
    }

    protected BeanSerializerBase asArraySerializer() {
        if (this._objectIdWriter == null && this._propertyFilterId == null) {
            return new BeanAsArraySerializer((BeanSerializerBase)this);
        }
        return this;
    }

    public void serialize(Object bean, JsonGenerator g, SerializationContext ctxt) throws JacksonException {
        if (this._objectIdWriter != null) {
            this._serializeWithObjectId(bean, g, ctxt, true);
            return;
        }
        g.writeStartObject();
        if (this._propertyFilterId != null) {
            this._serializePropertiesFiltered(bean, g, ctxt, this._propertyFilterId);
        } else {
            this._serializeProperties(bean, g, ctxt);
        }
        g.writeEndObject();
    }

    public String toString() {
        return "XmlBeanSerializer for " + this.handledType().getName();
    }
}

