/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.deser;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.ValueDeserializerModifier;
import tools.jackson.databind.deser.ValueInstantiator;
import tools.jackson.databind.deser.bean.BeanDeserializerBase;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.BeanPropertyDefinition;
import tools.jackson.dataformat.xml.deser.WrapperHandlingDeserializer;
import tools.jackson.dataformat.xml.deser.XmlTextDeserializer;
import tools.jackson.dataformat.xml.util.AnnotationUtil;

public class XmlBeanDeserializerModifier
extends ValueDeserializerModifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String _cfgNameForTextValue;

    public XmlBeanDeserializerModifier(String nameForTextValue) {
        this._cfgNameForTextValue = nameForTextValue;
    }

    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription.Supplier beanDescRef, List<BeanPropertyDefinition> propDefs) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int changed = 0;
        int propCount = propDefs.size();
        for (int i = 0; i < propCount; ++i) {
            String localName;
            BeanPropertyDefinition prop = propDefs.get(i);
            AnnotatedMember acc = prop.getPrimaryMember();
            if (acc == null) continue;
            Boolean b = AnnotationUtil.findIsTextAnnotation(config, intr, acc);
            if (b != null && b.booleanValue()) {
                BeanPropertyDefinition newProp = prop.withSimpleName(this._cfgNameForTextValue);
                if (newProp == prop) continue;
                propDefs.set(i, newProp);
                continue;
            }
            PropertyName wrapperName = prop.getWrapperName();
            if (wrapperName == null || wrapperName == PropertyName.NO_NAME || (localName = wrapperName.getSimpleName()) == null || localName.length() <= 0 || localName.equals(prop.getName())) continue;
            if (changed == 0) {
                propDefs = new ArrayList<BeanPropertyDefinition>(propDefs);
            }
            ++changed;
            propDefs.set(i, prop.withSimpleName(localName));
        }
        return propDefs;
    }

    public ValueDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription.Supplier beanDescRef, ValueDeserializer<?> deser0) {
        SettableBeanProperty textProp;
        if (!(deser0 instanceof BeanDeserializerBase)) {
            return deser0;
        }
        BeanDeserializerBase deser = (BeanDeserializerBase)deser0;
        ValueInstantiator inst = deser.getValueInstantiator();
        if (!inst.canCreateFromString() && (textProp = this._findSoleTextProp(config, deser.properties())) != null) {
            return new XmlTextDeserializer(deser, textProp);
        }
        return new WrapperHandlingDeserializer(deser);
    }

    private SettableBeanProperty _findSoleTextProp(DeserializationConfig config, Iterator<SettableBeanProperty> propIt) {
        AnnotationIntrospector ai = config.getAnnotationIntrospector();
        SettableBeanProperty textProp = null;
        while (propIt.hasNext()) {
            SettableBeanProperty prop = propIt.next();
            AnnotatedMember m = prop.getMember();
            if (m != null) {
                PropertyName n = prop.getFullName();
                if (this._cfgNameForTextValue.equals(n.getSimpleName())) {
                    textProp = prop;
                    continue;
                }
                Boolean b = AnnotationUtil.findIsAttributeAnnotation(config, ai, m);
                if (b != null && b.booleanValue()) continue;
            }
            return null;
        }
        return textProp;
    }
}

