/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.xml.deser;

import java.util.Set;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.io.CharTypes;
import tools.jackson.core.io.ContentReference;

public final class XmlReadContext
extends TokenStreamContext {
    protected final XmlReadContext _parent;
    protected int _lineNr;
    protected int _columnNr;
    protected String _currentName;
    protected Object _currentValue;
    protected Set<String> _namesToWrap;
    protected String _wrappedName;
    protected XmlReadContext _child = null;

    public XmlReadContext(int type, XmlReadContext parent, int nestingDepth, int lineNr, int colNr) {
        this._type = type;
        this._parent = parent;
        this._nestingDepth = nestingDepth;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._index = -1;
    }

    protected final void reset(int type, int lineNr, int colNr) {
        this._type = type;
        this._index = -1;
        this._lineNr = lineNr;
        this._columnNr = colNr;
        this._currentName = null;
        this._currentValue = null;
        this._namesToWrap = null;
    }

    public Object currentValue() {
        return this._currentValue;
    }

    public void assignCurrentValue(Object v) {
        this._currentValue = v;
    }

    public static XmlReadContext createRootContext(int lineNr, int colNr) {
        return new XmlReadContext(0, null, 0, lineNr, colNr);
    }

    public final XmlReadContext createChildArrayContext(int lineNr, int colNr) {
        ++this._index;
        XmlReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new XmlReadContext(1, this, this._nestingDepth + 1, lineNr, colNr);
            return ctxt;
        }
        ctxt.reset(1, lineNr, colNr);
        return ctxt;
    }

    public final XmlReadContext createChildObjectContext(int lineNr, int colNr) {
        ++this._index;
        XmlReadContext ctxt = this._child;
        if (ctxt == null) {
            this._child = ctxt = new XmlReadContext(2, this, this._nestingDepth + 1, lineNr, colNr);
            return ctxt;
        }
        ctxt.reset(2, lineNr, colNr);
        return ctxt;
    }

    public final String currentName() {
        return this._currentName;
    }

    public boolean hasCurrentName() {
        return this._currentName != null;
    }

    public final XmlReadContext getParent() {
        return this._parent;
    }

    public final TokenStreamLocation startLocation(ContentReference srcRef) {
        long totalChars = -1L;
        return new TokenStreamLocation(srcRef, totalChars, this._lineNr, this._columnNr);
    }

    public final void valueStarted() {
        ++this._index;
    }

    public void setCurrentName(String name) {
        this._currentName = name;
    }

    public void setNamesToWrap(Set<String> namesToWrap) {
        this._namesToWrap = namesToWrap;
    }

    public boolean shouldWrap(String localName) {
        return this._namesToWrap != null && this._namesToWrap.contains(localName);
    }

    protected void convertToArray() {
        this._type = 1;
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            case 2: {
                sb.append('{');
                if (this._currentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted((StringBuilder)sb, (String)this._currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append('}');
            }
        }
        return sb.toString();
    }
}

