/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.toml;

import tools.jackson.core.JsonParser;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.ContentReference;
import tools.jackson.dataformat.toml.Lexer;
import tools.jackson.dataformat.toml.TomlToken;

public class TomlStreamReadException
extends StreamReadException {
    private static final long serialVersionUID = 1L;

    TomlStreamReadException(JsonParser p, String msg, TokenStreamLocation loc) {
        super(p, msg, loc);
    }

    TomlStreamReadException(JsonParser p, String msg, TokenStreamLocation loc, Throwable rootCause) {
        super(p, msg, loc, rootCause);
    }

    public TomlStreamReadException withParser(JsonParser p) {
        this._processor = p;
        return this;
    }

    static class ErrorContext {
        final ContentReference contentReference;
        final JsonParser parser;

        ErrorContext(ContentReference contentReference, JsonParser parser) {
            this.contentReference = contentReference;
            this.parser = parser;
        }

        ErrorBuilder atPosition(Lexer lexer) {
            return new ErrorBuilder(lexer);
        }

        class ErrorBuilder {
            private final TokenStreamLocation location;

            ErrorBuilder(Lexer lexer) {
                this.location = new TokenStreamLocation(ErrorContext.this.contentReference, -1L, lexer.getCharPos(), lexer.getLine() + 1, lexer.getColumn() + 1);
            }

            TomlStreamReadException unexpectedToken(TomlToken actual, String expected) {
                return new TomlStreamReadException(ErrorContext.this.parser, "Unexpected token: Got " + String.valueOf((Object)actual) + ", expected " + expected, this.location);
            }

            TomlStreamReadException generic(String message) {
                return new TomlStreamReadException(ErrorContext.this.parser, message, this.location);
            }

            TomlStreamReadException outOfBounds(NumberFormatException cause) {
                return new TomlStreamReadException(ErrorContext.this.parser, "Number out of bounds", this.location, cause);
            }

            TomlStreamReadException invalidNumber(Exception cause, String value) {
                return new TomlStreamReadException(ErrorContext.this.parser, "Invalid number representation ('" + value + "'), problem: " + cause.getMessage(), this.location, cause);
            }
        }
    }
}

