/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.toml;

import java.io.Serializable;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.CoercionAction;
import tools.jackson.databind.cfg.CoercionInputShape;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.cfg.MapperBuilderState;
import tools.jackson.dataformat.toml.PackageVersion;
import tools.jackson.dataformat.toml.TomlFactory;
import tools.jackson.dataformat.toml.TomlReadFeature;
import tools.jackson.dataformat.toml.TomlWriteFeature;

public class TomlMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;

    public TomlMapper() {
        this(new TomlFactory());
    }

    public TomlMapper(TomlFactory f) {
        this(new Builder(f));
    }

    TomlMapper(Builder b) {
        super((MapperBuilder)b);
    }

    public static Builder builder() {
        return new Builder(new TomlFactory());
    }

    public static Builder builder(TomlFactory streamFactory) {
        return new Builder(streamFactory);
    }

    public Builder rebuild() {
        return new Builder((Builder.StateImpl)this._savedBuilderState);
    }

    public static TomlMapper shared() {
        return SharedWrapper.wrapped();
    }

    protected Object writeReplace() {
        return this._savedBuilderState;
    }

    protected Object readResolve() {
        throw new IllegalStateException("Should never deserialize `" + ((Object)((Object)this)).getClass().getName() + "` directly");
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public TomlFactory tokenStreamFactory() {
        return (TomlFactory)this._streamFactory;
    }

    public static class Builder
    extends MapperBuilder<TomlMapper, Builder> {
        public Builder(TomlFactory f) {
            super((TokenStreamFactory)f);
            this.enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT});
            this._coercionConfigs.defaultCoercions().setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
        }

        public Builder(StateImpl state) {
            super((MapperBuilderState)state);
        }

        public TomlMapper build() {
            return new TomlMapper(this);
        }

        protected MapperBuilderState _saveState() {
            return new StateImpl(this);
        }

        public Builder enable(TomlReadFeature ... features) {
            for (TomlReadFeature f : features) {
                this._formatReadFeatures |= f.getMask();
            }
            return this;
        }

        public Builder disable(TomlReadFeature ... features) {
            for (TomlReadFeature f : features) {
                this._formatReadFeatures &= ~f.getMask();
            }
            return this;
        }

        public Builder configure(TomlReadFeature feature, boolean state) {
            this._formatReadFeatures = state ? (this._formatReadFeatures |= feature.getMask()) : (this._formatReadFeatures &= ~feature.getMask());
            return this;
        }

        public Builder enable(TomlWriteFeature ... features) {
            for (TomlWriteFeature feature : features) {
                this._formatWriteFeatures |= feature.getMask();
            }
            return this;
        }

        public Builder disable(TomlWriteFeature ... features) {
            for (TomlWriteFeature feature : features) {
                this._formatWriteFeatures &= ~feature.getMask();
            }
            return this;
        }

        public Builder configure(TomlWriteFeature feature, boolean state) {
            this._formatWriteFeatures = state ? (this._formatWriteFeatures |= feature.getMask()) : (this._formatWriteFeatures &= ~feature.getMask());
            return this;
        }

        protected static class StateImpl
        extends MapperBuilderState
        implements Serializable {
            private static final long serialVersionUID = 3L;

            public StateImpl(Builder src) {
                super((MapperBuilder)src);
            }

            protected Object readResolve() {
                return new Builder(this).build();
            }
        }
    }

    private static final class SharedWrapper {
        private static final TomlMapper MAPPER = TomlMapper.builder().build();

        private SharedWrapper() {
        }

        public static TomlMapper wrapped() {
            return MAPPER;
        }
    }
}

