/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schema;

import com.squareup.protoparser.DataType;
import java.util.Arrays;

public enum FieldType {
    DOUBLE(1, DataType.ScalarType.DOUBLE),
    FLOAT(5, DataType.ScalarType.FLOAT),
    VINT32_Z(0, DataType.ScalarType.SINT32),
    VINT64_Z(0, DataType.ScalarType.SINT64),
    VINT32_STD(0, DataType.ScalarType.INT32, DataType.ScalarType.UINT32),
    VINT64_STD(0, DataType.ScalarType.INT64, DataType.ScalarType.UINT64),
    FIXINT32(5, DataType.ScalarType.FIXED32, DataType.ScalarType.SFIXED32),
    FIXINT64(1, DataType.ScalarType.FIXED64, DataType.ScalarType.SFIXED64),
    BOOLEAN(0, DataType.ScalarType.BOOL),
    STRING(2, DataType.ScalarType.STRING),
    BYTES(2, DataType.ScalarType.BYTES),
    ENUM(0, new DataType.ScalarType[0]),
    MESSAGE(2, new DataType.ScalarType[0]);

    private final int _wireType;
    private final DataType.ScalarType[] _aliases;

    private FieldType(int wt, DataType.ScalarType ... aliases) {
        this._wireType = wt;
        this._aliases = aliases;
    }

    public int getWireType() {
        return this._wireType;
    }

    public boolean usesZigZag() {
        return this == VINT32_Z || this == VINT64_Z;
    }

    public Iterable<DataType.ScalarType> aliases() {
        return Arrays.asList(this._aliases);
    }
}

