/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.protobuf.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.core.SerializableString;
import tools.jackson.dataformat.protobuf.schema.ProtobufEnum;

public abstract class EnumLookup {
    public static EnumLookup empty() {
        return Empty.instance;
    }

    public static EnumLookup construct(ProtobufEnum enumDef) {
        Map<String, Integer> enumEntries = enumDef.valueMapping();
        if (enumEntries.isEmpty()) {
            return Empty.instance;
        }
        ArrayList<Map.Entry<String, Integer>> l = new ArrayList<Map.Entry<String, Integer>>();
        for (Map.Entry<String, Integer> entry : enumDef.valueMapping().entrySet()) {
            l.add(entry);
        }
        switch (l.size()) {
            case 1: {
                return new Small1((String)((Map.Entry)l.get(0)).getKey(), (Integer)((Map.Entry)l.get(0)).getValue());
            }
            case 2: {
                return new Small2((String)((Map.Entry)l.get(0)).getKey(), (Integer)((Map.Entry)l.get(0)).getValue(), (String)((Map.Entry)l.get(1)).getKey(), (Integer)((Map.Entry)l.get(1)).getValue());
            }
            case 3: {
                return new Small3((String)((Map.Entry)l.get(0)).getKey(), (Integer)((Map.Entry)l.get(0)).getValue(), (String)((Map.Entry)l.get(1)).getKey(), (Integer)((Map.Entry)l.get(1)).getValue(), (String)((Map.Entry)l.get(2)).getKey(), (Integer)((Map.Entry)l.get(2)).getValue());
            }
        }
        return Big.construct(l);
    }

    public abstract String findEnumByIndex(int var1);

    public abstract int findEnumIndex(SerializableString var1);

    public abstract int findEnumIndex(String var1);

    public abstract Collection<String> getEnumValues();

    static class Empty
    extends EnumLookup {
        public static final Empty instance = new Empty();

        private Empty() {
        }

        @Override
        public int findEnumIndex(SerializableString key) {
            return -1;
        }

        @Override
        public int findEnumIndex(String key) {
            return -1;
        }

        @Override
        public Collection<String> getEnumValues() {
            return Collections.emptySet();
        }

        @Override
        public String findEnumByIndex(int index) {
            return null;
        }
    }

    static class Small1
    extends EnumLookup {
        protected final String key1;
        protected final int index1;

        Small1(String key, int index) {
            this.key1 = key;
            this.index1 = index;
        }

        @Override
        public String findEnumByIndex(int index) {
            if (index == this.index1) {
                return this.key1;
            }
            return null;
        }

        @Override
        public int findEnumIndex(SerializableString key) {
            if (this.key1.equals(key.getValue())) {
                return this.index1;
            }
            return -1;
        }

        @Override
        public int findEnumIndex(String key) {
            if (this.key1.equals(key)) {
                return this.index1;
            }
            return -1;
        }

        @Override
        public Collection<String> getEnumValues() {
            return Collections.singletonList(this.key1);
        }
    }

    static final class Small2
    extends EnumLookup {
        protected final String key1;
        protected final String key2;
        protected final int index1;
        protected final int index2;

        Small2(String k1, int i1, String k2, int i2) {
            this.key1 = k1;
            this.index1 = i1;
            this.key2 = k2;
            this.index2 = i2;
        }

        @Override
        public String findEnumByIndex(int index) {
            if (index == this.index1) {
                return this.key1;
            }
            if (index == this.index2) {
                return this.key2;
            }
            return null;
        }

        @Override
        public int findEnumIndex(SerializableString key0) {
            String key = key0.getValue();
            if (this.key1 == key) {
                return this.index1;
            }
            if (this.key2 == key) {
                return this.index2;
            }
            if (this.key1.equals(key)) {
                return this.index1;
            }
            if (this.key2.equals(key)) {
                return this.index2;
            }
            return -1;
        }

        @Override
        public int findEnumIndex(String key) {
            if (this.key1 == key) {
                return this.index1;
            }
            if (this.key2 == key) {
                return this.index2;
            }
            if (this.key1.equals(key)) {
                return this.index1;
            }
            if (this.key2.equals(key)) {
                return this.index2;
            }
            return -1;
        }

        @Override
        public Collection<String> getEnumValues() {
            return Arrays.asList(this.key1, this.key2);
        }
    }

    static final class Small3
    extends EnumLookup {
        protected final String key1;
        protected final String key2;
        protected final String key3;
        protected final int index1;
        protected final int index2;
        protected final int index3;

        Small3(String k1, int i1, String k2, int i2, String k3, int i3) {
            this.key1 = k1;
            this.index1 = i1;
            this.key2 = k2;
            this.index2 = i2;
            this.key3 = k3;
            this.index3 = i3;
        }

        @Override
        public String findEnumByIndex(int index) {
            if (index == this.index1) {
                return this.key1;
            }
            if (index == this.index2) {
                return this.key2;
            }
            if (index == this.index3) {
                return this.key3;
            }
            return null;
        }

        @Override
        public int findEnumIndex(SerializableString key0) {
            String key = key0.getValue();
            if (this.key1 == key) {
                return this.index1;
            }
            if (this.key2 == key) {
                return this.index2;
            }
            if (this.key3 == key) {
                return this.index3;
            }
            return this._findIndex2(key);
        }

        @Override
        public int findEnumIndex(String key) {
            if (this.key1 == key) {
                return this.index1;
            }
            if (this.key2 == key) {
                return this.index2;
            }
            if (this.key3 == key) {
                return this.index3;
            }
            return this._findIndex2(key);
        }

        @Override
        public Collection<String> getEnumValues() {
            return Arrays.asList(this.key1, this.key2, this.key3);
        }

        private int _findIndex2(String key) {
            if (this.key1.equals(key)) {
                return this.index1;
            }
            if (this.key2.equals(key)) {
                return this.index2;
            }
            if (this.key3.equals(key)) {
                return this.index3;
            }
            return -1;
        }
    }

    static final class Big
    extends EnumLookup {
        private final int _hashMask;
        private final int _spillCount;
        private final String[] _keys;
        private final int[] _indices;
        protected final LinkedHashMap<Integer, String> _enumsById;

        private Big(LinkedHashMap<Integer, String> byId, int hashMask, int spillCount, String[] keys, int[] indices) {
            this._enumsById = byId;
            this._hashMask = hashMask;
            this._spillCount = spillCount;
            this._keys = keys;
            this._indices = indices;
        }

        public static Big construct(List<Map.Entry<String, Integer>> entries) {
            LinkedHashMap<Integer, String> byId = new LinkedHashMap<Integer, String>();
            int size = Big.findSize(byId.size());
            int mask = size - 1;
            int alloc = size + (size >> 1);
            String[] keys = new String[alloc];
            int[] indices = new int[alloc];
            int spills = 0;
            for (Map.Entry<String, Integer> entry : entries) {
                String key = entry.getKey();
                int index = entry.getValue();
                byId.put(entry.getValue(), key);
                int slot = key.hashCode() & mask;
                if (keys[slot] != null && keys[slot = size + (slot >> 1)] != null) {
                    slot = size + (size >> 1) + spills;
                    ++spills;
                    if (slot >= keys.length) {
                        keys = Arrays.copyOf(keys, keys.length + 4);
                        indices = Arrays.copyOf(indices, indices.length + 4);
                    }
                }
                keys[slot] = key;
                indices[slot] = index;
            }
            return new Big(byId, mask, spills, keys, indices);
        }

        @Override
        public String findEnumByIndex(int index) {
            return this._enumsById.get(index);
        }

        @Override
        public int findEnumIndex(SerializableString key0) {
            String key = key0.getValue();
            int slot = key.hashCode() & this._hashMask;
            String match = this._keys[slot];
            if (match == key || key.equals(match)) {
                return this._indices[slot];
            }
            if (match == null) {
                return -1;
            }
            match = this._keys[slot = this._hashMask + 1 + (slot >> 1)];
            if (match == key || key.equals(match)) {
                return this._indices[slot];
            }
            if (this._spillCount > 0) {
                return this._findFromSpill(key);
            }
            return -1;
        }

        @Override
        public int findEnumIndex(String key) {
            int slot = key.hashCode() & this._hashMask;
            String match = this._keys[slot];
            if (match == key || key.equals(match)) {
                return this._indices[slot];
            }
            if (match == null) {
                return -1;
            }
            match = this._keys[slot = this._hashMask + 1 + (slot >> 1)];
            if (match == key || key.equals(match)) {
                return this._indices[slot];
            }
            if (this._spillCount > 0) {
                return this._findFromSpill(key);
            }
            return -1;
        }

        @Override
        public Collection<String> getEnumValues() {
            ArrayList<String> result = new ArrayList<String>(this._hashMask + 1);
            for (String str : this._keys) {
                if (str == null) continue;
                result.add(str);
            }
            return result;
        }

        private static final int findSize(int size) {
            int result;
            if (size <= 5) {
                return 8;
            }
            if (size <= 12) {
                return 16;
            }
            int needed = size + (size >> 2);
            for (result = 32; result < needed; result += result) {
            }
            return result;
        }

        private int _findFromSpill(String key) {
            int i;
            int hashSize = this._hashMask + 1;
            int end = i + this._spillCount;
            for (i = hashSize + (hashSize >> 1); i < end; ++i) {
                if (!key.equals(this._keys[i])) continue;
                return this._indices[i];
            }
            return -1;
        }
    }
}

