/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.Timestamp;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.PrettyPrinter;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.dataformat.ion.IonWriteContext;
import tools.jackson.dataformat.ion.IonWriteFeature;
import tools.jackson.dataformat.ion.PackageVersion;

public class IonGenerator
extends GeneratorBase {
    protected final IonWriter _writer;
    protected final boolean _ionWriterIsManaged;
    protected int _formatFeatures;
    protected final Closeable _destination;
    protected IonWriteContext _streamWriteContext;

    public IonGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int formatWriteFeatures, IonWriter ion, boolean ionWriterIsManaged, Closeable dst) {
        super(writeCtxt, ioCtxt, streamWriteFeatures);
        this._formatFeatures = formatWriteFeatures;
        this._writer = ion;
        this._ionWriterIsManaged = ionWriterIsManaged;
        this._destination = dst;
        DupDetector dups = StreamWriteFeature.STRICT_DUPLICATE_DETECTION.enabledIn(streamWriteFeatures) ? DupDetector.rootDetector((JsonGenerator)this) : null;
        this._streamWriteContext = IonWriteContext.createRootContext(dups);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public Object streamWriteOutputTarget() {
        return this._writer;
    }

    protected void _closeInput() throws IOException {
        if (this._ionWriterIsManaged) {
            this._writer.close();
        }
        if (this._ioContext.isResourceManaged()) {
            this._destination.close();
        } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM) && this._destination instanceof Flushable) {
            ((Flushable)((Object)this._destination)).flush();
        }
    }

    public void flush() {
        Object dst;
        if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM) && (dst = this._ioContext.contentReference().getRawContent()) instanceof Flushable) {
            try {
                ((Flushable)dst).flush();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    public boolean canWriteTypeId() {
        return IonWriteFeature.USE_NATIVE_TYPE_ID.enabledIn(this._formatFeatures);
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_BINARY_WRITE_CAPABILITIES;
    }

    public PrettyPrinter getPrettyPrinter() {
        return null;
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        return this.writeNumber((int)v);
    }

    public JsonGenerator writeNumber(int value) throws JacksonException {
        this._verifyValueWrite("write numeric value");
        try {
            this._writer.writeInt((long)value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(long value) throws JacksonException {
        this._verifyValueWrite("write numeric value");
        try {
            this._writer.writeInt(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(BigInteger value) throws JacksonException {
        if (value == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write numeric value");
        try {
            this._writer.writeInt(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(double value) throws JacksonException {
        this._verifyValueWrite("write numeric value");
        try {
            this._writer.writeFloat(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(float value) throws JacksonException {
        this._verifyValueWrite("write numeric value");
        try {
            this._writer.writeFloat((double)value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal value) throws JacksonException {
        if (value == null) {
            return this.writeNull();
        }
        this._verifyValueWrite("write numeric value");
        try {
            this._writer.writeDecimal(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(String value) throws JacksonException {
        return this.writeString(value);
    }

    public JsonGenerator writeSymbol(String value) throws JacksonException {
        this._verifyValueWrite("write symbol value");
        try {
            this._writer.writeSymbol(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator annotateNextValue(String annotation) {
        this._writer.addTypeAnnotation(annotation);
        return this;
    }

    public JsonGenerator writeDate(Calendar value) throws JacksonException {
        this._verifyValueWrite("write date value");
        try {
            this._writer.writeTimestamp(Timestamp.forCalendar((Calendar)value));
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeString(String value) throws JacksonException {
        this._verifyValueWrite("write text value");
        try {
            this._writer.writeString(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeString(char[] buffer, int offset, int length) throws JacksonException {
        return this.writeString(new String(buffer, offset, length));
    }

    public JsonGenerator writeUTF8String(byte[] buffer, int offset, int length) throws JacksonException {
        return this.writeString(new String(buffer, offset, length, StandardCharsets.UTF_8));
    }

    public JsonGenerator writeRaw(String value) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeRaw(char value) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeRaw(String value, int arg1, int arg2) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeRaw(char[] value, int arg1, int arg2) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeRawValue(String value) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeRawValue(String value, int arg1, int arg2) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeRawValue(char[] value, int arg1, int arg2) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int length) throws JacksonException {
        return (JsonGenerator)this._reportNoRaw();
    }

    public JsonGenerator writeBinary(Base64Variant b64v, byte[] data, int offset, int length) throws JacksonException {
        this._verifyValueWrite("write binary data");
        try {
            this._writer.writeBlob(data, offset, length);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeBoolean(boolean value) throws JacksonException {
        this._verifyValueWrite("write boolean");
        try {
            this._writer.writeBool(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNull() throws JacksonException {
        this._verifyValueWrite("write null");
        try {
            this._writer.writeNull();
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNull(IonType ionType) throws JacksonException {
        this._verifyValueWrite("write null");
        try {
            this._writer.writeNull(ionType);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeValue(IonValue value) throws JacksonException {
        this._verifyValueWrite("write ion value");
        if (value == null) {
            try {
                this._writer.writeNull();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        } else {
            value.writeTo(this._writer);
        }
        return this;
    }

    public JsonGenerator writeValue(Timestamp value) throws JacksonException {
        this._verifyValueWrite("write timestamp");
        try {
            if (value == null) {
                this._writer.writeNull();
            } else {
                this._writer.writeTimestamp(value);
            }
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    protected void _releaseBuffers() {
    }

    protected void _verifyValueWrite(String msg) throws JacksonException {
        if (!this._streamWriteContext.writeValue()) {
            this._reportError("Can not " + msg + ", expecting a property name");
        }
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.getParent();
        try {
            this._writer.stepOut();
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.getParent();
        try {
            this._writer.stepOut();
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeEndSexp() throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.getParent();
        try {
            this._writer.stepOut();
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeName(String value) throws JacksonException {
        if (!this._streamWriteContext.writeName(value)) {
            throw this._constructWriteException("Can not write a property name, expecting a value");
        }
        this._writeName(value);
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        String idStr = Long.valueOf(id).toString();
        return this.writeName(idStr);
    }

    protected void _writeName(String value) throws JacksonException {
        this._writer.setFieldName(value);
    }

    public JsonGenerator writeStartArray() throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        try {
            this._writer.stepIn(IonType.LIST);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this._verifyValueWrite("start an array");
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(currValue);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        try {
            this._writer.stepIn(IonType.LIST);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        try {
            this._writer.stepIn(IonType.STRUCT);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeStartObject(Object currValue) throws JacksonException {
        this._verifyValueWrite("start an object");
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(currValue);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        try {
            this._writer.stepIn(IonType.STRUCT);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeStartSexp() throws JacksonException {
        this._verifyValueWrite("start a sexp");
        this._streamWriteContext = this._streamWriteContext.createChildSexpContext(null);
        this.streamWriteConstraints().validateNestingDepth(this._streamWriteContext.getNestingDepth());
        try {
            this._writer.stepIn(IonType.SEXP);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeTypeId(Object rawId) throws JacksonException {
        if (rawId instanceof String[]) {
            String[] ids;
            for (String id : ids = (String[])rawId) {
                this.annotateNextValue(id);
            }
        } else {
            this.annotateNextValue(String.valueOf(rawId));
        }
        return this;
    }

    public String toString() {
        return "[" + ((Object)((Object)this)).getClass().getSimpleName() + ", Ion writer: " + String.valueOf(this._writer) + "]";
    }

    protected <T> T _reportNoRaw() throws JacksonException {
        throw this._constructWriteException("writeRaw() functionality not available with Ion backend");
    }
}

