/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import com.amazon.ion.Timestamp;
import java.util.Date;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.jdk.JavaUtilDateDeserializer;
import tools.jackson.databind.ext.sql.JavaSqlDateDeserializer;

public class IonTimestampDeserializers {

    public static class IonTimestampSQLDateDeserializer
    extends JavaSqlDateDeserializer {
        public java.sql.Date deserialize(JsonParser p, DeserializationContext ctxt) {
            Object embedded;
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT) && (embedded = p.getEmbeddedObject()) instanceof Timestamp) {
                return new java.sql.Date(((Timestamp)embedded).dateValue().getTime());
            }
            return super.deserialize(p, ctxt);
        }
    }

    public static class IonTimestampJavaDateDeserializer
    extends JavaUtilDateDeserializer {
        public Date deserialize(JsonParser p, DeserializationContext ctxt) {
            Object embedded;
            if (p.hasToken(JsonToken.VALUE_EMBEDDED_OBJECT) && (embedded = p.getEmbeddedObject()) instanceof Timestamp) {
                return ((Timestamp)embedded).dateValue();
            }
            return super.deserialize(p, ctxt);
        }
    }
}

