/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion.ionvalue;

import com.amazon.ion.IonList;
import com.amazon.ion.IonSexp;
import com.amazon.ion.IonStruct;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.Timestamp;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.util.AccessPattern;
import tools.jackson.dataformat.ion.IonParser;

class IonValueDeserializer
extends ValueDeserializer<IonValue> {
    private final JavaType _targetType;

    public IonValueDeserializer() {
        this._targetType = null;
    }

    public IonValueDeserializer(JavaType targetType) {
        this._targetType = targetType;
    }

    public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
        JavaType contextualType = property != null ? property.getType() : ctxt.getContextualType();
        return new IonValueDeserializer(contextualType);
    }

    public IonValue deserialize(JsonParser jp, DeserializationContext ctxt) throws JacksonException {
        Object embeddedObject = jp.getEmbeddedObject();
        if (embeddedObject instanceof IonValue) {
            return (IonValue)embeddedObject;
        }
        if (!(jp instanceof IonParser)) {
            throw DatabindException.from((JsonParser)jp, (String)("Unsupported parser for deserializing " + embeddedObject.getClass().getCanonicalName() + " into IonValue"));
        }
        IonSystem ionSystem = ((IonParser)jp).getIonSystem();
        if (embeddedObject instanceof Timestamp) {
            return ionSystem.newTimestamp((Timestamp)embeddedObject);
        }
        if (embeddedObject instanceof byte[]) {
            return ionSystem.newBlob((byte[])embeddedObject);
        }
        throw DatabindException.from((JsonParser)jp, (String)("Cannot deserialize embedded object type " + embeddedObject.getClass().getCanonicalName() + " into IonValue"));
    }

    public Object getNullValue(DeserializationContext ctxt) throws JacksonException {
        IonValue iv;
        Object embeddedObj;
        JsonParser parser = ctxt.getParser();
        if (parser != null && parser.currentToken() != JsonToken.END_OBJECT && (embeddedObj = parser.getEmbeddedObject()) instanceof IonValue && (iv = (IonValue)embeddedObj).isNullValue()) {
            if (IonType.isContainer((IonType)iv.getType())) {
                return iv;
            }
            IonType containerType = this.getIonContainerType();
            if (containerType != null) {
                IonSystem ionSystem = ((IonParser)parser).getIonSystem();
                return ionSystem.newNull(containerType);
            }
            return iv;
        }
        return super.getNullValue(ctxt);
    }

    private IonType getIonContainerType() {
        if (this._targetType != null) {
            Class clazz = this._targetType.getRawClass();
            if (IonStruct.class.isAssignableFrom(clazz)) {
                return IonType.STRUCT;
            }
            if (IonList.class.isAssignableFrom(clazz)) {
                return IonType.LIST;
            }
            if (IonSexp.class.isAssignableFrom(clazz)) {
                return IonType.SEXP;
            }
        }
        return null;
    }

    public AccessPattern getNullAccessPattern() {
        return AccessPattern.DYNAMIC;
    }
}

