/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion.polymorphism;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.impl.TypeDeserializerBase;
import tools.jackson.dataformat.ion.IonParser;
import tools.jackson.dataformat.ion.polymorphism.MultipleTypeIdResolver;

public class IonAnnotationTypeDeserializer
extends TypeDeserializerBase {
    public IonAnnotationTypeDeserializer(JavaType baseType, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        super(baseType, idRes, typePropertyName, typeIdVisible, defaultImpl);
    }

    public JsonTypeInfo.As getTypeInclusion() {
        return null;
    }

    private IonParser ionParser(JsonParser p) throws StreamReadException {
        if (p instanceof IonParser) {
            return (IonParser)p;
        }
        throw new StreamReadException(p, "Can only use IonAnnotationTypeDeserializer with IonParser");
    }

    private Object _deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        String[] typeIds = this.ionParser(p).getTypeAnnotations();
        String typeIdToUse = null;
        TypeIdResolver typeIdResolver = super.getTypeIdResolver();
        if (typeIdResolver instanceof MultipleTypeIdResolver) {
            typeIdToUse = ((MultipleTypeIdResolver)typeIdResolver).selectId(typeIds);
        } else if (null != typeIdResolver) {
            for (String typeId : typeIds) {
                JavaType type = typeIdResolver.typeFromId((DatabindContext)ctxt, typeId);
                if (null == type) continue;
                typeIdToUse = typeId;
            }
        }
        ValueDeserializer deserializer = null == typeIdToUse ? this._findDefaultImplDeserializer(ctxt) : super._findDeserializer(ctxt, typeIdToUse);
        if (deserializer == null) {
            return null;
        }
        return deserializer.deserialize(p, ctxt);
    }

    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) {
        return this._deserialize(p, ctxt);
    }

    public Object deserializeTypedFromArray(JsonParser p, DeserializationContext ctxt) {
        return this._deserialize(p, ctxt);
    }

    public Object deserializeTypedFromScalar(JsonParser p, DeserializationContext ctxt) {
        return this._deserialize(p, ctxt);
    }

    public Object deserializeTypedFromAny(JsonParser p, DeserializationContext ctxt) {
        return this._deserialize(p, ctxt);
    }

    public TypeDeserializer forProperty(BeanProperty prop) {
        return this;
    }
}

