/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import tools.jackson.core.JsonGenerator;
import tools.jackson.core.exc.StreamWriteException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.cfg.DatatypeFeature;
import tools.jackson.databind.cfg.EnumFeature;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.ser.std.StdScalarSerializer;
import tools.jackson.dataformat.ion.IonGenerator;

public class EnumAsIonSymbolSerializer
extends StdScalarSerializer<Enum<?>> {
    public EnumAsIonSymbolSerializer() {
        super(Enum.class, false);
    }

    public void serialize(Enum<?> value, JsonGenerator g, SerializationContext provider) {
        if (!(g instanceof IonGenerator)) {
            throw new StreamWriteException(g, "Can only use EnumAsIonSymbolSerializer with IonGenerator");
        }
        String valueString = provider.isEnabled((DatatypeFeature)EnumFeature.WRITE_ENUMS_USING_TO_STRING) ? value.toString() : value.name();
        ((IonGenerator)g).writeSymbol(valueString);
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        this.visitStringFormat(visitor, typeHint);
    }
}

