/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.ion;

import com.amazon.ion.IonReader;
import com.amazon.ion.IonSystem;
import com.amazon.ion.IonValue;
import com.amazon.ion.IonWriter;
import com.amazon.ion.SymbolTable;
import com.amazon.ion.system.IonSystemBuilder;
import com.amazon.ion.system.IonTextWriterBuilder;
import java.io.CharArrayReader;
import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Path;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.DecorableTSFactory;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.io.UTF8Writer;
import tools.jackson.dataformat.ion.IonFactoryBuilder;
import tools.jackson.dataformat.ion.IonGenerator;
import tools.jackson.dataformat.ion.IonParser;
import tools.jackson.dataformat.ion.IonReadFeature;
import tools.jackson.dataformat.ion.IonWriteFeature;
import tools.jackson.dataformat.ion.PackageVersion;

public class IonFactory
extends DecorableTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_ION = "AmazonIon";
    protected static final boolean DEFAULT_CREATE_BINARY = false;
    protected static final int DEFAULT_ION_PARSER_FEATURE_FLAGS = IonReadFeature.collectDefaults();
    protected static final int DEFAULT_ION_GENERATOR_FEATURE_FLAGS = IonWriteFeature.collectDefaults();
    protected final boolean _cfgBinaryWriters;
    protected final IonSystem _system;

    public IonFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), DEFAULT_ION_PARSER_FEATURE_FLAGS, DEFAULT_ION_GENERATOR_FEATURE_FLAGS);
        this._cfgBinaryWriters = false;
        this._system = IonSystemBuilder.standard().build();
    }

    protected IonFactory(IonFactory src) {
        super((DecorableTSFactory)src);
        this._cfgBinaryWriters = src._cfgBinaryWriters;
        this._system = src._system;
    }

    protected IonFactory(IonFactoryBuilder b) {
        super((DecorableTSFactory.DecorableTSFBuilder)b);
        this._cfgBinaryWriters = b.willCreateBinaryWriters();
        this._system = b.ionSystem();
    }

    public IonFactoryBuilder rebuild() {
        return new IonFactoryBuilder(this);
    }

    public static IonFactory forBinaryWriters() {
        return new IonFactoryBuilder(true).build();
    }

    public static IonFactoryBuilder builderForBinaryWriters() {
        return new IonFactoryBuilder(true);
    }

    public static IonFactory forTextualWriters() {
        return new IonFactoryBuilder(false).build();
    }

    public static IonFactoryBuilder builderForTextualWriters() {
        return new IonFactoryBuilder(false);
    }

    public IonFactory copy() {
        return new IonFactory(this);
    }

    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new IonFactory(this);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canParseAsync() {
        return false;
    }

    public boolean canHandleBinaryNatively() {
        return this._cfgBinaryWriters;
    }

    public final boolean isEnabled(IonReadFeature f) {
        return (this._formatReadFeatures & f.getMask()) != 0;
    }

    public final boolean isEnabled(IonWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    public String getFormatName() {
        return FORMAT_NAME_ION;
    }

    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    public Class<IonReadFeature> getFormatReadFeatureType() {
        return IonReadFeature.class;
    }

    public Class<IonWriteFeature> getFormatWriteFeatureType() {
        return IonWriteFeature.class;
    }

    public JsonParser createParser(ObjectReadContext readCtxt, File f) {
        InputStream in = this._fileInputStream(f);
        IOContext ioCtxt = this._createContext(this._createContentReference(f), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    public JsonParser createParser(ObjectReadContext readCtxt, Path p) throws JacksonException {
        InputStream in = this._pathInputStream(p);
        IOContext ioCtxt = this._createContext(this._createContentReference(p), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    public JsonParser createParser(ObjectReadContext readCtxt, URL url) {
        InputStream in = this._optimizedStreamFromURL(url);
        IOContext ioCtxt = this._createContext(this._createContentReference(url), true);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    public JsonParser createParser(ObjectReadContext readCtxt, InputStream in) {
        IOContext ioCtxt = this._createContext(this._createContentReference(in), false);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, in));
    }

    public JsonParser createParser(ObjectReadContext readCtxt, Reader r) {
        IOContext ioCtxt = this._createContext(this._createContentReference(r), false);
        return this._createParser(readCtxt, ioCtxt, this._decorate(ioCtxt, r));
    }

    public JsonParser createParser(ObjectReadContext readCtxt, byte[] data) {
        InputStream in;
        IOContext ioCtxt = this._createContext(this._createContentReference(data), true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ioCtxt, data, 0, data.length)) != null) {
            return this._createParser(readCtxt, ioCtxt, in);
        }
        return this._createParser(readCtxt, ioCtxt, data, 0, data.length);
    }

    public JsonParser createParser(ObjectReadContext readCtxt, byte[] data, int offset, int len) {
        InputStream in;
        IOContext ioCtxt = this._createContext(this._createContentReference(data, offset, len), true);
        if (this._inputDecorator != null && (in = this._inputDecorator.decorate(ioCtxt, data, offset, len)) != null) {
            return this._createParser(readCtxt, ioCtxt, in);
        }
        return this._createParser(readCtxt, ioCtxt, data, offset, len);
    }

    public JsonParser createParser(ObjectReadContext readCtxt, String content) {
        return this.createParser(readCtxt, new StringReader(content));
    }

    public JsonParser createParser(ObjectReadContext readCtxt, char[] content, int offset, int len) {
        if (this._inputDecorator != null) {
            return this.createParser(readCtxt, new CharArrayReader(content, offset, len));
        }
        return this._createParser(readCtxt, this._createContext(this._createContentReference(content), true), content, offset, len, false);
    }

    public JsonParser createParser(ObjectReadContext readCtxt, DataInput in) {
        return (JsonParser)this._unsupported();
    }

    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, OutputStream out, JsonEncoding enc) {
        return this._createGenerator(writeCtxt, out, enc, false);
    }

    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, Writer w) {
        if (this._cfgBinaryWriters) {
            throw new UnsupportedOperationException("Can only create binary Ion writers that output to OutputStream, not Writer");
        }
        return this._createGenerator(writeCtxt, this._createContext(this._createContentReference(w), false), this._createTextualIonWriter(writeCtxt, w), true, w);
    }

    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, File f, JsonEncoding enc) {
        OutputStream out = this._fileOutputStream(f);
        return this._createGenerator(writeCtxt, out, enc, true);
    }

    public JsonGenerator createGenerator(ObjectWriteContext writeCtxt, Path p, JsonEncoding enc) throws JacksonException {
        OutputStream out = this._pathOutputStream(p);
        return this._createGenerator(writeCtxt, out, enc, true);
    }

    protected ContentReference _createContentReference(Object contentRef) {
        return ContentReference.construct((!this._cfgBinaryWriters ? 1 : 0) != 0, (Object)contentRef, (ErrorReportConfiguration)this.errorReportConfiguration());
    }

    protected ContentReference _createContentReference(Object contentRef, int offset, int length) {
        return ContentReference.construct((!this._cfgBinaryWriters ? 1 : 0) != 0, (Object)contentRef, (int)offset, (int)length, (ErrorReportConfiguration)this.errorReportConfiguration());
    }

    public IonSystem getIonSystem() {
        return this._system;
    }

    public IonParser createParser(ObjectReadContext readCtxt, IonReader in) {
        return new IonParser(readCtxt, this._createContext(this._createContentReference(in), false), readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), in, this._system);
    }

    public IonParser createParser(ObjectReadContext readCtxt, IonValue value) {
        IonReader in = value.getSystem().newReader(value);
        return new IonParser(readCtxt, this._createContext(this._createContentReference(in), true), readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), in, this._system);
    }

    public IonGenerator createGenerator(ObjectWriteContext writeCtxt, IonWriter out) {
        return this._createGenerator(writeCtxt, this._createContext(this._createContentReference(out), false), out, false, (Closeable)out);
    }

    private JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) {
        IonReader ion = this._system.newReader(in);
        ioCtxt = this._createContext(this._createContentReference(ion), true);
        return new IonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), ion, this._system);
    }

    private JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, Reader r) {
        IonReader ion = this._system.newReader(r);
        ioCtxt = this._createContext(this._createContentReference(ion), true);
        return new IonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), ion, this._system);
    }

    private JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, char[] data, int offset, int len, boolean recyclable) {
        return this._createParser(readCtxt, ioCtxt, new CharArrayReader(data, offset, len));
    }

    private JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) {
        IonReader ion = this._system.newReader(data, offset, len);
        ioCtxt = this._createContext(this._createContentReference(ion), true);
        return new IonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._system.newReader(data, offset, len), this._system);
    }

    protected IonGenerator _createGenerator(ObjectWriteContext writeCtxt, OutputStream out, JsonEncoding enc, boolean isManaged) {
        OutputStream dst;
        IonWriter ion;
        IOContext ioCtxt = this._createContext(this._createContentReference(out), isManaged);
        if (this._cfgBinaryWriters) {
            ioCtxt.setEncoding(enc);
            ion = this._system.newBinaryWriter(out, new SymbolTable[0]);
            dst = out;
        } else {
            if (enc != JsonEncoding.UTF8) {
                throw this._wrapIOFailure(new IOException("Ion only supports UTF-8 encoding, can not use " + String.valueOf(enc)));
            }
            ioCtxt.setEncoding(enc);
            UTF8Writer w = new UTF8Writer(ioCtxt, out);
            ion = this._createTextualIonWriter(writeCtxt, (Writer)w);
            dst = w;
        }
        return this._createGenerator(writeCtxt, ioCtxt, ion, true, dst);
    }

    protected IonWriter _createTextualIonWriter(ObjectWriteContext writeCtxt, Writer w) {
        if (writeCtxt.hasPrettyPrinter()) {
            return IonTextWriterBuilder.pretty().build((Appendable)w);
        }
        return this._system.newTextWriter((Appendable)w);
    }

    protected IonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, IonWriter ion, boolean ionWriterIsManaged, Closeable dst) {
        return new IonGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), ion, ionWriterIsManaged, dst);
    }
}

