/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.csv;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashSet;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserMinimalBase;
import tools.jackson.core.exc.StreamReadException;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.DupDetector;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamReadContext;
import tools.jackson.core.util.TextBuffer;
import tools.jackson.dataformat.csv.CsvReadException;
import tools.jackson.dataformat.csv.CsvReadFeature;
import tools.jackson.dataformat.csv.CsvSchema;
import tools.jackson.dataformat.csv.CsvValueDecorator;
import tools.jackson.dataformat.csv.PackageVersion;
import tools.jackson.dataformat.csv.impl.CsvDecoder;

public class CsvParser
extends ParserMinimalBase {
    private static final int MAX_COLUMNS = 99999;
    private static final CsvSchema EMPTY_SCHEMA = CsvSchema.emptySchema();
    protected static final JacksonFeatureSet<StreamReadCapability> STREAM_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.UNTYPED_SCALARS);
    protected static final int STATE_DOC_START = 0;
    protected static final int STATE_RECORD_START = 1;
    protected static final int STATE_NEXT_ENTRY = 2;
    protected static final int STATE_NAMED_VALUE = 3;
    protected static final int STATE_UNNAMED_VALUE = 4;
    protected static final int STATE_IN_ARRAY = 5;
    protected static final int STATE_SKIP_EXTRA_COLUMNS = 6;
    protected static final int STATE_MISSING_NAME = 7;
    protected static final int STATE_MISSING_VALUE = 8;
    protected static final int STATE_DOC_END = 9;
    protected int _formatFeatures;
    protected CsvSchema _schema;
    protected int _columnCount = 0;
    protected boolean _cfgEmptyStringAsNull;
    protected boolean _cfgEmptyUnquotedStringAsNull;
    protected SimpleStreamReadContext _streamReadContext;
    protected String _currentName;
    protected String _currentValue;
    protected int _columnIndex;
    protected int _state = 0;
    protected byte[] _binaryValue;
    protected int _arrayValueStart;
    protected String _arrayValue;
    protected String _arraySeparator;
    protected String _nullValue;
    protected final CsvDecoder _reader;
    protected final TextBuffer _textBuffer;
    protected ByteArrayBuilder _byteArrayBuilder;

    public CsvParser(ObjectReadContext readCtxt, IOContext ioCtxt, int stdFeatures, int csvFeatures, CsvSchema schema, Reader reader) {
        super(readCtxt, ioCtxt, stdFeatures);
        if (reader == null) {
            throw new IllegalArgumentException("Can not pass `null` as `java.io.Reader` to read from");
        }
        this._formatFeatures = csvFeatures;
        DupDetector dups = StreamReadFeature.STRICT_DUPLICATE_DETECTION.enabledIn(stdFeatures) ? DupDetector.rootDetector((JsonParser)this) : null;
        this._streamReadContext = SimpleStreamReadContext.createRootContext((DupDetector)dups);
        this._textBuffer = ioCtxt.constructReadConstrainedTextBuffer();
        this._reader = new CsvDecoder(ioCtxt, this, reader, schema, this._textBuffer, stdFeatures, csvFeatures);
        this._setSchema(schema);
        this._cfgEmptyStringAsNull = CsvReadFeature.EMPTY_STRING_AS_NULL.enabledIn(csvFeatures);
        this._cfgEmptyUnquotedStringAsNull = CsvReadFeature.EMPTY_UNQUOTED_STRING_AS_NULL.enabledIn(csvFeatures);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canReadObjectId() {
        return false;
    }

    public boolean canReadTypeId() {
        return false;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return STREAM_READ_CAPABILITIES;
    }

    public int releaseBuffered(Writer out) {
        try {
            return this._reader.releaseBuffered(out);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
    }

    protected void _closeInput() throws IOException {
        this._reader.close();
    }

    protected void _releaseBuffers() {
    }

    public JsonParser enable(CsvReadFeature f) {
        this._formatFeatures |= f.getMask();
        this._cfgEmptyStringAsNull = CsvReadFeature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        this._cfgEmptyUnquotedStringAsNull = CsvReadFeature.EMPTY_UNQUOTED_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser disable(CsvReadFeature f) {
        this._formatFeatures &= ~f.getMask();
        this._cfgEmptyStringAsNull = CsvReadFeature.EMPTY_STRING_AS_NULL.enabledIn(this._formatFeatures);
        this._cfgEmptyUnquotedStringAsNull = CsvReadFeature.EMPTY_UNQUOTED_STRING_AS_NULL.enabledIn(this._formatFeatures);
        return this;
    }

    public JsonParser configure(CsvReadFeature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public boolean isEnabled(CsvReadFeature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public CsvSchema getSchema() {
        return this._schema;
    }

    public TokenStreamContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    public TokenStreamLocation currentTokenLocation() {
        return this._reader.getTokenLocation();
    }

    public TokenStreamLocation currentLocation() {
        return this._reader.getCurrentLocation();
    }

    public Object streamReadInputSource() {
        return this._reader.getInputSource();
    }

    public boolean isExpectedStartArrayToken() {
        if (this._currToken == null) {
            return false;
        }
        switch (this._currToken.id()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        if (this._columnIndex < this._columnCount) {
            CsvSchema.Column column = this._schema.column(this._columnIndex);
            if (column.getType() == CsvSchema.ColumnType.STRING) {
                this._startArray(column);
                return true;
            }
        } else if (this._currToken == JsonToken.VALUE_STRING) {
            this._startArray(CsvSchema.Column.PLACEHOLDER);
            return true;
        }
        return false;
    }

    public boolean isExpectedNumberIntToken() {
        JsonToken t = this._currToken;
        if (t == JsonToken.VALUE_STRING) {
            if (this._reader.isExpectedNumberIntToken()) {
                this._updateToken(JsonToken.VALUE_NUMBER_INT);
                return true;
            }
            return false;
        }
        return t == JsonToken.VALUE_NUMBER_INT;
    }

    public String currentName() {
        return this._currentName;
    }

    public JsonToken nextToken() throws JacksonException {
        this._binaryValue = null;
        switch (this._state) {
            case 0: {
                return this._updateToken(this._handleStartDoc());
            }
            case 1: {
                return this._updateToken(this._handleRecordStart());
            }
            case 2: {
                return this._updateToken(this._handleNextEntry());
            }
            case 3: {
                return this._updateToken(this._handleNamedValue());
            }
            case 4: {
                return this._updateToken(this._handleUnnamedValue());
            }
            case 5: {
                return this._updateToken(this._handleArrayValue());
            }
            case 6: {
                return this._skipUntilEndOfLine();
            }
            case 7: {
                return this._updateToken(this._handleMissingName());
            }
            case 8: {
                return this._updateToken(this._handleMissingValue());
            }
            case 9: {
                try {
                    this._reader.close();
                }
                catch (IOException e) {
                    throw this._wrapIOFailure(e);
                }
                if (this._streamReadContext.inRoot()) {
                    return null;
                }
                boolean inArray = this._streamReadContext.inArray();
                this._streamReadContext = this._streamReadContext.clearAndGetParent();
                return inArray ? JsonToken.END_ARRAY : JsonToken.END_OBJECT;
            }
        }
        throw new IllegalStateException();
    }

    public boolean nextName(SerializableString str) throws JacksonException {
        if (this._state == 2) {
            this._binaryValue = null;
            JsonToken t = this._updateToken(this._handleNextEntry());
            if (t == JsonToken.PROPERTY_NAME) {
                return str.getValue().equals(this._currentName);
            }
            return false;
        }
        return this.nextToken() == JsonToken.PROPERTY_NAME && str.getValue().equals(this.currentName());
    }

    public String nextName() throws JacksonException {
        if (this._state == 2) {
            this._binaryValue = null;
            JsonToken t = this._updateToken(this._handleNextEntry());
            if (t == JsonToken.PROPERTY_NAME) {
                return this._currentName;
            }
            return null;
        }
        return this.nextToken() == JsonToken.PROPERTY_NAME ? this.currentName() : null;
    }

    public String nextStringValue() throws JacksonException {
        this._binaryValue = null;
        if (this._state == 3) {
            JsonToken t = this._updateToken(this._handleNamedValue());
            if (t == JsonToken.VALUE_STRING) {
                return this._currentValue;
            }
        } else if (this._state == 4) {
            JsonToken t = this._updateToken(this._handleUnnamedValue());
            if (t == JsonToken.VALUE_STRING) {
                return this._currentValue;
            }
        } else {
            JsonToken t = this.nextToken();
            if (t == JsonToken.VALUE_STRING) {
                return this.getString();
            }
        }
        return null;
    }

    protected void _readHeaderLine() throws JacksonException {
        int diff;
        CsvSchema newSchema;
        int newColumnCount;
        String name;
        int schemaColumnCount = this._schema.size();
        if (schemaColumnCount > 0 && !this._schema.reordersColumns()) {
            if (this._schema.strictHeaders()) {
                String name2;
                int ix = 0;
                for (CsvSchema.Column column : this._schema._columns) {
                    name2 = this._reader.nextString();
                    ++ix;
                    if (name2 == null) {
                        this._reportError(String.format("Missing header column #%d, expecting \"%s\"", ix, column.getName()));
                        continue;
                    }
                    if (column.getName().equals(name2)) continue;
                    this._reportError(String.format("Mismatched header column #%d: expected \"%s\", actual \"%s\"", ix, column.getName(), name2));
                }
                name2 = this._reader.nextString();
                if (name2 != null) {
                    this._reportError(String.format("Extra header column \"%s\"", name2));
                }
            } else {
                int allowed = 99999;
                while (this._reader.nextString() != null) {
                    if (--allowed >= 0) continue;
                    this._reportError("Internal error: skipped 99999 header columns");
                }
            }
            return;
        }
        CsvSchema.Builder builder = this._schema.rebuild().clearColumns();
        int count = 0;
        boolean trimHeaderNames = CsvReadFeature.TRIM_HEADER_SPACES.enabledIn(this._formatFeatures);
        while ((name = this._reader.nextString()) != null) {
            CsvSchema.Column prev;
            if (trimHeaderNames) {
                name = name.trim();
            }
            if ((prev = this._schema.column(name)) != null) {
                builder.addColumn(name, prev.getType());
            } else {
                builder.addColumn(name);
            }
            if (++count <= 99999) continue;
            this._reportError("Internal error: reached maximum of 99999 header columns");
        }
        if (CsvReadFeature.ALLOW_TRAILING_COMMA.enabledIn(this._formatFeatures)) {
            builder.dropLastColumnIfEmpty();
        }
        if ((newColumnCount = (newSchema = builder.build()).size()) < 2) {
            String first;
            String string = first = newColumnCount == 0 ? "" : newSchema.columnName(0).trim();
            if (first.isEmpty()) {
                this._reportCsvReadError("Empty header line: can not bind data", new Object[0]);
            }
        }
        if ((diff = schemaColumnCount - newColumnCount) > 0 && CsvReadFeature.FAIL_ON_MISSING_HEADER_COLUMNS.enabledIn(this._formatFeatures)) {
            LinkedHashSet<String> oldColumnNames = new LinkedHashSet<String>();
            this._schema.getColumnNames(oldColumnNames);
            oldColumnNames.removeAll(newSchema.getColumnNames());
            this._reportCsvReadError(String.format("Missing %d header column%s: [\"%s\"]", diff, diff == 1 ? "" : "s", String.join((CharSequence)"\",\"", oldColumnNames)), new Object[0]);
        }
        this._setSchema(builder.build());
    }

    protected JsonToken _handleStartDoc() throws JacksonException {
        this._reader.skipLinesWhenNeeded();
        if (this._schema.usesHeader()) {
            this._readHeaderLine();
            this._reader.skipLinesWhenNeeded();
        }
        if (this._schema.skipsFirstDataRow()) {
            this._reader.skipLine();
            this._reader.skipLinesWhenNeeded();
        }
        boolean wrapAsArray = CsvReadFeature.WRAP_AS_ARRAY.enabledIn(this._formatFeatures);
        if (!this._reader.hasMoreInput()) {
            this._state = 9;
            if (wrapAsArray) {
                this._streamReadContext = this._reader.childArrayContext(this._streamReadContext);
                return JsonToken.START_ARRAY;
            }
            return null;
        }
        if (wrapAsArray) {
            this._streamReadContext = this._reader.childArrayContext(this._streamReadContext);
            this._state = 1;
            return JsonToken.START_ARRAY;
        }
        return this._handleRecordStart();
    }

    protected JsonToken _handleRecordStart() throws JacksonException {
        this._columnIndex = 0;
        if (this._columnCount == 0) {
            this._state = 4;
            this._streamReadContext = this._reader.childArrayContext(this._streamReadContext);
            return JsonToken.START_ARRAY;
        }
        this._streamReadContext = this._reader.childObjectContext(this._streamReadContext);
        this._state = 2;
        return JsonToken.START_OBJECT;
    }

    protected JsonToken _handleNextEntry() throws JacksonException {
        String next;
        try {
            next = this._reader.nextString();
        }
        catch (RuntimeException e) {
            this._state = 6;
            throw e;
        }
        if (next == null) {
            if (this._columnIndex < this._columnCount) {
                return this._handleMissingColumns();
            }
            return this._handleObjectRowEnd();
        }
        if (this._columnIndex >= this._columnCount) {
            this._currentValue = next;
            return this._handleExtraColumn(next);
        }
        CsvSchema.Column column = this._schema.column(this._columnIndex);
        this._state = 3;
        this._currentName = column.getName();
        CsvValueDecorator dec = column.getValueDecorator();
        this._currentValue = dec == null ? next : dec.undecorateValue(this, next);
        return JsonToken.PROPERTY_NAME;
    }

    protected JsonToken _handleNamedValue() throws JacksonException {
        if (this._columnIndex < this._columnCount) {
            CsvSchema.Column column = this._schema.column(this._columnIndex);
            ++this._columnIndex;
            if (column.isArray()) {
                this._startArray(column);
                return JsonToken.START_ARRAY;
            }
        }
        this._state = 2;
        if (this._isNullValue(this._currentValue)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleUnnamedValue() throws JacksonException {
        String next = this._reader.nextString();
        if (next == null) {
            this._streamReadContext = this._streamReadContext.clearAndGetParent();
            this._state = !this._reader.startNewLine() ? 9 : 1;
            return JsonToken.END_ARRAY;
        }
        this._currentValue = next;
        ++this._columnIndex;
        if (this._isNullValue(next)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleArrayValue() throws JacksonException {
        int offset = this._arrayValueStart;
        if (offset < 0) {
            this._streamReadContext = this._streamReadContext.clearAndGetParent();
            this._state = 2;
            return JsonToken.END_ARRAY;
        }
        int end = this._arrayValue.indexOf(this._arraySeparator, offset);
        if (end < 0) {
            this._arrayValueStart = end;
            if (offset == 0) {
                if (this._arrayValue.isEmpty() || this._arrayValue.trim().isEmpty()) {
                    this._streamReadContext = this._streamReadContext.clearAndGetParent();
                    this._state = 2;
                    return JsonToken.END_ARRAY;
                }
                this._currentValue = this._arrayValue;
            } else {
                this._currentValue = this._arrayValue.substring(offset);
            }
        } else {
            this._currentValue = this._arrayValue.substring(offset, end);
            this._arrayValueStart = end + this._arraySeparator.length();
        }
        if (this.isEnabled(CsvReadFeature.TRIM_SPACES)) {
            this._currentValue = this._currentValue.trim();
        }
        if (this._isNullValue(this._currentValue)) {
            return JsonToken.VALUE_NULL;
        }
        return JsonToken.VALUE_STRING;
    }

    protected JsonToken _handleExtraColumn(String value) throws JacksonException {
        String next;
        String anyProp = this._schema.getAnyPropertyName();
        if (anyProp != null) {
            this._currentName = anyProp;
            this._state = 3;
            return JsonToken.PROPERTY_NAME;
        }
        this._currentName = null;
        if (CsvReadFeature.IGNORE_TRAILING_UNMAPPABLE.enabledIn(this._formatFeatures)) {
            this._state = 6;
            return this._skipUntilEndOfLine();
        }
        this._state = 6;
        if (this._columnIndex == this._columnCount && CsvReadFeature.ALLOW_TRAILING_COMMA.enabledIn(this._formatFeatures) && (value = value.trim()).isEmpty() && (next = this._reader.nextString()) == null) {
            return this._handleObjectRowEnd();
        }
        return (JsonToken)this._reportCsvReadError("Too many entries: expected at most %d (value #%d (%d chars) \"%s\")", this._columnCount, this._columnIndex, value.length(), value);
    }

    protected JsonToken _handleMissingColumns() throws JacksonException {
        if (CsvReadFeature.FAIL_ON_MISSING_COLUMNS.enabledIn(this._formatFeatures)) {
            this._handleObjectRowEnd();
            return (JsonToken)this._reportCsvReadError("Not enough column values: expected %d, found %d", this._columnCount, this._columnIndex);
        }
        if (CsvReadFeature.INSERT_NULLS_FOR_MISSING_COLUMNS.enabledIn(this._formatFeatures)) {
            this._state = 8;
            this._currentName = this._schema.columnName(this._columnIndex);
            this._currentValue = null;
            return JsonToken.PROPERTY_NAME;
        }
        return this._handleObjectRowEnd();
    }

    protected JsonToken _handleMissingName() throws JacksonException {
        if (++this._columnIndex < this._columnCount) {
            this._state = 8;
            this._currentName = this._schema.columnName(this._columnIndex);
            return JsonToken.PROPERTY_NAME;
        }
        return this._handleObjectRowEnd();
    }

    protected JsonToken _handleMissingValue() throws JacksonException {
        this._state = 7;
        return JsonToken.VALUE_NULL;
    }

    protected final JsonToken _handleObjectRowEnd() throws JacksonException {
        this._streamReadContext = this._streamReadContext.clearAndGetParent();
        this._state = !this._reader.startNewLine() ? 9 : 1;
        return JsonToken.END_OBJECT;
    }

    protected final JsonToken _skipUntilEndOfLine() throws JacksonException {
        while (this._reader.nextString() != null) {
        }
        this._streamReadContext = this._streamReadContext.clearAndGetParent();
        this._state = this._reader.startNewLine() ? 1 : 9;
        return this._updateToken(this._streamReadContext.inArray() ? JsonToken.END_ARRAY : JsonToken.END_OBJECT);
    }

    public boolean hasStringCharacters() {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return false;
        }
        return this._textBuffer.hasTextAsCharacters();
    }

    public String getString() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._currentName;
        }
        return this._currentValue;
    }

    public char[] getStringCharacters() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._currentName.toCharArray();
        }
        return this._textBuffer.contentsAsArray();
    }

    public int getStringLength() throws JacksonException {
        if (this._currToken == JsonToken.PROPERTY_NAME) {
            return this._currentName.length();
        }
        return this._textBuffer.size();
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public int getString(Writer w) throws JacksonException {
        String value;
        String string = value = this._currToken == JsonToken.PROPERTY_NAME ? this._currentName : this._currentValue;
        if (value == null) {
            return 0;
        }
        try {
            w.write(value);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return value.length();
    }

    public Object getEmbeddedObject() throws JacksonException {
        return this._binaryValue;
    }

    public byte[] getBinaryValue(Base64Variant variant) throws JacksonException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (%s) not VALUE_STRING, can not access as binary", this._currToken);
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this._currentValue, builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    public JsonParser.NumberType getNumberType() throws JacksonException {
        if (this._currToken == JsonToken.VALUE_NUMBER_INT) {
            return this._reader.getNumberType();
        }
        return null;
    }

    public Number getNumberValue() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getNumberValue(false);
    }

    public Number getNumberValueExact() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getNumberValue(true);
    }

    public int getIntValue() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getIntValue();
    }

    public long getLongValue() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getLongValue();
    }

    public BigInteger getBigIntegerValue() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getBigIntegerValue();
    }

    public float getFloatValue() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getFloatValue();
    }

    public double getDoubleValue() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getDoubleValue();
    }

    public BigDecimal getDecimalValue() throws JacksonException {
        this._verifyNumberToken();
        return this._reader.getDecimalValue();
    }

    public boolean isNaN() {
        return false;
    }

    protected void _handleEOF() throws StreamReadException {
        this._reportInvalidEOF(": expected closing quote character", null);
    }

    public <T> T _reportCsvReadError(String msg, Object ... args) throws JacksonException {
        if (args.length > 0) {
            msg = String.format(msg, args);
        }
        throw CsvReadException.from(this, msg, this._schema);
    }

    public <T> T _reportUnexpectedCsvChar(int ch, String msg) throws JacksonException {
        return (T)super._reportUnexpectedChar(ch, msg);
    }

    public <T> T _reportError(String msg) throws StreamReadException {
        return (T)super._reportError(msg);
    }

    public JacksonException _wrapIOFailure(IOException e) {
        return super._wrapIOFailure(e);
    }

    protected void _verifyNumberToken() throws JacksonException {
        if (this._currToken != JsonToken.VALUE_NUMBER_INT) {
            this._reportNotNumericError();
        }
    }

    protected <T> T _reportNotNumericError() throws JacksonException {
        this._reportError("Current token (%s) not numeric, cannot use numeric value accessors", this._currToken);
        return null;
    }

    protected void _setSchema(CsvSchema schema) {
        if (schema == null) {
            this._schema = EMPTY_SCHEMA;
        } else {
            this._schema = schema;
            this._nullValue = this._schema.getNullValueString();
        }
        this._columnCount = this._schema.size();
        this._reader.setSchema(this._schema);
    }

    public ByteArrayBuilder _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new ByteArrayBuilder();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected void _startArray(CsvSchema.Column column) {
        this._updateToken(JsonToken.START_ARRAY);
        this._streamReadContext = this._streamReadContext.createChildArrayContext(this._reader.getCurrentRow(), this._reader.getCurrentColumn());
        this._state = 5;
        this._arrayValueStart = 0;
        this._arrayValue = this._currentValue;
        String sep = column.getArrayElementSeparator();
        if (sep.isEmpty()) {
            sep = this._schema.getArrayElementSeparator();
        }
        this._arraySeparator = sep;
    }

    protected boolean _isNullValue(String value) {
        if (this._nullValue != null && this._nullValue.equals(value)) {
            return true;
        }
        if (this._cfgEmptyStringAsNull && value.isEmpty()) {
            return true;
        }
        return this._cfgEmptyUnquotedStringAsNull && value.isEmpty() && !this._reader.isCurrentTokenQuoted();
    }
}

