/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.deser;

import java.io.IOException;
import tools.jackson.core.JsonToken;
import tools.jackson.dataformat.avro.deser.AvroFieldReader;
import tools.jackson.dataformat.avro.deser.AvroParserImpl;
import tools.jackson.dataformat.avro.deser.AvroReadContext;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;

public class ScalarDefaults {

    protected static final class NullDefaults
    extends DefaultsBase {
        public NullDefaults(String name) {
            super(name, null);
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) {
            return JsonToken.VALUE_NULL;
        }
    }

    protected static final class LongDefaults
    extends DefaultsBase {
        protected final long _defaults;

        public LongDefaults(String name, long v) {
            super(name, AvroSchemaHelper.getTypeId(Long.TYPE));
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class IntDefaults
    extends DefaultsBase {
        protected final int _defaults;

        public IntDefaults(String name, int v) {
            super(name, AvroSchemaHelper.getTypeId(Integer.TYPE));
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class FloatDefaults
    extends DefaultsBase {
        protected final float _defaults;

        public FloatDefaults(String name, float v) {
            super(name, AvroSchemaHelper.getTypeId(Float.TYPE));
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class DoubleDefaults
    extends DefaultsBase {
        protected final double _defaults;

        public DoubleDefaults(String name, double v) {
            super(name, AvroSchemaHelper.getTypeId(Double.TYPE));
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) {
            return parser.setNumber(this._defaults);
        }
    }

    protected static final class BytesDefaults
    extends DefaultsBase {
        protected final byte[] _defaults;

        public BytesDefaults(String name, byte[] v) {
            super(name, AvroSchemaHelper.getTypeId(byte[].class));
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) {
            return parser.setBytes(this._defaults);
        }
    }

    protected static final class StringDefaults
    extends DefaultsBase {
        protected final String _defaults;

        public StringDefaults(String name, String v) {
            super(name, AvroSchemaHelper.getTypeId(String.class));
            this._defaults = v;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) throws IOException {
            return parser.setString(this._defaults);
        }
    }

    protected static final class BooleanDefaults
    extends DefaultsBase {
        protected final JsonToken _defaults;

        public BooleanDefaults(String name, boolean v) {
            super(name, AvroSchemaHelper.getTypeId(Boolean.TYPE));
            this._defaults = v ? JsonToken.VALUE_TRUE : JsonToken.VALUE_FALSE;
        }

        @Override
        public JsonToken readValue(AvroReadContext parent, AvroParserImpl parser) {
            return this._defaults;
        }
    }

    protected static abstract class DefaultsBase
    extends AvroFieldReader {
        protected DefaultsBase(String name, String typeId) {
            super(name, false, typeId);
        }

        @Override
        public abstract JsonToken readValue(AvroReadContext var1, AvroParserImpl var2) throws IOException;

        @Override
        public void skipValue(AvroParserImpl parser) throws IOException {
        }
    }
}

