/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.schema;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.reflect.AvroAlias;
import org.apache.avro.reflect.Stringable;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.SimpleLookupCache;
import tools.jackson.dataformat.avro.annotation.AvroNamespace;

public abstract class AvroSchemaHelper {
    private static final ObjectMapper DEFAULT_VALUE_MAPPER = new JsonMapper();
    public static final String AVRO_SCHEMA_PROP_CLASS = "java-class";
    public static final String AVRO_SCHEMA_PROP_KEY_CLASS = "java-key-class";
    public static final String AVRO_SCHEMA_PROP_ELEMENT_CLASS = "java-element-class";
    protected static final Set<Class<?>> STRINGABLE_CLASSES = new HashSet<Class>(Arrays.asList(URI.class, URL.class, File.class, BigInteger.class, BigDecimal.class, String.class));

    public static boolean isStringable(AnnotatedClass type) {
        if (STRINGABLE_CLASSES.contains(type.getRawType()) || Enum.class.isAssignableFrom(type.getRawType())) {
            return true;
        }
        if (type.getAnnotated().getAnnotation(Stringable.class) == null) {
            return false;
        }
        for (AnnotatedConstructor constructor : type.getConstructors()) {
            if (constructor.getParameterCount() != 1 || constructor.getRawParameterType(0) != String.class) continue;
            return true;
        }
        return false;
    }

    protected static String getNamespace(JavaType type, AnnotatedClass annotations) {
        AvroNamespace ann = (AvroNamespace)annotations.getAnnotation(AvroNamespace.class);
        return ann != null ? ann.value() : AvroSchemaHelper.getNamespace(type.getRawClass());
    }

    protected static String getNamespace(Class<?> cls) {
        Class<?> enclosing = cls.getEnclosingClass();
        if (enclosing != null) {
            return enclosing.getName().replace('$', '.');
        }
        Package pkg = cls.getPackage();
        return pkg == null ? "" : pkg.getName();
    }

    protected static String getTypeName(JavaType type) {
        String name = type.getRawClass().getSimpleName();
        if (name.endsWith("[]")) {
            name = name.replaceAll("[]", "Array");
        }
        return name;
    }

    protected static Schema unionWithNull(Schema otherSchema) {
        ArrayList<Schema> schemas = new ArrayList<Schema>();
        schemas.add(Schema.create((Schema.Type)Schema.Type.NULL));
        if (otherSchema.getType() == Schema.Type.UNION) {
            schemas.addAll(otherSchema.getTypes());
        } else {
            schemas.add(otherSchema);
        }
        return Schema.createUnion(schemas);
    }

    public static Schema simpleSchema(JsonFormatTypes type, JavaType hint) {
        switch (type) {
            case BOOLEAN: {
                return Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            }
            case INTEGER: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case NULL: {
                return Schema.create((Schema.Type)Schema.Type.NULL);
            }
            case NUMBER: {
                if (hint != null) {
                    if (hint.hasRawClass(Float.TYPE)) {
                        return Schema.create((Schema.Type)Schema.Type.FLOAT);
                    }
                    if (hint.hasRawClass(Long.TYPE)) {
                        return Schema.create((Schema.Type)Schema.Type.LONG);
                    }
                }
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case STRING: {
                if (hint != null && hint.hasRawClass(UUID.class)) {
                    return AvroSchemaHelper.createUUIDSchema();
                }
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
            case ARRAY: 
            case OBJECT: {
                throw new UnsupportedOperationException("Should not try to create simple Schema for: " + String.valueOf(type));
            }
        }
        throw new UnsupportedOperationException("Can not create Schema for: " + String.valueOf(type) + "; not (yet) supported");
    }

    public static Schema numericAvroSchema(JsonParser.NumberType type) {
        switch (type) {
            case INT: {
                return Schema.create((Schema.Type)Schema.Type.INT);
            }
            case LONG: {
                return Schema.create((Schema.Type)Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create((Schema.Type)Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create((Schema.Type)Schema.Type.DOUBLE);
            }
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                return Schema.create((Schema.Type)Schema.Type.STRING);
            }
        }
        throw new IllegalStateException("Unrecognized number type: " + String.valueOf(type));
    }

    public static Schema numericAvroSchema(JsonParser.NumberType type, JavaType hint) {
        Schema schema = AvroSchemaHelper.numericAvroSchema(type);
        if (hint != null) {
            schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(hint));
        }
        return schema;
    }

    public static Schema typedSchema(Schema.Type nativeType, JavaType javaType) {
        Schema schema = Schema.create((Schema.Type)nativeType);
        schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(javaType));
        return schema;
    }

    public static Schema anyNumberSchema() {
        return Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.INT), Schema.create((Schema.Type)Schema.Type.LONG), Schema.create((Schema.Type)Schema.Type.DOUBLE)));
    }

    public static Schema stringableKeyMapSchema(JavaType mapType, JavaType keyType, Schema valueSchema) {
        Schema schema = Schema.createMap((Schema)valueSchema);
        if (mapType != null && !mapType.hasRawClass(Map.class)) {
            schema.addProp(AVRO_SCHEMA_PROP_CLASS, AvroSchemaHelper.getTypeId(mapType));
        }
        if (keyType != null && !keyType.hasRawClass(String.class)) {
            schema.addProp(AVRO_SCHEMA_PROP_KEY_CLASS, AvroSchemaHelper.getTypeId(keyType));
        }
        return schema;
    }

    protected static <T> T throwUnsupported() {
        throw new UnsupportedOperationException("Format variation not supported");
    }

    public static Schema initializeRecordSchema(MapperConfig<?> config, JavaType type, AnnotatedClass annotations) {
        return AvroSchemaHelper.addAlias(Schema.createRecord((String)AvroSchemaHelper.getTypeName(type), (String)config.getAnnotationIntrospector().findClassDescription(config, annotations), (String)AvroSchemaHelper.getNamespace(type, annotations), (boolean)type.isTypeOrSubTypeOf(Throwable.class)), annotations);
    }

    public static Schema parseJsonSchema(String json) {
        Schema.Parser parser = new Schema.Parser();
        return parser.parse(json);
    }

    public static Schema createEnumSchema(MapperConfig<?> config, JavaType enumType, AnnotatedClass annotations, List<String> values) {
        Schema avroSchema;
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        Class rawEnumClass = enumType.getRawClass();
        Enum defaultEnumValue = intr.findDefaultEnumValue(config, annotations, (Enum[])rawEnumClass.getEnumConstants());
        try {
            avroSchema = Schema.createEnum((String)AvroSchemaHelper.getTypeName(enumType), (String)config.getAnnotationIntrospector().findClassDescription(config, annotations), (String)AvroSchemaHelper.getNamespace(enumType, annotations), values, (String)(defaultEnumValue != null ? defaultEnumValue.toString() : null));
        }
        catch (SchemaParseException spe) {
            String msg = String.format("Problem generating Avro `Schema` for Enum type %s: %s", ClassUtil.getTypeDescription((JavaType)enumType), spe.getMessage());
            throw InvalidDefinitionException.from((JsonGenerator)null, (String)msg, (JavaType)enumType);
        }
        return AvroSchemaHelper.addAlias(avroSchema, annotations);
    }

    public static Schema createUUIDSchema() {
        return Schema.createFixed((String)"UUID", null, (String)"java.util", (int)16);
    }

    public static Schema addAlias(Schema schema, AnnotatedClass annotations) {
        AvroAlias ann = (AvroAlias)annotations.getAnnotation(AvroAlias.class);
        if (ann != null) {
            schema.addAlias(ann.alias(), ann.space().equals("NOT A VALID NAMESPACE") ? null : ann.space());
        }
        return schema;
    }

    public static String getTypeId(JavaType type) {
        return AvroSchemaHelper.getTypeId(type.getRawClass());
    }

    public static String getTypeId(Class<?> type) {
        if (type.isPrimitive()) {
            return ClassUtil.wrapperType(type).getName();
        }
        return type.getName();
    }

    public static String getTypeId(Schema schema) {
        switch (schema.getType()) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                return AvroSchemaHelper.getFullName(schema);
            }
        }
        return schema.getProp(AVRO_SCHEMA_PROP_CLASS);
    }

    public static String getFullName(Schema schema) {
        Schema.Type type = schema.getType();
        switch (type) {
            case RECORD: 
            case ENUM: 
            case FIXED: {
                String namespace = schema.getNamespace();
                String name = schema.getName();
                if (namespace == null) {
                    return name;
                }
                int len = namespace.length();
                if (namespace.charAt(len - 1) == '$') {
                    return namespace + name;
                }
                return FullNameResolver.instance.resolve(namespace, name);
            }
        }
        return type.getName();
    }

    public static JsonNode nullNode() {
        return DEFAULT_VALUE_MAPPER.nullNode();
    }

    public static JsonNode objectToJsonNode(Object defaultValue) {
        if (defaultValue == JsonProperties.NULL_VALUE) {
            return AvroSchemaHelper.nullNode();
        }
        return (JsonNode)DEFAULT_VALUE_MAPPER.convertValue(defaultValue, JsonNode.class);
    }

    public static Object jsonNodeToObject(JsonNode defaultJsonValue) {
        if (defaultJsonValue == null) {
            return null;
        }
        if (defaultJsonValue.isNull()) {
            return JsonProperties.NULL_VALUE;
        }
        return DEFAULT_VALUE_MAPPER.convertValue((Object)defaultJsonValue, Object.class);
    }

    public static JsonNode parseDefaultValue(String defaultValue) throws DatabindException {
        if (defaultValue == null) {
            return null;
        }
        try {
            return DEFAULT_VALUE_MAPPER.readTree(defaultValue);
        }
        catch (JacksonException e) {
            if (e instanceof DatabindException) {
                throw (DatabindException)e;
            }
            throw DatabindException.from((JsonParser)null, (String)"Failed to parse default value", (Throwable)e);
        }
    }

    private static final class FullNameResolver {
        private final SimpleLookupCache<FullNameKey, String> SCHEMA_NAME_CACHE = new SimpleLookupCache(80, 800);
        public static final FullNameResolver instance = new FullNameResolver();

        private FullNameResolver() {
        }

        public String resolve(String namespace, String name) {
            FullNameKey cacheKey = new FullNameKey(namespace, name);
            String schemaName = (String)this.SCHEMA_NAME_CACHE.get((Object)cacheKey);
            if (schemaName == null) {
                schemaName = FullNameResolver._resolve(cacheKey);
                this.SCHEMA_NAME_CACHE.put((Object)cacheKey, (Object)schemaName);
            }
            return schemaName;
        }

        private static String _resolve(FullNameKey key) {
            StringBuilder sb = new StringBuilder(key.nameWithSeparator('.'));
            int lastDot = sb.length();
            while (true) {
                try {
                    String className = sb.toString();
                    Class.forName(className);
                    return className;
                }
                catch (ClassNotFoundException e) {
                    lastDot = sb.lastIndexOf(".", lastDot);
                    if (lastDot == -1) {
                        return key.nameWithSeparator('.');
                    }
                    sb.setCharAt(lastDot, '$');
                    continue;
                }
                break;
            }
        }
    }

    private static final class FullNameKey {
        private final String _namespace;
        private final String _name;
        private final int _hashCode;

        public FullNameKey(String namespace, String name) {
            this._namespace = namespace;
            this._name = name;
            this._hashCode = namespace.hashCode() + name.hashCode();
        }

        public String nameWithSeparator(char sep) {
            return this._namespace + sep + this._name;
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            FullNameKey other = (FullNameKey)o;
            return other._name.equals(this._name) && other._namespace.equals(this._namespace);
        }
    }
}

