/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.avro.reflect.AvroAlias;
import org.apache.avro.reflect.AvroDefault;
import org.apache.avro.reflect.AvroEncode;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.CustomEncoding;
import org.apache.avro.reflect.Nullable;
import org.apache.avro.reflect.Stringable;
import org.apache.avro.reflect.Union;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedConstructor;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.ser.std.ToStringSerializer;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.dataformat.avro.AvroTypeResolverBuilder;
import tools.jackson.dataformat.avro.PackageVersion;
import tools.jackson.dataformat.avro.apacheimpl.CustomEncodingDeserializer;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.ser.CustomEncodingSerializer;

public class AvroAnnotationIntrospector
extends AnnotationIntrospector
implements Serializable {
    private static final long serialVersionUID = 1L;

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean hasIgnoreMarker(MapperConfig<?> config, AnnotatedMember m) {
        return this._findAnnotation((Annotated)m, AvroIgnore.class) != null;
    }

    public PropertyName findNameForSerialization(MapperConfig<?> config, Annotated a) {
        return this._findName(a);
    }

    public PropertyName findNameForDeserialization(MapperConfig<?> config, Annotated a) {
        return this._findName(a);
    }

    public Object findDeserializer(MapperConfig<?> config, Annotated am) {
        AvroEncode ann = (AvroEncode)this._findAnnotation(am, AvroEncode.class);
        if (ann != null) {
            return new CustomEncodingDeserializer((CustomEncoding)ClassUtil.createInstance((Class)ann.using(), (boolean)true));
        }
        return null;
    }

    public String findPropertyDefaultValue(MapperConfig<?> config, Annotated m) {
        AvroDefault ann = (AvroDefault)this._findAnnotation(m, AvroDefault.class);
        return ann == null ? null : ann.value();
    }

    public List<PropertyName> findPropertyAliases(MapperConfig<?> config, Annotated m) {
        AvroAlias ann = (AvroAlias)this._findAnnotation(m, AvroAlias.class);
        if (ann == null) {
            return null;
        }
        return Collections.singletonList(PropertyName.construct((String)ann.alias()));
    }

    protected PropertyName _findName(Annotated a) {
        AvroName ann = (AvroName)this._findAnnotation(a, AvroName.class);
        return ann == null ? null : PropertyName.construct((String)ann.value());
    }

    public Boolean hasRequiredMarker(MapperConfig<?> config, AnnotatedMember m) {
        if (this._hasAnnotation((Annotated)m, Nullable.class)) {
            return Boolean.FALSE;
        }
        return null;
    }

    public JsonCreator.Mode findCreatorAnnotation(MapperConfig<?> config, Annotated a) {
        AnnotatedConstructor constructor;
        Class declClass;
        if (a instanceof AnnotatedConstructor && (declClass = (constructor = (AnnotatedConstructor)a).getDeclaringClass()).getAnnotation(Stringable.class) != null && constructor.getParameterCount() == 1 && String.class.equals((Object)constructor.getRawParameterType(0))) {
            return JsonCreator.Mode.DELEGATING;
        }
        return null;
    }

    public Object findSerializer(MapperConfig<?> config, Annotated a) {
        if (a.hasAnnotation(Stringable.class)) {
            return ToStringSerializer.class;
        }
        AvroEncode ann = (AvroEncode)this._findAnnotation(a, AvroEncode.class);
        if (ann != null) {
            return new CustomEncodingSerializer((CustomEncoding)ClassUtil.createInstance((Class)ann.using(), (boolean)true));
        }
        return null;
    }

    public List<NamedType> findSubtypes(MapperConfig<?> config, Annotated a) {
        Class<?>[] types = this._getUnionTypes(a);
        if (types == null) {
            return null;
        }
        ArrayList<NamedType> names = new ArrayList<NamedType>(types.length);
        for (Class<?> subtype : types) {
            names.add(new NamedType(subtype, AvroSchemaHelper.getTypeId(subtype)));
        }
        return names;
    }

    public Object findTypeResolverBuilder(MapperConfig<?> config, Annotated ann) {
        Class raw = ann.getRawType();
        if (raw == Object.class || this._getUnionTypes(ann) != null) {
            return AvroTypeResolverBuilder.construct(null);
        }
        return null;
    }

    protected Class<?>[] _getUnionTypes(Annotated a) {
        Class[] c;
        Union ann = (Union)this._findAnnotation(a, Union.class);
        if (ann != null && (c = ann.value()).length > 0) {
            return c;
        }
        return null;
    }
}

