/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.ser;

import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import tools.jackson.dataformat.avro.AvroGenerator;
import tools.jackson.dataformat.avro.ser.ArrayWriteContext;
import tools.jackson.dataformat.avro.ser.AvroWriteContext;
import tools.jackson.dataformat.avro.ser.KeyValueContext;

public final class MapWriteContext
extends KeyValueContext {
    protected final Map<String, Object> _data = new HashMap<String, Object>();

    public MapWriteContext(AvroWriteContext parent, AvroGenerator generator, Schema schema, Object currValue) {
        super(parent, generator, schema, currValue);
    }

    @Override
    public Object rawValue() {
        return this._data;
    }

    @Override
    public final boolean writeName(String name) {
        this._currentName = name;
        this._expectValue = true;
        return true;
    }

    @Override
    public final AvroWriteContext createChildArrayContext(Object currValue) {
        this._verifyValueWrite();
        ArrayWriteContext child = new ArrayWriteContext(this, this._generator, this._createArray(this._schema.getValueType()), currValue);
        this._data.put(this._currentName, ((AvroWriteContext)child).rawValue());
        return child;
    }

    @Override
    public final AvroWriteContext createChildObjectContext(Object currValue) {
        this._verifyValueWrite();
        AvroWriteContext child = this._createObjectContext(this._schema.getValueType(), currValue);
        this._data.put(this._currentName, child.rawValue());
        return child;
    }

    @Override
    public void writeValue(Object value) {
        this._verifyValueWrite();
        this._data.put(this._currentName, value);
    }

    @Override
    public void writeString(String value) {
        this._verifyValueWrite();
        this._data.put(this._currentName, value);
    }

    @Override
    public void writeNull() {
        this._verifyValueWrite();
        this._data.put(this._currentName, null);
    }

    protected final void _verifyValueWrite() {
        if (!this._expectValue) {
            throw new IllegalStateException("Expecting FIELD_NAME, not value");
        }
        this._expectValue = false;
    }
}

