/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.schema;

import java.util.Set;
import org.apache.avro.Schema;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.schema.SchemaBuilder;

public class StringVisitor
extends JsonStringFormatVisitor.Base
implements SchemaBuilder {
    protected final SerializationContext _provider;
    protected final JavaType _type;

    public StringVisitor(SerializationContext provider, JavaType type) {
        this._type = type;
        this._provider = provider;
    }

    public void format(JsonValueFormat format) {
    }

    public void enumTypes(Set<String> enums) {
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._type.hasRawClass(Character.TYPE) || this._type.hasRawClass(Character.class)) {
            return AvroSchemaHelper.numericAvroSchema(JsonParser.NumberType.INT, this._type);
        }
        AnnotatedClass annotations = this._provider.introspectClassAnnotations(this._type);
        Schema schema = Schema.create((Schema.Type)Schema.Type.STRING);
        if (AvroSchemaHelper.isStringable(annotations) && !this._type.hasRawClass(String.class)) {
            schema.addProp("java-class", AvroSchemaHelper.getTypeId(this._type));
        }
        return schema;
    }
}

