/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.schema;

import org.apache.avro.Schema;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonMapFormatVisitor;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.schema.SchemaBuilder;
import tools.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;

public class MapVisitor
extends JsonMapFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final VisitorFormatWrapperImpl _visitorWrapper;
    protected Schema _valueSchema;
    protected JavaType _keyType;

    public MapVisitor(SerializationContext p, JavaType type, VisitorFormatWrapperImpl visitorWrapper) {
        super(p);
        this._type = type;
        this._visitorWrapper = visitorWrapper;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._valueSchema == null) {
            throw new IllegalStateException("Missing value type for " + String.valueOf(this._type));
        }
        AnnotatedClass ac = this._provider.introspectClassAnnotations(this._keyType);
        if (AvroSchemaHelper.isStringable(ac)) {
            return AvroSchemaHelper.stringableKeyMapSchema(this._type, this._keyType, this._valueSchema);
        }
        throw new UnsupportedOperationException("Maps with non-stringable keys are not supported (yet?)");
    }

    public void keyFormat(JsonFormatVisitable handler, JavaType keyType) {
        this._keyType = keyType;
    }

    public void valueFormat(JsonFormatVisitable handler, JavaType valueType) {
        VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, valueType);
        this._valueSchema = visitorWrapper.getAvroSchema();
    }
}

