/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.schema;

import java.util.ArrayList;
import java.util.Set;
import org.apache.avro.Schema;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.schema.DefinedSchemas;
import tools.jackson.dataformat.avro.schema.SchemaBuilder;

public class EnumVisitor
extends JsonStringFormatVisitor.Base
implements SchemaBuilder {
    protected final SerializationContext _provider;
    protected final JavaType _type;
    protected final DefinedSchemas _schemas;
    protected Set<String> _enums;

    public EnumVisitor(SerializationContext provider, DefinedSchemas schemas, JavaType t) {
        this._schemas = schemas;
        this._type = t;
        this._provider = provider;
    }

    public void enumTypes(Set<String> enums) {
        this._enums = enums;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._enums == null) {
            throw new IllegalStateException("Possible enum values cannot be null");
        }
        AnnotatedClass annotations = this._provider.introspectClassAnnotations(this._type);
        Schema s = AvroSchemaHelper.createEnumSchema(this._provider.getConfig(), this._type, annotations, new ArrayList<String>(this._enums));
        this._schemas.addSchema(this._type, s);
        return s;
    }
}

