/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.schema;

import java.util.List;
import org.apache.avro.Schema;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.schema.SchemaBuilder;
import tools.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;

public class ArrayVisitor
extends JsonArrayFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final VisitorFormatWrapperImpl _visitorWrapper;
    protected Schema _elementSchema;

    public ArrayVisitor(SerializationContext p, JavaType type, VisitorFormatWrapperImpl visitorWrapper) {
        super(p);
        this._type = type;
        this._visitorWrapper = visitorWrapper;
    }

    @Override
    public Schema builtAvroSchema() {
        if (this._elementSchema == null) {
            throw new IllegalStateException("No element schema created for: " + String.valueOf(this._type));
        }
        Schema schema = Schema.createArray((Schema)this._elementSchema);
        if (!this._type.hasRawClass(List.class)) {
            schema.addProp("java-class", AvroSchemaHelper.getTypeId(this._type));
        }
        return schema;
    }

    public void itemsFormat(JsonFormatVisitable visitable, JavaType type) {
        VisitorFormatWrapperImpl wrapper = this._visitorWrapper.createChildWrapper();
        visitable.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)wrapper, type);
        this._elementSchema = wrapper.getAvroSchema();
    }

    public void itemsFormat(JsonFormatTypes type) {
        this._elementSchema = this._type.hasRawClass(char[].class) ? AvroSchemaHelper.typedSchema(Schema.Type.INT, this._type.getContentType()) : AvroSchemaHelper.simpleSchema(type, this._type.getContentType());
    }
}

