/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.jsr310.ser;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.temporal.Temporal;
import java.util.function.Function;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import tools.jackson.databind.ser.std.StdScalarSerializer;

public class AvroInstantSerializer<T extends Temporal>
extends StdScalarSerializer<T> {
    public static final AvroInstantSerializer<Instant> INSTANT = new AvroInstantSerializer<Instant>(Instant.class, Function.identity());
    public static final AvroInstantSerializer<OffsetDateTime> OFFSET_DATE_TIME = new AvroInstantSerializer<OffsetDateTime>(OffsetDateTime.class, OffsetDateTime::toInstant);
    public static final AvroInstantSerializer<ZonedDateTime> ZONED_DATE_TIME = new AvroInstantSerializer<ZonedDateTime>(ZonedDateTime.class, ChronoZonedDateTime::toInstant);
    private final Function<T, Instant> getInstant;

    protected AvroInstantSerializer(Class<T> t, Function<T, Instant> getInstant) {
        super(t);
        this.getInstant = getInstant;
    }

    public void serialize(T value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
        Instant instant = this.getInstant.apply(value);
        gen.writeNumber(instant.toEpochMilli());
    }

    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JacksonException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }
}

