/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import tools.jackson.databind.DatabindContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.impl.ClassNameIdResolver;

public class AvroTypeIdResolver
extends ClassNameIdResolver {
    private static final long serialVersionUID = 3L;
    private final Map<String, Class<?>> _idTypes = new HashMap();

    public AvroTypeIdResolver(JavaType baseType, PolymorphicTypeValidator stv, Collection<NamedType> subTypes) {
        super(baseType, subTypes, stv);
        if (subTypes != null) {
            for (NamedType namedType : subTypes) {
                this._idTypes.put(namedType.getName(), namedType.getType());
            }
        }
    }

    protected JavaType _typeFromId(DatabindContext ctxt, String id) {
        if (this._baseType.isPrimitive()) {
            return this._baseType;
        }
        Class<?> subType = this._idTypes.get(id);
        if (subType != null) {
            id = this._idFrom(ctxt, null, subType);
        }
        return super._typeFromId(ctxt, id);
    }
}

