/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import java.io.IOException;
import java.io.Writer;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.StreamReadCapability;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.Version;
import tools.jackson.core.base.ParserBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.ByteArrayBuilder;
import tools.jackson.core.util.JacksonFeature;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.core.util.SimpleStreamReadContext;
import tools.jackson.core.util.VersionUtil;
import tools.jackson.dataformat.avro.AvroReadFeature;
import tools.jackson.dataformat.avro.AvroSchema;
import tools.jackson.dataformat.avro.PackageVersion;
import tools.jackson.dataformat.avro.deser.AvroReadContext;
import tools.jackson.dataformat.avro.deser.MissingReader;

public abstract class AvroParser
extends ParserBase {
    protected static final JacksonFeatureSet<StreamReadCapability> AVRO_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES.with((JacksonFeature)StreamReadCapability.EXACT_FLOATS);
    protected AvroSchema _rootSchema;
    protected int _formatFeatures;
    protected SimpleStreamReadContext _streamReadContext;
    protected AvroReadContext _avroContext;

    protected AvroParser(ObjectReadContext readCtxt, IOContext ioCtxt, int parserFeatures, int avroFeatures) {
        super(readCtxt, ioCtxt, parserFeatures);
        this._formatFeatures = avroFeatures;
        this._streamReadContext = SimpleStreamReadContext.createRootContext(null);
        this._avroContext = MissingReader.instance;
    }

    public abstract Object streamReadInputSource();

    public Version version() {
        return PackageVersion.VERSION;
    }

    public boolean canReadTypeId() {
        return true;
    }

    public JacksonFeatureSet<StreamReadCapability> streamReadCapabilities() {
        return AVRO_READ_CAPABILITIES;
    }

    public TokenStreamContext streamReadContext() {
        return this._streamReadContext;
    }

    public void assignCurrentValue(Object v) {
        this._streamReadContext.assignCurrentValue(v);
    }

    public Object currentValue() {
        return this._streamReadContext.currentValue();
    }

    protected abstract void _closeInput() throws IOException;

    public JsonParser enable(AvroReadFeature f) {
        this._formatFeatures |= f.getMask();
        return this;
    }

    public JsonParser disable(AvroReadFeature f) {
        this._formatFeatures &= ~f.getMask();
        return this;
    }

    public JsonParser configure(AvroReadFeature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public boolean isEnabled(AvroReadFeature f) {
        return (this._formatFeatures & f.getMask()) != 0;
    }

    public AvroSchema getSchema() {
        return this._rootSchema;
    }

    protected void setSchema(AvroSchema schema) throws JacksonException {
        if (this._rootSchema == schema) {
            return;
        }
        this._initSchema(schema);
    }

    protected abstract void _initSchema(AvroSchema var1) throws JacksonException;

    public Object getTypeId() throws JacksonException {
        return this._avroContext != null ? this._avroContext.getTypeId() : null;
    }

    public TokenStreamLocation currentTokenLocation() {
        return null;
    }

    public TokenStreamLocation currentLocation() {
        return null;
    }

    public abstract boolean hasStringCharacters();

    public abstract String getString() throws JacksonException;

    public abstract int getString(Writer var1) throws JacksonException;

    public String currentName() throws JacksonException {
        return this._avroContext.currentName();
    }

    public char[] getStringCharacters() throws JacksonException {
        String text = this.getString();
        return text == null ? null : text.toCharArray();
    }

    public int getStringLength() throws JacksonException {
        String text = this.getString();
        return text == null ? 0 : text.length();
    }

    public int getStringOffset() throws JacksonException {
        return 0;
    }

    public Object getEmbeddedObject() throws JacksonException {
        return this._binaryValue;
    }

    public byte[] getBinaryValue(Base64Variant variant) throws JacksonException {
        if (this._binaryValue == null) {
            if (this._currToken != JsonToken.VALUE_STRING) {
                this._reportError("Current token (" + String.valueOf(this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            ByteArrayBuilder builder = this._getByteArrayBuilder();
            this._decodeBase64(this.getString(), builder, variant);
            this._binaryValue = builder.toByteArray();
        }
        return this._binaryValue;
    }

    protected void _parseNumericValue(int expType) throws JacksonException {
        VersionUtil.throwInternal();
    }

    protected int _parseIntValue() throws JacksonException {
        VersionUtil.throwInternal();
        return 0;
    }
}

