/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.EncoderFactory;
import tools.jackson.core.Base64Variant;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamWriteCapability;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.core.TokenStreamContext;
import tools.jackson.core.Version;
import tools.jackson.core.base.GeneratorBase;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.util.JacksonFeatureSet;
import tools.jackson.dataformat.avro.AvroSchema;
import tools.jackson.dataformat.avro.AvroWriteFeature;
import tools.jackson.dataformat.avro.PackageVersion;
import tools.jackson.dataformat.avro.apacheimpl.ApacheCodecRecycler;
import tools.jackson.dataformat.avro.ser.AvroWriteContext;
import tools.jackson.dataformat.avro.ser.EncodedDatum;

public class AvroGenerator
extends GeneratorBase {
    protected static final EncoderFactory ENCODER_FACTORY = EncoderFactory.get();
    protected ApacheCodecRecycler _apacheCodecRecycler;
    protected int _formatWriteFeatures;
    protected final AvroSchema _rootSchema;
    protected final OutputStream _output;
    protected AvroWriteContext _rootContext;
    protected AvroWriteContext _streamWriteContext;
    protected BinaryEncoder _encoder;
    protected boolean _complete;

    public AvroGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, int streamWriteFeatures, int avroFeatures, ApacheCodecRecycler apacheCodecRecycler, AvroSchema schema, OutputStream output) throws JacksonException {
        super(writeCtxt, ioCtxt, streamWriteFeatures);
        this._formatWriteFeatures = avroFeatures;
        this._output = output;
        this._streamWriteContext = AvroWriteContext.nullContext();
        this._apacheCodecRecycler = apacheCodecRecycler;
        boolean buffering = this.isEnabled(AvroWriteFeature.AVRO_BUFFERING);
        BinaryEncoder encoderToReuse = apacheCodecRecycler.acquireEncoder();
        this._encoder = buffering ? ENCODER_FACTORY.binaryEncoder(output, encoderToReuse) : ENCODER_FACTORY.directBinaryEncoder(output, encoderToReuse);
        this._rootSchema = Objects.requireNonNull(schema, "Can not pass `null` 'schema'");
        this._streamWriteContext = this._rootContext = AvroWriteContext.createRootContext(this, schema.getAvroSchema(), this._encoder);
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public TokenStreamContext streamWriteContext() {
        return this._streamWriteContext;
    }

    public Object currentValue() {
        return this._streamWriteContext.currentValue();
    }

    public void assignCurrentValue(Object v) {
        this._streamWriteContext.assignCurrentValue(v);
    }

    public Object streamWriteOutputTarget() {
        return this._output;
    }

    public int streamWriteOutputBuffered() {
        return -1;
    }

    public AvroSchema getSchema() {
        return this._rootSchema;
    }

    public JacksonFeatureSet<StreamWriteCapability> streamWriteCapabilities() {
        return DEFAULT_BINARY_WRITE_CAPABILITIES;
    }

    public AvroGenerator enable(AvroWriteFeature f) {
        this._formatWriteFeatures |= f.getMask();
        return this;
    }

    public AvroGenerator disable(AvroWriteFeature f) {
        this._formatWriteFeatures &= ~f.getMask();
        return this;
    }

    public final boolean isEnabled(AvroWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    public AvroGenerator configure(AvroWriteFeature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
        return this;
    }

    public JsonGenerator writeName(String name) throws JacksonException {
        try {
            this._streamWriteContext.writeName(name);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeName(SerializableString name) throws JacksonException {
        try {
            this._streamWriteContext.writeName(name.getValue());
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writePropertyId(long id) throws JacksonException {
        try {
            String idStr = Long.valueOf(id).toString();
            this._streamWriteContext.writeName(idStr);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public final void flush() {
        if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
            try {
                this._output.flush();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }

    protected void _closeInput() throws IOException {
        if (this.isEnabled(StreamWriteFeature.AUTO_CLOSE_CONTENT)) {
            AvroWriteContext ctxt;
            while ((ctxt = this._streamWriteContext) != null) {
                if (ctxt.inArray()) {
                    this.writeEndArray();
                    continue;
                }
                if (!ctxt.inObject()) break;
                this.writeEndObject();
            }
        }
        if (!this._complete) {
            try {
                this._complete();
            }
            catch (Exception e) {
                throw this._constructWriteException("Failed to close AvroGenerator: (" + e.getClass().getName() + "): " + e.getMessage(), e);
            }
        }
        if (this._output != null) {
            if (this._ioContext.isResourceManaged() || this.isEnabled(StreamWriteFeature.AUTO_CLOSE_TARGET)) {
                this._output.close();
            } else if (this.isEnabled(StreamWriteFeature.FLUSH_PASSED_TO_STREAM)) {
                this._output.flush();
            }
        }
    }

    public JsonGenerator writeStartArray() throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(null);
        this._complete = false;
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue) throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(currValue);
        this._complete = false;
        return this;
    }

    public JsonGenerator writeStartArray(Object currValue, int len) throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.createChildArrayContext(currValue);
        this._complete = false;
        return this;
    }

    public JsonGenerator writeEndArray() throws JacksonException {
        if (!this._streamWriteContext.inArray()) {
            this._reportError("Current context not Array but " + this._streamWriteContext.typeDesc());
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        if (this._streamWriteContext.inRoot() && !this._complete) {
            this._complete();
        }
        return this;
    }

    public JsonGenerator writeStartObject() throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(null);
        this._complete = false;
        return this;
    }

    public JsonGenerator writeStartObject(Object forValue) throws JacksonException {
        this._streamWriteContext = this._streamWriteContext.createChildObjectContext(forValue);
        this._complete = false;
        return this;
    }

    public JsonGenerator writeEndObject() throws JacksonException {
        if (!this._streamWriteContext.inObject()) {
            this._reportError("Current context not Object but " + this._streamWriteContext.typeDesc());
        }
        if (!this._streamWriteContext.canClose()) {
            this._reportError("Can not write END_OBJECT after writing FIELD_NAME but not value");
        }
        this._streamWriteContext = this._streamWriteContext.getParent();
        if (this._streamWriteContext.inRoot() && !this._complete) {
            this._complete();
        }
        return this;
    }

    public JsonGenerator writeString(String text) throws JacksonException {
        if (text == null) {
            return this.writeNull();
        }
        try {
            this._streamWriteContext.writeString(text);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeString(char[] text, int offset, int len) throws JacksonException {
        return this.writeString(new String(text, offset, len));
    }

    public JsonGenerator writeString(SerializableString sstr) throws JacksonException {
        return this.writeString(sstr.toString());
    }

    public JsonGenerator writeRawUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeUTF8String(byte[] text, int offset, int len) throws JacksonException {
        return this.writeString(new String(text, offset, len, StandardCharsets.UTF_8));
    }

    public JsonGenerator writeEmbeddedObject(Object object) throws JacksonException {
        if (object instanceof EncodedDatum) {
            try {
                this._streamWriteContext.writeValue(object);
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
            return this;
        }
        return super.writeEmbeddedObject(object);
    }

    public JsonGenerator writeRaw(String text) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(String text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRaw(char c) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(String text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeRawValue(char[] text, int offset, int len) throws JacksonException {
        return (JsonGenerator)this._reportUnsupportedOperation();
    }

    public JsonGenerator writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws JacksonException {
        if (data == null) {
            return this.writeNull();
        }
        try {
            this._streamWriteContext.writeBinary(data, offset, len);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeBoolean(boolean state) throws JacksonException {
        try {
            this._streamWriteContext.writeValue(state ? Boolean.TRUE : Boolean.FALSE);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNull() throws JacksonException {
        try {
            this._streamWriteContext.writeNull();
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(short v) throws JacksonException {
        try {
            this._streamWriteContext.writeValue(v);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(int v) throws JacksonException {
        try {
            this._streamWriteContext.writeValue(v);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(long v) throws JacksonException {
        try {
            this._streamWriteContext.writeValue(v);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(BigInteger v) throws JacksonException {
        if (v == null) {
            return this.writeNull();
        }
        try {
            this._streamWriteContext.writeValue(v);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(double d) throws JacksonException {
        try {
            this._streamWriteContext.writeValue(d);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(float f) throws JacksonException {
        try {
            this._streamWriteContext.writeValue(Float.valueOf(f));
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(BigDecimal dec) throws JacksonException {
        try {
            if (dec == null) {
                return this.writeNull();
            }
            this._streamWriteContext.writeValue(dec);
        }
        catch (IOException e) {
            throw this._wrapIOFailure(e);
        }
        return this;
    }

    public JsonGenerator writeNumber(String encodedValue) throws JacksonException {
        if (encodedValue == null) {
            return this.writeNull();
        }
        throw new UnsupportedOperationException("Can not write 'untyped' numbers");
    }

    protected final void _verifyValueWrite(String typeMsg) throws JacksonException {
        this._throwInternal();
    }

    protected void _releaseBuffers() {
        ApacheCodecRecycler recycler = this._apacheCodecRecycler;
        if (recycler != null) {
            this._apacheCodecRecycler = null;
            BinaryEncoder e = this._encoder;
            if (e != null) {
                this._encoder = null;
                recycler.release(e);
            }
            recycler.releaseToPool();
        }
    }

    protected void _complete() throws JacksonException {
        this._complete = true;
        if (this._rootContext != null) {
            try {
                this._rootContext.complete();
            }
            catch (IOException e) {
                throw this._wrapIOFailure(e);
            }
        }
    }
}

