/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.dataformat.avro.schema;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.reflect.AvroMeta;
import org.apache.avro.reflect.AvroSchema;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitable;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsonFormatVisitors.JsonObjectFormatVisitor;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.dataformat.avro.AvroFactory;
import tools.jackson.dataformat.avro.AvroWriteFeature;
import tools.jackson.dataformat.avro.annotation.AvroDecimal;
import tools.jackson.dataformat.avro.annotation.AvroFixedSize;
import tools.jackson.dataformat.avro.schema.AvroSchemaHelper;
import tools.jackson.dataformat.avro.schema.SchemaBuilder;
import tools.jackson.dataformat.avro.schema.VisitorFormatWrapperImpl;
import tools.jackson.dataformat.avro.ser.CustomEncodingSerializer;

public class RecordVisitor
extends JsonObjectFormatVisitor.Base
implements SchemaBuilder {
    protected final JavaType _type;
    protected final VisitorFormatWrapperImpl _visitorWrapper;
    protected final boolean _overridden;
    protected final boolean _cfgAddNullDefaults;
    private final Schema _typeSchema;
    protected final Schema _avroSchema;
    protected final List<Schema.Field> _fields = new ArrayList<Schema.Field>();

    public RecordVisitor(SerializationContext ctxt, JavaType type, VisitorFormatWrapperImpl visitorWrapper) {
        super(ctxt);
        this._type = type;
        this._visitorWrapper = visitorWrapper;
        AvroFactory avroFactory = (AvroFactory)ctxt.tokenStreamFactory();
        this._cfgAddNullDefaults = avroFactory.isEnabled(AvroWriteFeature.ADD_NULL_AS_DEFAULT_VALUE_IN_SCHEMA);
        SerializationConfig config = ctxt.getConfig();
        AnnotatedClass annotations = ctxt.introspectDirectClassAnnotations(this._type);
        AnnotationIntrospector intr = ctxt.getAnnotationIntrospector();
        AvroSchema ann = (AvroSchema)annotations.getAnnotation(AvroSchema.class);
        if (ann != null) {
            this._avroSchema = AvroSchemaHelper.parseJsonSchema(ann.value());
            this._overridden = true;
            this._typeSchema = null;
        } else {
            List subTypes;
            this._typeSchema = AvroSchemaHelper.initializeRecordSchema(ctxt.getConfig(), this._type, annotations);
            this._overridden = false;
            AvroMeta meta = (AvroMeta)annotations.getAnnotation(AvroMeta.class);
            if (meta != null) {
                this._typeSchema.addProp(meta.key(), meta.value());
            }
            if ((subTypes = intr.findSubtypes((MapperConfig)config, (Annotated)annotations)) != null && !subTypes.isEmpty()) {
                HashSet<Class> alreadySeenClasses = new HashSet<Class>();
                alreadySeenClasses.add(this._type.getRawClass());
                Set unionSchemas = Collections.newSetFromMap(new IdentityHashMap());
                if (this._type.isConcrete()) {
                    unionSchemas.add(this._typeSchema);
                }
                for (NamedType subType : subTypes) {
                    if (!alreadySeenClasses.add(subType.getType())) continue;
                    ValueSerializer ser = ctxt.findValueSerializer(subType.getType());
                    VisitorFormatWrapperImpl visitor = this._visitorWrapper.createChildWrapper();
                    ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitor, ctxt.constructType((Type)subType.getType()));
                    Schema subTypeSchema = visitor.getAvroSchema();
                    if (subTypeSchema.getType() == Schema.Type.UNION) {
                        unionSchemas.addAll(subTypeSchema.getTypes());
                        continue;
                    }
                    unionSchemas.add(subTypeSchema);
                }
                this._avroSchema = Schema.createUnion(new ArrayList(unionSchemas));
            } else {
                this._avroSchema = this._typeSchema;
            }
        }
        this._visitorWrapper.getSchemas().addSchema(type, this._avroSchema);
    }

    @Override
    public Schema builtAvroSchema() {
        if (!this._overridden) {
            this._typeSchema.setFields(this._fields);
        }
        return this._avroSchema;
    }

    public void property(BeanProperty writer) {
        if (this._overridden) {
            return;
        }
        this._fields.add(this.schemaFieldForWriter(writer, false));
    }

    public void property(String name, JsonFormatVisitable handler, JavaType type) {
        if (this._overridden) {
            return;
        }
        VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, type);
        Schema schema = visitorWrapper.getAvroSchema();
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    public void optionalProperty(BeanProperty writer) {
        if (this._overridden) {
            return;
        }
        this._fields.add(this.schemaFieldForWriter(writer, true));
    }

    public void optionalProperty(String name, JsonFormatVisitable handler, JavaType type) {
        if (this._overridden) {
            return;
        }
        VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
        handler.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, type);
        Schema schema = visitorWrapper.getAvroSchema();
        if (!type.isPrimitive()) {
            schema = AvroSchemaHelper.unionWithNull(schema);
        }
        this._fields.add(new Schema.Field(name, schema, null, null));
    }

    protected Schema.Field schemaFieldForWriter(BeanProperty prop, boolean optional) {
        List aliases;
        Schema writerSchema = null;
        AvroSchema schemaOverride = (AvroSchema)prop.getAnnotation(AvroSchema.class);
        if (schemaOverride != null) {
            Schema.Parser parser = new Schema.Parser();
            writerSchema = parser.parse(schemaOverride.value());
        } else {
            AvroDecimal avroDecimal;
            AvroFixedSize fixedSize = (AvroFixedSize)prop.getAnnotation(AvroFixedSize.class);
            if (fixedSize != null) {
                writerSchema = Schema.createFixed((String)fixedSize.typeName(), null, (String)fixedSize.typeNamespace(), (int)fixedSize.size());
            }
            if (this._visitorWrapper.isLogicalTypesEnabled() && (avroDecimal = (AvroDecimal)prop.getAnnotation(AvroDecimal.class)) != null) {
                if (writerSchema == null) {
                    writerSchema = Schema.create((Schema.Type)Schema.Type.BYTES);
                }
                writerSchema = LogicalTypes.decimal((int)avroDecimal.precision(), (int)avroDecimal.scale()).addToSchema(writerSchema);
            }
            if (writerSchema == null) {
                ValueSerializer ser = null;
                if (prop instanceof BeanPropertyWriter) {
                    BeanPropertyWriter bpw = (BeanPropertyWriter)prop;
                    ser = bpw.getSerializer();
                    optional = optional && !(ser instanceof CustomEncodingSerializer);
                }
                SerializationContext prov = this.getContext();
                if (ser == null) {
                    if (prov == null) {
                        throw DatabindException.from((SerializationContext)prov, (String)"SerializationContext missing for RecordVisitor");
                    }
                    ser = prov.findPrimaryPropertySerializer(prop.getType(), prop);
                }
                VisitorFormatWrapperImpl visitorWrapper = this._visitorWrapper.createChildWrapper();
                ser.acceptJsonFormatVisitor((JsonFormatVisitorWrapper)visitorWrapper, prop.getType());
                writerSchema = visitorWrapper.getAvroSchema();
            }
            if (optional && !prop.getType().isPrimitive()) {
                writerSchema = AvroSchemaHelper.unionWithNull(writerSchema);
            }
        }
        JsonNode defaultValue = AvroSchemaHelper.parseDefaultValue(prop.getMetadata().getDefaultValue());
        if (this._cfgAddNullDefaults && defaultValue == null && writerSchema.getType() == Schema.Type.UNION && writerSchema.getIndexNamed(Schema.Type.NULL.getName()) != null) {
            defaultValue = AvroSchemaHelper.nullNode();
        } else {
            writerSchema = this.reorderUnionToMatchDefaultType(writerSchema, defaultValue);
        }
        Schema.Field field = new Schema.Field(prop.getName(), writerSchema, prop.getMetadata().getDescription(), AvroSchemaHelper.jsonNodeToObject(defaultValue));
        AvroMeta meta = (AvroMeta)prop.getAnnotation(AvroMeta.class);
        if (meta != null) {
            field.addProp(meta.key(), meta.value());
        }
        if (!(aliases = prop.findAliases((MapperConfig)this.getContext().getConfig())).isEmpty()) {
            for (PropertyName pn : aliases) {
                field.addAlias(pn.getSimpleName());
            }
        }
        return field;
    }

    protected Schema reorderUnionToMatchDefaultType(Schema schema, JsonNode defaultValue) {
        if (schema == null || defaultValue == null || schema.getType() != Schema.Type.UNION) {
            return schema;
        }
        ArrayList<Schema> types = new ArrayList<Schema>(schema.getTypes());
        Integer matchingIndex = null;
        if (defaultValue.isArray()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.ARRAY.getName());
        } else if (defaultValue.isObject()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.MAP.getName());
            if (matchingIndex == null) {
                for (i = 0; i < types.size(); ++i) {
                    if (((Schema)types.get(i)).getType() != Schema.Type.RECORD) continue;
                    matchingIndex = i;
                    break;
                }
            }
        } else if (defaultValue.isBoolean()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.BOOLEAN.getName());
        } else if (defaultValue.isNull()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.NULL.getName());
        } else if (defaultValue.isBinary()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.BYTES.getName());
        } else if (defaultValue.isFloatingPointNumber()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.DOUBLE.getName());
            if (matchingIndex == null) {
                matchingIndex = schema.getIndexNamed(Schema.Type.FLOAT.getName());
            }
        } else if (defaultValue.isIntegralNumber()) {
            matchingIndex = schema.getIndexNamed(Schema.Type.LONG.getName());
            if (matchingIndex == null) {
                matchingIndex = schema.getIndexNamed(Schema.Type.INT.getName());
            }
        } else if (defaultValue.isString() && (matchingIndex = schema.getIndexNamed(Schema.Type.STRING.getName())) == null) {
            for (i = 0; i < types.size(); ++i) {
                if (((Schema)types.get(i)).getType() != Schema.Type.ENUM) continue;
                matchingIndex = i;
                break;
            }
        }
        if (matchingIndex != null) {
            types.add(0, (Schema)types.remove(matchingIndex));
            Map jsonProps = schema.getObjectProps();
            schema = Schema.createUnion(types);
            for (String property : jsonProps.keySet()) {
                schema.addProp(property, jsonProps.get(property));
            }
        }
        return schema;
    }
}

